/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli;

import X10Gimli.GUIApplication.LogViewer;
import X10Gimli.GUIApplication.SystemLaunch;
import X10Gimli.SystemProperties;

public class X10GimliLaunch {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            SystemLaunch systemLaunch = new SystemLaunch();
        } else if (args.length == 1 && args[0].equalsIgnoreCase("-?")) {
            System.out.println("usage: X10GimliLaunch [-g] [-l] [{filename}]");
            System.out.println("   -g : Starts the GUI launch system");
            System.out.println("   -l : Starts and attaches the log viewer");
            System.out.println("   filename : name of properties file to use");
        } else if (args.length >= 1) {
            int paramoffset = 0;
            int porder = 0;
            boolean dashG = false;
            boolean dashL = false;
            String fname = null;
            while (paramoffset < args.length) {
                if (args[paramoffset].equalsIgnoreCase("-g") && !dashG) {
                    dashG = true;
                    ++paramoffset;
                    continue;
                }
                if (args[paramoffset].equalsIgnoreCase("-l") && !dashL) {
                    dashL = true;
                    ++paramoffset;
                    continue;
                }
                switch (porder) {
                    case 0: {
                        fname = args[paramoffset];
                        break;
                    }
                    default: {
                        System.out.println("Invalid untagged parameter.  Use the -? parameter for help.");
                        System.exit(0);
                    }
                }
                ++porder;
                ++paramoffset;
            }
            if (dashG) {
                SystemLaunch sys = new SystemLaunch();
                sys.setProperties(fname);
                if (dashL) {
                    sys.startLog();
                }
            } else {
                if (dashL) {
                    LogViewer.main(new String[]{"-localhost"});
                }
                SystemProperties s = new SystemProperties();
                if (fname != null) {
                    s = new SystemProperties(fname);
                }
                s.load();
                SystemLaunch.runX10Gimli(s);
            }
        }
    }
}

