/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import tools.Control;
import tools.ImageFamily;
import tools.TraceMonitor;
import tools.TypeConverter;
import tools.VarMonitor;

public final class IButton
extends Control {
    String label;
    String simage;
    String href;
    String xAlign;
    String yAlign;
    int thickness = 1;
    ImageFamily img;
    String[] lines;
    boolean pressed;

    void getProps(Component component) {
        super.getProps(component);
        this.label = this.getParameter("label");
        if (this.label == null) {
            this.label = "";
        }
        this.parseLabel();
        this.simage = this.getParameter("image");
        this.img = new ImageFamily(this.simage, this);
        this.xAlign = this.getParameter("xAlign");
        if (this.xAlign == null) {
            this.xAlign = "center";
        }
        this.yAlign = this.getParameter("yAlign");
        if (this.yAlign == null) {
            this.yAlign = "center";
        }
        this.thickness = TypeConverter.toInteger(this.getParameter("thickness"));
        this.href = this.getParameter("href");
    }

    public Object get(String string) {
        if (string == null || "label".equals(string)) {
            return this.label;
        }
        if ("image".equals(string)) {
            return this.simage;
        }
        if ("xAlign".equals(string)) {
            return this.xAlign;
        }
        if ("yAlign".equals(string)) {
            return this.yAlign;
        }
        if ("href".equals(string)) {
            return this.href;
        }
        if ("thickness".equals(string)) {
            return new Integer(this.thickness);
        }
        return super.get(string);
    }

    protected void set(Component component, Object object, String string) {
        if (string == null || "label".equals(string)) {
            String string2;
            String string3 = object == null ? "" : (string2 = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            if (!string2.equals(this.label)) {
                this.label = string2;
                this.parseLabel();
                this.repaint();
            }
            return;
        }
        if ("image".equals(string)) {
            String string4;
            String string5 = object == null ? "" : (string4 = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            if (!string4.equals(this.simage)) {
                this.simage = string4;
                this.img = new ImageFamily(this.simage, this);
                this.repaint();
            }
            return;
        }
        if ("xAlign".equals(string)) {
            String string6;
            String string7 = object == null ? "" : (string6 = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            if (!string6.equals(this.xAlign)) {
                this.xAlign = string6;
                this.repaint();
            }
            return;
        }
        if ("yAlign".equals(string)) {
            String string8;
            String string9 = object == null ? "" : (string8 = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            if (!string8.equals(this.yAlign)) {
                this.yAlign = string8;
                this.repaint();
            }
            return;
        }
        if ("href".equals(string)) {
            this.href = object == null ? null : (object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false)));
            this.repaint();
            return;
        }
        if ("thickness".equals(string)) {
            this.thickness = TypeConverter.toInteger(object);
            this.repaint();
            return;
        }
        super.set(component, object, string);
    }

    void parseLabel() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.label.length()) {
            if (this.label.charAt(n2) == '~') {
                ++n;
            }
            ++n2;
        }
        this.lines = new String[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 <= this.label.length()) {
            if (n5 == this.label.length() || this.label.charAt(n5) == '~') {
                this.lines[n4++] = this.label.substring(n3, n5).trim();
                n3 = n5 + 1;
            }
            ++n5;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.pressed = true;
        if (this.disabled || this.hidden) {
            return true;
        }
        this.repaint();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.pressed = false;
        if (this.disabled || this.hidden) {
            return true;
        }
        this.repaint();
        String string = this.href;
        VarMonitor.radio(this);
        TraceMonitor.event(this.getName());
        TraceMonitor.eventGo(string);
        return true;
    }

    void doUpdate(Graphics graphics) {
        Color color;
        int n;
        int n2;
        int n3;
        boolean bl;
        if (this.hidden) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.w, this.h);
            return;
        }
        boolean bl2 = bl = this.href != null;
        graphics.setColor(this.backColor == null ? Color.lightGray : (this.entered && bl && !this.disabled ? this.getBrighterColor(this.backColor) : this.backColor));
        graphics.fillRect(0, 0, this.w, this.h);
        int n4 = this.thickness;
        if (n4 < 1) {
            n4 = 1;
        }
        if (n4 > this.w / 2) {
            n4 = this.w / 2;
        }
        if (n4 > this.h / 2) {
            n4 = this.h / 2;
        }
        int n5 = bl && this.pressed ? n4 : 0;
        ImageFamily imageFamily = this.img;
        Image image = null;
        if (imageFamily != null) {
            imageFamily.setBack(this.backColor);
            image = imageFamily.getSource();
            if (bl && this.entered) {
                image = imageFamily.getBright();
            }
            if (this.disabled) {
                image = imageFamily.getContour();
            }
        }
        if (image != null) {
            int n6 = image.getWidth(this);
            n3 = image.getHeight(this);
            n2 = (this.w - n6) / 2;
            if ("right".equals(this.xAlign)) {
                n2 = n4 + (this.w - 2 * n4 < n6 ? 0 : 3);
            }
            if ("left".equals(this.xAlign)) {
                n2 = this.w - n6 - n4 - (this.w - 2 * n4 < n6 ? 0 : 3);
            }
            n = (this.h - n3) / 2;
            if ("bottom".equals(this.yAlign)) {
                n = n4 + (this.h - 2 * n4 < n3 ? 0 : 3);
            }
            if ("top".equals(this.yAlign)) {
                n = this.h - n3 - n4 - (this.h - 2 * n4 < n3 ? 0 : 3);
            }
            graphics.drawImage(image, n2 + n5, n + n5, this);
        }
        String[] stringArray = this.lines;
        n3 = this.fontSize * 2 / 3 + 2;
        n2 = n3 * stringArray.length;
        n = (this.h - n2 + 2) / 2 + n3 - 2;
        if ("bottom".equals(this.yAlign)) {
            n = this.h - n2 + n3 - 5 - n4;
        }
        if ("top".equals(this.yAlign)) {
            n = n3 + 1 + n4;
        }
        graphics.setFont(this.createFont());
        int n7 = 0;
        while (n7 < stringArray.length) {
            int n8 = graphics.getFontMetrics().stringWidth(stringArray[n7]);
            int n9 = (this.w - n8) / 2;
            if ("right".equals(this.xAlign)) {
                n9 = this.w - n8 - 5 - n4;
            }
            if ("left".equals(this.xAlign)) {
                n9 = 5 + n4;
            }
            if (this.disabled) {
                color = this.backColor == null ? Color.lightGray : this.backColor;
                Color color2 = color.darker();
                Color color3 = color.brighter();
                graphics.setColor(color3);
                graphics.drawString(stringArray[n7], n9 + n5, n + n5);
                graphics.setColor(color2);
                graphics.drawString(stringArray[n7], n9 - 1 + n5, n - 1 + n5);
            } else if (this.foreColor != null) {
                graphics.setColor(this.foreColor);
                graphics.drawString(stringArray[n7], n9 + n5, n + n5);
            }
            ++n7;
            n += n3;
        }
        if (bl && !this.disabled) {
            Color color4 = this.backColor == null ? Color.lightGray : this.backColor;
            Color color5 = color4 == Color.black ? Color.black : color4.darker();
            color = color4 == Color.black ? Color.white : color4.brighter();
            graphics.setColor(this.pressed ? color5 : color);
            int n10 = 0;
            while (n10 < n4) {
                graphics.drawLine(n10, n10, n10, this.h - 1 - n10);
                graphics.drawLine(n10, n10, this.w - 1 - n10, n10);
                ++n10;
            }
            graphics.setColor(!this.pressed ? color5 : color);
            int n11 = 0;
            while (n11 < n4) {
                graphics.drawLine(this.w - 1 - n11, 1 + n11, this.w - 1 - n11, this.h - 1 - n11);
                graphics.drawLine(1 + n11, this.h - 1 - n11, this.w - 1 - n11, this.h - 1 - n11);
                ++n11;
            }
        }
    }
}

