/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.List;
import tools.Control;
import tools.ImageFamily;
import tools.TypeConverter;

public final class Select
extends Control {
    static final int IMAGE = 0;
    static final int COMBO = 1;
    static final int LIST = 2;
    int mode = 0;
    int index;
    String[] txt;
    String[] val;
    ImageFamily[] img;
    String items;
    String smode;
    String item;
    boolean pressed;

    public String getRadioField() {
        return "index";
    }

    Component createComponent() {
        if (this.smode == null) {
            this.smode = this.getParameter("mode");
        }
        if (this.smode == null) {
            this.smode = "image";
        }
        Component component = null;
        if ("combo".equals(this.smode)) {
            this.mode = 1;
            component = new Choice();
        } else if ("list".equals(this.smode)) {
            this.mode = 2;
            component = new List();
        } else {
            this.mode = 0;
            component = null;
        }
        this.repaint();
        return component;
    }

    void getProps(Component component) {
        String string;
        super.getProps(component);
        this.items = this.getParameter("items");
        if (this.items == null) {
            this.items = "||/common/misc/false.png~||/common/misc/true.png";
        }
        if ((string = this.getParameter("index")) != null) {
            this.index = TypeConverter.toInteger(string);
        }
        this.item = this.getParameter("item");
    }

    void setProps(Component component) {
        super.setProps(component);
        this.parseItems(component);
        if (this.item != null) {
            this.item2index(this.item);
            this.item = null;
        }
        this.setIndex(component);
    }

    public Object get(String string) {
        if (string == null || "item".equals(string)) {
            return this.val[this.index];
        }
        if ("index".equals(string)) {
            return new Integer(this.index);
        }
        if ("items".equals(string)) {
            return this.items;
        }
        if ("mode".equals(string)) {
            return this.smode;
        }
        return super.get(string);
    }

    protected void set(Component component, Object object, String string) {
        if (string == null || "item".equals(string)) {
            String string2 = (object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false))).trim();
            if (!string2.equals(this.val[this.index])) {
                this.item2index(string2);
                this.setIndex(component);
            }
            return;
        }
        if ("index".equals(string)) {
            int n = TypeConverter.toInteger(object);
            if (n != this.index) {
                this.index = n;
                this.setIndex(component);
            }
            return;
        }
        if ("items".equals(string)) {
            String string3;
            String string4 = object == null ? "" : (string3 = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            if (!string3.equals(this.items)) {
                this.items = string3;
                this.index = 0;
                this.recreateComponent();
            }
            return;
        }
        if ("mode".equals(string)) {
            String string5;
            String string6 = object == null ? "" : (string5 = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            if (!string5.equals(this.smode)) {
                this.smode = string5;
                this.recreateComponent();
            }
            return;
        }
        super.set(component, object, string);
    }

    void parseItems(Component component) {
        int n = 1;
        int n2 = 0;
        while (n2 < this.items.length()) {
            if (this.items.charAt(n2) == '~') {
                ++n;
            }
            ++n2;
        }
        this.val = new String[n];
        this.txt = new String[n];
        this.img = new ImageFamily[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 <= this.items.length()) {
            if (n5 == this.items.length() || this.items.charAt(n5) == '~') {
                this.parseItem(component, this.items.substring(n3, n5), n4++);
                n3 = n5 + 1;
            }
            ++n5;
        }
    }

    void parseItem(Component component, String string, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 <= string.length()) {
            if (n4 == string.length() || string.charAt(n4) == '|') {
                String string2 = string.substring(n2, n4).trim();
                if (n3 == 0) {
                    this.val[n] = string2;
                }
                if (n3 == 1) {
                    this.txt[n] = string2;
                }
                if (n3 == 2) {
                    this.img[n] = new ImageFamily(string2, this);
                }
                n2 = n4 + 1;
                ++n3;
            }
            ++n4;
        }
        if (this.val[n] == null) {
            this.val[n] = "";
        }
        if (this.txt[n] == null) {
            this.txt[n] = this.val[n];
        }
        if (this.img[n] == null) {
            this.img[n] = new ImageFamily(null, this);
        }
        if (component == null) {
            return;
        }
        if (component instanceof Choice) {
            ((Choice)component).addItem(this.txt[n]);
        }
        if (component instanceof List) {
            ((List)component).addItem(this.txt[n]);
        }
    }

    void setIndex(Component component) {
        int n = this.val.length;
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > n - 1) {
            this.index = n - 1;
        }
        if (this.mode == 0) {
            this.repaint();
        }
        if (component == null) {
            return;
        }
        if (component instanceof Choice) {
            ((Choice)component).select(this.index);
        }
        if (component instanceof List) {
            ((List)component).select(this.index);
        }
    }

    void item2index(String string) {
        int n = 0;
        while (n < this.val.length) {
            if (string.equals(this.val[n])) {
                this.index = n;
                return;
            }
            ++n;
        }
        this.index = 0;
    }

    public boolean action(Event event, Object object) {
        Component component = this.component;
        if (component == null) {
            return true;
        }
        if (component instanceof Choice) {
            this.index = ((Choice)component).getSelectedIndex();
            this.event(null);
        }
        return true;
    }

    public boolean handleEvent(Event event) {
        Component component = this.component;
        if (component != null && event.id == 701 && component instanceof List) {
            this.index = ((List)component).getSelectedIndex();
            this.event(null);
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.pressed = true;
        if (this.mode != 0 || this.disabled || this.hidden) {
            return true;
        }
        this.repaint();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.pressed = false;
        if (this.mode != 0 || this.disabled || this.hidden) {
            return true;
        }
        int n3 = this.val.length;
        if (n3 == 0) {
            return true;
        }
        this.index = (this.index + 1) % n3;
        this.repaint();
        this.event(null);
        return true;
    }

    void doUpdate(Graphics graphics) {
        Color color;
        int n;
        if (this.hidden || this.mode != 0) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.w, this.h);
            return;
        }
        graphics.setColor(this.backColor == null ? this.getBackground() : (this.entered && !this.disabled ? this.getBrighterColor(this.backColor) : this.backColor));
        graphics.fillRect(0, 0, this.w, this.h);
        int n2 = this.pressed ? 2 : 0;
        ImageFamily[] imageFamilyArray = this.img;
        String[] stringArray = this.txt;
        Image image = null;
        if (imageFamilyArray != null && imageFamilyArray[this.index] != null) {
            imageFamilyArray[this.index].setBack(this.backColor);
            image = imageFamilyArray[this.index].getSource();
            if (this.entered) {
                image = imageFamilyArray[this.index].getBright();
            }
            if (this.disabled) {
                image = imageFamilyArray[this.index].getContour();
            }
        }
        if (image != null) {
            n = image.getWidth(this);
            int n3 = image.getHeight(this);
            graphics.drawImage(image, (this.w - n) / 2 + n2, (this.h - 2 < n3 ? 0 : 4) + n2, this);
        }
        if (stringArray != null && stringArray[this.index] != null && stringArray[this.index].length() != 0) {
            graphics.setFont(this.createFont());
            n = graphics.getFontMetrics().stringWidth(stringArray[this.index]);
            if (this.disabled) {
                Color color2 = this.backColor == null ? Color.lightGray : this.backColor;
                color = color2.darker();
                Color color3 = color2.brighter();
                graphics.setColor(color3);
                graphics.drawString(stringArray[this.index], (this.w - n) / 2, this.h - 5);
                graphics.setColor(color);
                graphics.drawString(stringArray[this.index], (this.w - n) / 2 - 1, this.h - 5 - 1);
            } else if (this.foreColor != null) {
                graphics.setColor(this.foreColor);
                graphics.drawString(stringArray[this.index], (this.w - n) / 2 + n2, this.h - 5 + n2);
            }
        }
        if (!this.disabled) {
            Color color4 = this.backColor == null ? Color.lightGray : this.backColor;
            Color color5 = color4.darker();
            color = color4.brighter();
            graphics.setColor(this.pressed ? color5 : color);
            graphics.drawLine(0, 0, 0, this.h - 2);
            graphics.drawLine(0, 0, this.w - 2, 0);
            graphics.setColor(!this.pressed ? color5 : color);
            graphics.drawLine(this.w - 1, 1, this.w - 1, this.h - 1);
            graphics.drawLine(1, this.h - 1, this.w - 1, this.h - 1);
        }
    }
}

