/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats.mp3;

import de.vdheide.mp3.MP3File;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import photoorganizer.formats.mp3.HeaderInfo;

public class InfoReader {
    static final String[] LAYER_NAMES = new String[]{"I", "II", "III"};
    static final String[] S_FREQ = new String[]{"44.1", "48", "32", "0"};
    static final String[] MODE_NAMES = new String[]{"stereo", "j-stereo", "dual-ch", "mono"};
    static final int[][][] BITRATES = new int[][][]{new int[][]{{0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384}, {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320}}, new int[][]{{0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}}, new int[][]{{0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}}};
    public static final String[] GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Meta", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Brass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Poweer Ballad", "Rhytmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A Capela", "Euro-House", "Dance Hall"};

    public boolean read(InputStream inputStream) throws IOException {
        if (!this.skipToSync(inputStream)) {
            return false;
        }
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        HeaderInfo headerInfo = this.unpackHeader(byArray);
        int n = 200;
        System.out.println("Indexes: " + headerInfo.version + '/' + (headerInfo.lay - 1) + '/' + headerInfo.bitrateIndex);
        System.out.println(MessageFormat.format("{0,number}Kbps  {1}  {2}  {3,number}:{4,number,##}", new Integer(BITRATES[headerInfo.version][headerInfo.lay - 1][headerInfo.bitrateIndex]), S_FREQ[headerInfo.samplingFrequency], MODE_NAMES[headerInfo.mode], new Integer(n / 60), new Integer(n % 60)));
        return true;
    }

    boolean skipToSync(InputStream inputStream) throws IOException {
        int n = 0;
        while (n < 8000) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                return false;
            }
            if (n2 == 255) {
                return true;
            }
            ++n;
        }
        return false;
    }

    HeaderInfo unpackHeader(byte[] byArray) {
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.version = byArray[1] >> 3 & 1;
        headerInfo.lay = 4 - (byArray[1] >> 1 & 3);
        if (headerInfo.lay == 0) {
            System.err.println("Unknown layer:" + headerInfo.lay);
        } else {
            System.out.println("Layer:" + headerInfo.lay);
        }
        headerInfo.errorProtection = byArray[1] & 1;
        headerInfo.bitrateIndex = byArray[2] >> 4 & 0xF;
        headerInfo.samplingFrequency = byArray[2] >> 2 & 3;
        headerInfo.padding = byArray[2] >> 1 & 1;
        headerInfo.extension = byArray[2] & 1;
        headerInfo.mode = byArray[3] >> 6 & 3;
        headerInfo.modeExt = byArray[3] >> 4 & 3;
        headerInfo.copyright = byArray[3] >> 3 & 1;
        headerInfo.original = byArray[3] >> 2 & 1;
        headerInfo.emphasis = byArray[3] & 3;
        return headerInfo;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            System.out.println("Usage: file/url [... file/url]");
            System.exit(255);
        }
        try {
            var1_1 = new MP3File(var0[0]);
            System.out.println("File:" + var0[0] + "\n BR:" + var1_1.getBitrate() + "Kbps, frequency " + var1_1.getSamplerate() / 1000 + '.' + var1_1.getSamplerate() % 1000 + "Khz, mode:" + InfoReader.MODE_NAMES[var1_1.getMode()] + ", duration:" + var1_1.getLength() / 60L + ':' + var1_1.getLength() % 60L + " minutes.\n" + var1_1.getTitle().getTextContent() + " by " + var1_1.getArtist().getTextContent() + "\nAlbum:" + var1_1.getAlbum().getTextContent() + '(' + var1_1.getYear().getTextContent() + "), Genre " + InfoReader.GENRES[Integer.parseInt(var1_1.getGenre().getTextContent())]);
            return;
        }
        catch (Exception var1_2) {
            System.err.println("The file " + var0[0] + " not available, corrupted or not supported media. " + var1_2);
            var1_3 = new InfoReader();
            var2_4 = 0;
            ** while (var2_4 < var0.length)
        }
lbl-1000:
        // 1 sources

        {
            System.out.println("Reading " + var0[var2_4] + "...");
            var3_5 = null;
            try {
                var3_5 = new URL(var0[var2_4]).openStream();
            }
            catch (Exception var4_7) {
                try {
                    var3_5 = new BufferedInputStream(new FileInputStream(var0[var2_4]));
                }
                catch (Exception var5_9) {
                    System.out.println("Can't open stream for " + var0[var2_4] + ':' + var5_9);
                }
            }
            try {
                System.out.println(var0[var2_4] + " seems to be " + (var1_3.read(var3_5) != false ? "" : "in") + "valid file.");
                var3_5.close();
            }
            catch (IOException var4_8) {
                System.out.println("Error in reading " + var0[var2_4] + ':' + var4_8);
            }
            ++var2_4;
            continue;
        }
lbl32:
        // 1 sources

    }
}

