/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.ftp;

import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import photoorganizer.ftp.Ftp;
import photoorganizer.ftp.FtpCommandReply;

public class FtpFile
extends File {
    static final String PATHDELIMS = "/\\";
    public static final char ftpseparator = '/';
    static final SimpleDateFormat dateformat = new SimpleDateFormat("MMM dd yyyy", Locale.US);
    static final SimpleDateFormat thisYearFormat = new SimpleDateFormat("MMM dd HH:mm", Locale.US);
    static final String thisYear = Integer.toString(Calendar.getInstance().get(1));
    private Ftp ftp;
    private boolean checked;
    private boolean isdirectory;
    private boolean isfile;
    private boolean canread;
    private boolean canwrite;
    private String path;
    private long length;
    private long modified;

    public FtpFile(Ftp ftp, String string) {
        super(string);
        this.ftp = ftp;
        this.path = string;
    }

    public FtpFile(Ftp ftp, String string, String string2) {
        this(ftp, string);
        this.path = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/' ? this.path + string2 : this.path + '/' + string2;
    }

    public boolean parseListLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() < 3) {
                return false;
            }
            this.isdirectory = string2.charAt(0) == 'd';
            this.canread = string2.charAt(1) == 'r';
            boolean bl = this.canwrite = string2.charAt(2) == 'w';
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            try {
                                this.length = Integer.parseInt(stringTokenizer.nextToken());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (stringTokenizer.hasMoreTokens()) {
                                string2 = stringTokenizer.nextToken();
                                if (stringTokenizer.hasMoreTokens()) {
                                    string2 = string2 + " ";
                                    string2 = string2 + stringTokenizer.nextToken();
                                    if (stringTokenizer.hasMoreTokens()) {
                                        string2 = string2 + " ";
                                        string2 = string2 + stringTokenizer.nextToken();
                                        try {
                                            this.modified = dateformat.parse(string2).getTime();
                                        }
                                        catch (NullPointerException nullPointerException) {
                                        }
                                        catch (ParseException parseException) {
                                            try {
                                                this.modified = thisYearFormat.parse(string2).getTime();
                                            }
                                            catch (ParseException parseException2) {
                                                System.err.println("Neither of patterns: '" + thisYearFormat.toPattern() + "' nor '" + dateformat.toPattern() + "' worked. \n" + parseException + '\n' + parseException2);
                                            }
                                        }
                                        if (stringTokenizer.hasMoreTokens()) {
                                            string2 = stringTokenizer.nextToken("\n\r");
                                            if (string2.equals(".") || string2.equals("..")) {
                                                return false;
                                            }
                                            if (stringTokenizer.hasMoreTokens()) {
                                                string2 = string2 + ' ';
                                                string2 = string2 + stringTokenizer.nextToken();
                                            }
                                            this.path = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/' ? this.path + string2 : this.path + '/' + string2;
                                            this.checked = true;
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!this.checked) {
            this.exists();
        }
        if (object instanceof File) {
            return this.path.equals(((File)object).getPath());
        }
        return this.path.equals(object.toString());
    }

    public boolean isDirectory() {
        if (!this.checked) {
            this.exists();
        }
        return this.isdirectory;
    }

    public boolean isFile() {
        if (!this.checked) {
            this.exists();
        }
        return this.isfile;
    }

    public boolean isAbsolute() {
        if (!this.checked) {
            this.exists();
        }
        return this.path.length() > 0 && this.path.charAt(0) == '/';
    }

    public boolean isHidden() {
        if (!this.checked) {
            this.exists();
        }
        return false;
    }

    public long lastModified() {
        return this.modified;
    }

    public long length() {
        return this.length;
    }

    public String[] list() {
        return this.list(null);
    }

    public String[] list(FilenameFilter filenameFilter) {
        Object object;
        Vector<String> vector = new Vector<String>();
        FtpCommandReply ftpCommandReply = this.ftp.list(this.path);
        if (ftpCommandReply.replyData != null) {
            object = new FtpFile(this.ftp, this.path);
            int n = 0;
            while (n < ftpCommandReply.replyData.size()) {
                if (((FtpFile)object).parseListLine((String)ftpCommandReply.replyData.elementAt(n)) && (filenameFilter == null || filenameFilter.accept(this, ((FtpFile)object).getName()))) {
                    vector.addElement(((FtpFile)object).getName());
                }
                ++n;
            }
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public File[] listFiles() {
        return this.listFiles((FileFilter)null);
    }

    public File[] listFiles(FileFilter fileFilter) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        FtpCommandReply ftpCommandReply = this.ftp.cwd(this.path);
        ftpCommandReply = this.ftp.list();
        if (ftpCommandReply.replyData != null) {
            int n = 0;
            while (n < ftpCommandReply.replyData.size()) {
                object = new FtpFile(this.ftp, this.path);
                if (((FtpFile)object).parseListLine((String)ftpCommandReply.replyData.elementAt(n)) && (fileFilter == null || fileFilter.accept((File)object))) {
                    vector.addElement(object);
                }
                ++n;
            }
        }
        object = new File[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String getPath() {
        return this.path;
    }

    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    public String getAbsolutePath() {
        if (!this.isAbsolute()) {
            FtpCommandReply ftpCommandReply = this.ftp.pwd();
            if (ftpCommandReply.replyMessage != null && ftpCommandReply.replyMessage.size() == 1) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)ftpCommandReply.replyMessage.elementAt(0), " ");
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    return string.substring(1, string.length() - 1) + '/' + this.path;
                }
            }
        }
        return this.path;
    }

    public String getName() {
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.path, PATHDELIMS);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        if (string == null || string.length() > 1 && string.charAt(1) == ':') {
            string = "";
        }
        return string;
    }

    public String getParent() {
        String string = null;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getAbsolutePath(), PATHDELIMS);
        while (stringTokenizer.hasMoreTokens()) {
            string = string == null ? "" : string + string2;
            string2 = '/' + stringTokenizer.nextToken();
        }
        if (string != null && string.length() == 0 && this.isAbsolute()) {
            string = string + '/';
        }
        return string;
    }

    public boolean exists() {
        FtpCommandReply ftpCommandReply = this.ftp.nlst(this.path);
        if (ftpCommandReply.replyData != null) {
            int n = ftpCommandReply.replyData.size();
            this.isdirectory = n > 1;
            this.isfile = n == 1;
        } else {
            ftpCommandReply = this.ftp.pwd();
            if (ftpCommandReply.replyCode / 100 == 2 && ftpCommandReply.replyMessage != null && ftpCommandReply.replyMessage.size() == 1) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)ftpCommandReply.replyMessage.elementAt(0), " ");
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken("\"");
                    ftpCommandReply = this.ftp.cwd(this.path);
                    if (ftpCommandReply.replyCode / 100 == 2) {
                        this.isdirectory = true;
                        ftpCommandReply = this.ftp.cwd(string);
                    }
                }
            }
        }
        this.checked = true;
        return this.isdirectory || this.isfile;
    }

    public boolean canRead() {
        return this.canread;
    }

    public boolean canWrite() {
        return this.canwrite;
    }

    public int hashCode() {
        return this.path.hashCode() ^ 0x12D591;
    }

    public boolean mkdir() {
        FtpCommandReply ftpCommandReply = this.ftp.cwd(this.getParent());
        if (ftpCommandReply.replyCode / 100 >= 4) {
            return false;
        }
        ftpCommandReply = this.ftp.mkd(this.getName());
        System.err.println("" + ftpCommandReply);
        return ftpCommandReply.replyCode / 100 < 4;
    }

    public boolean renameTo(File file) {
        FtpCommandReply ftpCommandReply = this.ftp.cwd(this.getParent());
        if (ftpCommandReply.replyCode / 100 >= 4) {
            return false;
        }
        ftpCommandReply = this.ftp.rnfr(this.getName());
        if (ftpCommandReply.replyCode / 100 >= 4) {
            return false;
        }
        ftpCommandReply = this.ftp.rnto(file.getName());
        System.err.println("" + ftpCommandReply);
        return ftpCommandReply.replyCode / 100 < 4;
    }

    static interface FileFilter {
        public boolean accept(File var1);
    }
}

