/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import photoorganizer.Controller;
import photoorganizer.PhotoPlugin;
import photoorganizer.renderer.AlbumOptionsTab;
import photoorganizer.renderer.AppearanceOptionsTab;
import photoorganizer.renderer.MediaOptionsTab;
import photoorganizer.renderer.MiscellaneousOptionsTab;
import photoorganizer.renderer.PluginOptionsTab;
import photoorganizer.renderer.RemoteOptionsTab;
import photoorganizer.renderer.RenameOptionsTab;
import photoorganizer.renderer.ThumbnailsOptionsTab;
import photoorganizer.renderer.TransformOptionsTab;
import photoorganizer.renderer.TwoPanesView;
import photoorganizer.renderer.WebPublishOptionsTab;
import rogatkin.Helpable;
import rogatkin.Persistable;

public class OptionsFrame
extends JFrame
implements ActionListener,
Persistable {
    Controller controller;
    JDialog help_dialog;
    JTabbedPane tabbedpane;
    TwoPanesView helpContentPane;

    public OptionsFrame(Controller controller) {
        super("Options");
        this.controller = controller;
        this.setIconImage(controller.getMainIcon());
        this.tabbedpane = new JTabbedPane(1);
        this.tabbedpane.setTabLayoutPolicy(1);
        int n = 0;
        this.tabbedpane.insertTab("Rename", null, new RenameOptionsTab(controller), "Specify a rule for renaming images", n++);
        this.tabbedpane.insertTab("Transform", null, new TransformOptionsTab(controller), "Specify image transformation options", n++);
        this.tabbedpane.insertTab("Thumbnails", null, new ThumbnailsOptionsTab(controller), "Specify thumbnails panel options", n++);
        this.tabbedpane.insertTab("Miscellaneous", null, new MiscellaneousOptionsTab(controller), "Specify misc options concerning layout", n++);
        this.tabbedpane.insertTab("Appearance", null, new AppearanceOptionsTab(controller), "Customize appearance of tables and panes", n++);
        this.tabbedpane.insertTab("Album", null, new AlbumOptionsTab(controller), "Setting album options, includimg database settings", n++);
        this.tabbedpane.insertTab("WebPublishing", null, new WebPublishOptionsTab(controller), "Web root and Ftp settings", n++);
        this.tabbedpane.insertTab("Media (MP3)", null, new MediaOptionsTab(controller), "Use it to set options relaited to music files", n++);
        if (controller.component(Controller.COMP_REMOTERECEIVER) != null) {
            this.tabbedpane.insertTab("Remote", null, new RemoteOptionsTab(controller), "Allows to map keys of your remote control to the program commands", n++);
        }
        this.tabbedpane.insertTab("Plug-ins", null, new PluginOptionsTab(controller), "Adding, editing, and removing plug-ins", n++);
        Enumeration enumeration = controller.names();
        int n2 = this.tabbedpane.getTabCount();
        while (enumeration.hasMoreElements()) {
            try {
                PhotoPlugin photoPlugin = (PhotoPlugin)((Object)controller.component(enumeration.nextElement()));
                JPanel jPanel = photoPlugin.getOptionsTab();
                if (jPanel == null) continue;
                this.tabbedpane.insertTab(photoPlugin.getName(), null, jPanel, photoPlugin.getName(), n2++);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabbedpane, "Center");
        this.getContentPane().add((Component)Controller.createButtonPanel(this, true), "South");
        this.pack();
        this.setVisible(true);
        this.load();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component;
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.save();
            this.setVisible(false);
        } else if (string.equals("<html><i>Apply")) {
            this.save();
        } else if (string.equals("Cancel")) {
            this.setVisible(false);
        } else if (string.equals("Help") && (component = this.tabbedpane.getSelectedComponent()) != null && component instanceof Helpable) {
            if (this.help_dialog == null) {
                this.help_dialog = new JDialog((Frame)this, "Help");
                this.helpContentPane = TwoPanesView.createFramed(true, null, 16, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        OptionsFrame.this.help_dialog.setVisible(false);
                    }
                });
                this.help_dialog.setContentPane(this.helpContentPane);
                this.help_dialog.setDefaultCloseOperation(1);
                this.helpContentPane.setSize(450, 360);
                this.help_dialog.pack();
                this.help_dialog.setSize(460, 370);
            }
            this.helpContentPane.setUpperText(((Helpable)component).getHelp());
            this.help_dialog.show();
        }
    }

    public void load() {
        JTabbedPane jTabbedPane = (JTabbedPane)this.getContentPane().getComponent(0);
        int n = 0;
        while (n < jTabbedPane.getTabCount()) {
            try {
                ((Persistable)jTabbedPane.getComponentAt(n)).load();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void save() {
        JTabbedPane jTabbedPane = (JTabbedPane)this.getContentPane().getComponent(0);
        int n = 0;
        while (n < jTabbedPane.getTabCount()) {
            try {
                ((Persistable)jTabbedPane.getComponentAt(n)).save();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n;
        }
    }

    protected void finalize() throws Throwable {
        if (this.help_dialog != null) {
            this.help_dialog.dispose();
        }
        super.finalize();
    }
}

