/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import rogatkin.GranulatedLayout;

public class StatusBar
extends JPanel {
    protected JProgressBar progress;
    protected JLabel info;
    protected JLabel label;
    protected JLabel metric;
    protected JComponent custom;

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.progress = new JProgressBar();
        this.add((Component)this.progress, "West");
        this.progress.setBorder(BorderFactory.createLoweredBevelBorder());
        this.progress.setMinimum(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GranulatedLayout(5, 1, 20, 0, 4, 4));
        this.info = new JLabel(" ", 0);
        jPanel.add((Component)this.info, "0,0,4");
        this.metric = new JLabel(" ", 4);
        jPanel.add((Component)this.metric, "4,0");
        this.info.setBorder(BorderFactory.createLoweredBevelBorder());
        this.metric.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)jPanel, "Center");
        this.label = new JLabel("Copyright \u00a9 1999-2001 Dmitriy Rogatkin", 4);
        this.setCustomStatus(null);
    }

    public void displayInfo(String string) {
        if (string != null) {
            this.info.setText(string);
        }
    }

    public void displayMetric(String string) {
        if (string != null) {
            this.metric.setText(string);
        }
    }

    public void setCustomStatus(JComponent jComponent) {
        if (jComponent == null) {
            if (this.custom != this.label) {
                if (this.custom != null) {
                    this.remove(this.custom);
                }
                this.custom = this.label;
                this.add((Component)this.custom, "East");
            }
        } else if (jComponent != this.custom) {
            if (this.custom != null) {
                this.remove(this.custom);
            }
            this.custom = jComponent;
            this.add((Component)this.custom, "East");
        }
    }

    public void clearInfo() {
        this.info.setText(" ");
    }

    public void clearProgress() {
        this.progress.setValue(0);
        this.progress.setIndeterminate(false);
    }

    public void setProgress(int n) {
        if (n < 0) {
            this.progress.setIndeterminate(true);
        } else {
            this.progress.setIndeterminate(false);
            this.progress.setMaximum(n);
        }
    }

    public void tickProgress() {
        if (!this.progress.isIndeterminate()) {
            this.progress.setValue(this.progress.getValue() + 1);
        }
    }

    public void flashInfo(String string) {
        this.flashInfo(string, false);
    }

    public void flashInfo(String string, boolean bl) {
        this.displayInfo(string);
        if (bl) {
            System.err.println(string);
        }
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                StatusBar.this.clearInfo();
            }
        }).start();
    }
}

