/* PhotoOrganizer - $RCSfile: Entry.java,v $
 * Copyright (C) 1999 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  $Id: Entry.java,v 1.2 2001/07/25 08:13:34 rogatkin Exp $
 */
package photoorganizer.formats;
import java.io.Serializable;

public class Entry implements Serializable {

    public Entry(int type, String value) {
        this.type = type;
        str = value;
    }
    
    public Entry(int type, Object[] value) {
        this.type = type;
        this.value = value;
    }

    public int getType() {
        return type;
    }

    public String toString() {
        if (str != null)
            return str;
	StringBuffer buff = new StringBuffer();
	for (int i=0; i<value.length; i++)
	    buff.append((type!=Exif.UNDEFINED)?value[i]:Integer.toHexString(((Integer)value[i]).intValue()));//.append('|');
        return buff.toString();

    }

    public Object[] getValues() {
        return value;
    }

    public Object getValue(int index) {
        return value[index];
    }
    
    private int type;
    private String str;
    private Object[] value;
}
