/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   P_AudioDecoder.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;

/**
 *   MPEG-I Audio Stream Decoder
 * Note: This class is for future extension, now it just kick the buffer back to system queue
 */
class P_AudioDecoder implements Runnable
{
	/**
	 *   The Buffered bit stream where all the audio data comes
	 */
	private P_BufferedBitStream audioStream;

	/**
	 *   Constructor
	 */
	P_AudioDecoder( P_BufferedBitStream stream )
	{
		audioStream = stream;
	}

	/**
	 *   Reset the audio stream decoder
	 */
	void reset()
	{
		audioStream.reset();
	}

	/**
	 *   The main Audio decoding process ( just kicking back the buffer )
	 */
	public void run()
	{
		try {
			int code = audioStream.showBits(32);
			//while ( code != VideoDecoder.SEQUENCE_END_CODE) {
			// Note: Change to ISO_11172_END_CODE to force the system decoder die first
			while ( code != P_BitStream.ISO_11172_END_CODE) {
				audioStream.nextBuffer();
				code = audioStream.showBits(32);
			}

		} catch (Exception e) {
			System.out.println(" InterruptedException in AudioDecoder Thread: " + e);
		}
	}
}
