/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.album;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import photoorganizer.Controller;
import photoorganizer.album.Access;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicJpeg;

public class MediaAccess
extends Access {
    static final String MEDIAS_DATABASE = "Medias";
    static final String[][] MEDIAS_DATABASE_STRUCTURE = new String[][]{{"MediaId", " INTEGER NOT NULL,"}, {"Name", " CHAR(255) NOT NULL,"}, {"LocId", " INTEGER,"}, {"TempLoc", " CHAR,"}, {"ChkSum", " INTEGER,"}, {"Length", " INTEGER,"}, {"Artist", " CHAR(255),"}, {"Year", " TIMESTAMP,"}, {"Title", " CHAR(255),"}, {"Album", " CHAR(100),"}, {"Genre", " INTEGER,"}, {"Quality", " CHAR(10),"}, {"Composer", " CHAR(100),"}, {"Conductor", " CHAR(100),"}, {"Band", " CHAR(100),"}, {"Lyricist", " CHAR(100),"}, {"Type", " INTEGER,"}, {"Commentary", " CHAR(255)"}};
    static final int MEDIAS_MEDIAID = 0;
    static final int MEDIAS_NAME = 1;
    static final int MEDIAS_LOCID = 2;
    static final int MEDIAS_TEMPLOC = 3;
    static final int MEDIAS_CHKSUM = 4;
    static final int MEDIAS_LENGTH = 5;
    static final int MEDIAS_ARTIST = 6;
    static final int MEDIAS_YEAR = 7;
    static final int MEDIAS_TITLE = 8;
    static final int MEDIAS_ALBUM = 9;
    static final int MEDIAS_GENRE = 10;
    static final int MEDIAS_QUALITY = 11;
    static final int MEDIAS_COMPOSER = 12;
    static final int MEDIAS_CONDUCTOR = 13;
    static final int MEDIAS_BAND = 14;
    static final int MEDIAS_LYRICIST = 15;
    static final int MEDIAS_TYPE = 16;
    static final int MEDIAS_COMMENTARY = 17;
    static final String IDENTIFIERS_TABLE = "Identifiers";
    static final String[] TABLES = new String[]{"Pictures", "Medias", "Connection", "Album", "Groups", "Locations"};
    static final String[][][] DESCRIPTIONS = new String[][][]{Access.PICTURES_DATABASE_STRUCTURE, MEDIAS_DATABASE_STRUCTURE, Access.CONNECTION_DATABASE_STRUCTURE, Access.ALBUM_DATABASE_STRUCTURE, Access.GROUPS_DATABASE_STRUCTURE, Access.LOCATIONS_DATABASE_STRUCTURE};

    public MediaAccess(Controller controller) {
        super(controller);
    }

    protected String[] getTables() {
        String[] stringArray = new String[TABLES.length + 1];
        System.arraycopy(TABLES, 0, stringArray, 0, TABLES.length);
        stringArray[MediaAccess.TABLES.length] = IDENTIFIERS_TABLE;
        return stringArray;
    }

    protected String[][][] getDescriptions() {
        String[][][] stringArray = new String[DESCRIPTIONS.length + 1][][];
        System.arraycopy(DESCRIPTIONS, 0, stringArray, 0, DESCRIPTIONS.length);
        String[][] stringArrayArray = new String[TABLES.length][];
        int n = 0;
        while (n < TABLES.length - 1) {
            stringArrayArray[n] = new String[]{TABLES[n], " INTEGER,"};
            ++n;
        }
        stringArrayArray[MediaAccess.TABLES.length - 1] = new String[]{TABLES[TABLES.length - 1], " INTEGER"};
        stringArray[MediaAccess.TABLES.length] = stringArrayArray;
        return stringArray;
    }

    public void insertMediasToAlbum(int n, AbstractFormat[] abstractFormatArray) {
        boolean bl = false;
        boolean bl2 = false;
        Vector<AbstractFormat> vector = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < abstractFormatArray.length) {
            if ("MP3".equals(abstractFormatArray[n3].getType())) {
                if (bl) {
                    if (vector == null) {
                        vector = new Vector<AbstractFormat>();
                        n2 = n3;
                    }
                    vector.addElement(abstractFormatArray[n3]);
                } else {
                    bl2 = true;
                    if (n2 < n3) {
                        abstractFormatArray[n2] = abstractFormatArray[n3];
                    }
                    ++n2;
                }
            } else if (bl2) {
                if (vector == null) {
                    vector = new Vector();
                    n2 = n3;
                }
                vector.addElement(abstractFormatArray[n3]);
            } else {
                bl = true;
                if (n2 < n3) {
                    abstractFormatArray[n2] = abstractFormatArray[n3];
                }
                ++n2;
            }
            ++n3;
        }
        if (bl) {
            if (n2 < abstractFormatArray.length && vector != null) {
                AbstractFormat[] abstractFormatArray2 = new BasicJpeg[n2];
                System.arraycopy(abstractFormatArray, 0, abstractFormatArray2, 0, n2);
                this.insertPicturesToAlbum(n, abstractFormatArray2);
                this.insertAudiosToAlbum(n, vector.toArray(new AbstractFormat[vector.size()]));
            } else {
                this.insertPicturesToAlbum(n, abstractFormatArray);
            }
        } else if (bl2) {
            if (n2 < abstractFormatArray.length && vector != null) {
                AbstractFormat[] abstractFormatArray3 = new AbstractFormat[n2];
                System.arraycopy(abstractFormatArray, 0, abstractFormatArray3, 0, n2);
                this.insertAudiosToAlbum(n, abstractFormatArray3);
                this.insertPicturesToAlbum(n, vector.toArray(new AbstractFormat[vector.size()]));
            } else {
                this.insertAudiosToAlbum(n, abstractFormatArray);
            }
        }
    }

    public synchronized void insertAudiosToAlbum(int n, AbstractFormat[] abstractFormatArray) {
        Statement statement;
        PreparedStatement preparedStatement;
        String string = "INSERT INTO Locations (" + Access.LOCATIONS_DATABASE_STRUCTURE[0][0] + ',' + Access.LOCATIONS_DATABASE_STRUCTURE[1][0] + ") VALUES (";
        String string2 = "INSERT INTO Connection (" + Access.CONNECTION_DATABASE_STRUCTURE[0][0] + ',' + Access.CONNECTION_DATABASE_STRUCTURE[1][0] + ',' + Access.CONNECTION_DATABASE_STRUCTURE[2][0] + ") VALUES (";
        StringBuffer stringBuffer = new StringBuffer(MEDIAS_DATABASE_STRUCTURE[0][0]);
        StringBuffer stringBuffer2 = new StringBuffer(" VALUES (?");
        int n2 = 1;
        while (n2 < MEDIAS_DATABASE_STRUCTURE.length) {
            stringBuffer.append(',').append(MEDIAS_DATABASE_STRUCTURE[n2][0]);
            stringBuffer2.append(",?");
            ++n2;
        }
        stringBuffer.append(')');
        stringBuffer2.append(')');
        try {
            preparedStatement = this.getAvailableConnection().prepareStatement("INSERT INTO Medias (" + stringBuffer.toString() + stringBuffer2.toString());
            statement = this.getAvailableConnection().createStatement();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            return;
        }
        int n3 = 0;
        while (n3 < abstractFormatArray.length) {
            block38: {
                try {
                    AbstractInfo abstractInfo;
                    int n4 = this.generateUniqueId("Pictures", MEDIAS_DATABASE_STRUCTURE[0][0]);
                    if (n4 == -1 || (abstractInfo = abstractFormatArray[n3].getInfo()) == null) break block38;
                    preparedStatement.setInt(1, n4);
                    int n5 = 2;
                    while (n5 <= MEDIAS_DATABASE_STRUCTURE.length) {
                        try {
                            switch (n5 - 1) {
                                case 1: {
                                    preparedStatement.setString(n5, abstractFormatArray[n3].getFile().getPath());
                                    break;
                                }
                                case 2: {
                                    preparedStatement.setInt(n5, 0);
                                    break;
                                }
                                case 3: {
                                    preparedStatement.setString(n5, "N");
                                    break;
                                }
                                case 4: {
                                    preparedStatement.setInt(n5, 0);
                                    break;
                                }
                                case 5: {
                                    try {
                                        preparedStatement.setInt(n5, (int)abstractInfo.getLongAttribute("Length"));
                                    }
                                    catch (Exception exception) {
                                        preparedStatement.setLong(n5, -1L);
                                    }
                                    break;
                                }
                                case 6: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("Artist").toString());
                                    break;
                                }
                                case 7: {
                                    Calendar calendar = Calendar.getInstance();
                                    try {
                                        calendar.set(1, abstractInfo.getIntAttribute("Year"));
                                    }
                                    catch (Exception exception) {
                                        calendar.set(1, 1970);
                                    }
                                    preparedStatement.setTimestamp(n5, new Timestamp(calendar.getTime().getTime()));
                                    break;
                                }
                                case 8: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("Title").toString());
                                    break;
                                }
                                case 9: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("Album").toString());
                                    break;
                                }
                                case 10: {
                                    try {
                                        preparedStatement.setInt(n5, abstractInfo.getIntAttribute("Genre"));
                                    }
                                    catch (Exception exception) {
                                        preparedStatement.setInt(n5, -1);
                                    }
                                    break;
                                }
                                case 11: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("quality").toString());
                                    break;
                                }
                                case 12: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("Composer").toString());
                                    break;
                                }
                                case 13: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("Conductor").toString());
                                    break;
                                }
                                case 14: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("Band").toString());
                                    break;
                                }
                                case 15: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("Lyricist").toString());
                                    break;
                                }
                                case 16: {
                                    try {
                                        preparedStatement.setInt(n5, abstractInfo.getIntAttribute("MPEGLevel"));
                                    }
                                    catch (Exception exception) {
                                        preparedStatement.setInt(n5, -1);
                                    }
                                    break;
                                }
                                case 17: {
                                    preparedStatement.setString(n5, abstractInfo.getAttribute("Comments").toString());
                                    break;
                                }
                                default: {
                                    preparedStatement.setObject(n5, null);
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            preparedStatement.setString(n5, "");
                        }
                        ++n5;
                    }
                    preparedStatement.executeUpdate();
                    statement.executeUpdate(string2 + n4 + ',' + n + ',' + n3 + ')');
                }
                catch (SQLException sQLException) {
                    System.err.println("INSERT INTO Medias (" + stringBuffer.toString() + stringBuffer2.toString());
                    Access.printChainedSqlException(sQLException);
                }
            }
            ++n3;
        }
        try {
            preparedStatement.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    public boolean belongsToAlbum(AbstractFormat abstractFormat) {
        String string = "SELECT " + MEDIAS_DATABASE_STRUCTURE[1][0] + " FROM " + MEDIAS_DATABASE + " WHERE " + MEDIAS_DATABASE_STRUCTURE[1][0] + '=';
        if (abstractFormat == null) {
            return false;
        }
        if (super.belongsToAlbum(abstractFormat)) {
            return true;
        }
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + Access.SQLQuote(abstractFormat.getFile().getPath()));
            boolean bl = resultSet.next();
            resultSet.close();
            statement.close();
            return bl;
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File[] getAlbumContents(int n) {
        String[] stringArray = new String[]{"SELECT " + Access.PICTURES_DATABASE_STRUCTURE[1][0] + " FROM " + "Connection" + ',' + "Pictures" + " WHERE " + "Connection" + '.' + Access.CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + "Pictures" + '.' + Access.PICTURES_DATABASE_STRUCTURE[0][0] + " AND " + Access.CONNECTION_DATABASE_STRUCTURE[1][0] + '=', "SELECT " + MEDIAS_DATABASE_STRUCTURE[1][0] + " FROM " + "Connection" + ',' + MEDIAS_DATABASE + " WHERE " + "Connection" + '.' + Access.CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + MEDIAS_DATABASE + '.' + MEDIAS_DATABASE_STRUCTURE[0][0] + " AND " + Access.CONNECTION_DATABASE_STRUCTURE[1][0] + '='};
        String[] stringArray2 = new String[]{"", " ORDER BY " + Access.CONNECTION_DATABASE_STRUCTURE[2][0] + " ASC"};
        File[] fileArray = new File[]{};
        Statement statement = null;
        ResultSet resultSet = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            block16: {
                statement = this.getAvailableConnection().createStatement();
                resultSet = statement.executeQuery(stringArray[n2] + n + stringArray2[n2]);
                while (resultSet.next()) {
                    File[] fileArray2 = new File[fileArray.length + 1];
                    System.arraycopy(fileArray, 0, fileArray2, 0, fileArray.length);
                    fileArray2[fileArray.length] = new File(resultSet.getString(1).trim());
                    fileArray = fileArray2;
                }
                Object var10_10 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement.close();
                }
                catch (Exception exception) {}
                break block16;
                {
                    catch (SQLException sQLException) {
                        System.err.println(stringArray[n2] + n + stringArray2[n2]);
                        Access.printChainedSqlException(sQLException);
                        var10_10 = null;
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            ++n2;
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    synchronized int generateUniqueId(String string, String string2) {
        int n;
        block16: {
            ResultSet resultSet;
            Statement statement;
            block13: {
                n = 1;
                statement = null;
                resultSet = null;
                statement = this.getAvailableConnection().createStatement();
                statement.setMaxRows(1);
                resultSet = statement.executeQuery("SELECT " + string + " FROM " + IDENTIFIERS_TABLE);
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                    statement.executeUpdate("UPDATE Identifiers SET " + string + '=' + (n + 1) + (resultSet.wasNull() ? "" : " WHERE " + string + '=' + n));
                    ++n;
                    break block13;
                }
                statement.executeUpdate("INSERT INTO Identifiers (" + string + ") VALUES(" + n + ')');
            }
            Object var8_6 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Exception exception) {}
            break block16;
            {
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    Object var8_7 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void deletePicture(int n) {
        block8: {
            String string = "DELETE  FROM Medias WHERE " + MEDIAS_DATABASE_STRUCTURE[0][0] + '=';
            super.deletePicture(n);
            Statement statement = null;
            statement = this.getAvailableConnection().createStatement();
            statement.executeUpdate(string + n);
            Object var6_4 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {}
            break block8;
            {
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    System.err.println("For queries " + string + n);
                    Object var6_5 = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void deletePicture(int n, String string) {
        block21: {
            Statement statement;
            ResultSet resultSet;
            Statement statement2;
            String string2;
            String string3;
            String string4;
            String string5;
            block16: {
                string5 = "SELECT Connection." + Access.CONNECTION_DATABASE_STRUCTURE[0][0] + " FROM " + "Connection" + ',' + MEDIAS_DATABASE + " WHERE " + "Connection" + '.' + Access.CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + MEDIAS_DATABASE + '.' + MEDIAS_DATABASE_STRUCTURE[0][0] + " AND " + "Connection" + '.' + Access.CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
                string4 = " AND Medias." + MEDIAS_DATABASE_STRUCTURE[1][0] + "=";
                string3 = "DELETE  FROM Connection WHERE " + Access.CONNECTION_DATABASE_STRUCTURE[0][0] + '=';
                string2 = " AND " + Access.CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
                super.deletePicture(n, string);
                statement2 = null;
                resultSet = null;
                statement = null;
                statement2 = this.getAvailableConnection().createStatement();
                resultSet = statement2.executeQuery(string5 + n + string4 + Access.SQLQuote(string));
                if (!resultSet.next()) break block16;
                statement = this.getAvailableConnection().createStatement();
                statement2.executeUpdate(string3 + resultSet.getInt(1) + string2 + n);
                statement.close();
                statement = null;
            }
            Object var12_10 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement2.close();
            }
            catch (Exception exception) {}
            break block21;
            {
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    System.err.println("For queries " + string5 + n + string4 + '\'' + string + "'\n" + string3 + '?' + string2 + n);
                    Object var12_11 = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        statement2.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

