/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.MP3;

public class FileNameFormat
extends Format {
    public static final String formatHelp = "<html>\n<h2>Format escape sequences for pictures and music</h2>\n<pre>\n %D - date/time stamp in current locale,\n %d - date stamp,\n %t - time stamp,\n %s - shutter speed/bitrate,\n %a - aperture value/sample rate,\n %f - flash/protected (yes, no),\n %q - quality/mode\n %c - counter, can be specified as %0..0c, if leading zeros have to be present,\n %o - original file name,\n %r - transformation code expanded to: r90, r270, r180, TrPose, TrVerse, HMirr, VMirr\n %S - file size (undocumented),\n %z - focal length (zoom)/year,\n %M - make/artist\n %m - model/title\n %x - metering mode,\n %X - exposure program\n %n - type extension\n Format escape sequences for music\n %A - album,\n %b - band,\n %C - comment,\n %L - language,\n %g - genre,\n %l - length,\n %T - track,\n %e - composer,\n %E - conductor\n </pre>";
    public static int counter;
    public static String timemask;
    public static String datemask;
    public static Object[] transformCodes;
    final int TEXT = 0;
    final int ESC = 1;
    final char PERCENT = (char)37;
    private String mask;
    private int rotation;
    private boolean inccount;

    public FileNameFormat(String string) {
        this(string, false);
    }

    public FileNameFormat(String string, boolean bl) {
        this.mask = string;
        this.inccount = bl;
    }

    public FileNameFormat(String string, int n) {
        this(string);
        this.rotation = n;
    }

    public FileNameFormat(String string, int n, boolean bl) {
        this(string, bl);
        this.rotation = n;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        AbstractInfo abstractInfo = null;
        long l = 0L;
        try {
            abstractInfo = ((AbstractFormat)object).getInfo();
            l = ((AbstractFormat)object).getFileSize();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected AbstractFormat, but found " + object.getClass().getName());
        }
        int n = 0;
        String string = "";
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        while (this.mask != null && n2 < this.mask.length()) {
            char c = this.mask.charAt(n2);
            block26 : switch (n) {
                case 0: {
                    if (c != '%') {
                        stringBuffer2.append(c);
                        break;
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    n = 0;
                    switch (c) {
                        case 'D': {
                            DateFormat dateFormat = datemask == null || datemask.length() == 0 || timemask == null || timemask.length() == 0 ? DateFormat.getDateTimeInstance(3, 3) : new SimpleDateFormat(datemask + timemask);
                            stringBuffer2.append(FileNameFormat.getDateFormatted(dateFormat, abstractInfo));
                            break block26;
                        }
                        case 'd': {
                            DateFormat dateFormat = datemask == null || datemask.length() == 0 ? DateFormat.getDateInstance(3) : new SimpleDateFormat(datemask);
                            stringBuffer2.append(FileNameFormat.getDateFormatted(dateFormat, abstractInfo));
                            break block26;
                        }
                        case 't': {
                            DateFormat dateFormat = timemask == null || timemask.length() == 0 ? DateFormat.getTimeInstance(3) : new SimpleDateFormat(timemask);
                            stringBuffer2.append(FileNameFormat.getDateFormatted(dateFormat, abstractInfo));
                            break block26;
                        }
                        case 's': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Shutter").toString());
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                try {
                                    stringBuffer2.append(abstractInfo.getAttribute("Bitrate").toString());
                                }
                                catch (Exception exception) {}
                            }
                            break block26;
                        }
                        case 'a': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("FNumber").toString());
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                try {
                                    stringBuffer2.append(abstractInfo.getAttribute("Samplerate").toString());
                                }
                                catch (Exception exception) {}
                            }
                            break block26;
                        }
                        case 'f': {
                            if (abstractInfo == null) break block26;
                            try {
                                stringBuffer2.append(abstractInfo.getBoolAttribute("Flash") ? "Yes" : "No");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                try {
                                    stringBuffer2.append(abstractInfo.getBoolAttribute("Protection") ? "Yes" : "No");
                                }
                                catch (IllegalArgumentException illegalArgumentException2) {}
                            }
                            break block26;
                        }
                        case 'q': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Quality").toString());
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                try {
                                    stringBuffer2.append(abstractInfo.getAttribute("Mode").toString());
                                }
                                catch (Exception exception) {}
                            }
                            break block26;
                        }
                        case 'c': {
                            if (string.length() > 0) {
                                string = string + '0';
                            }
                            stringBuffer2.append(new DecimalFormat(string).format(counter));
                            string = "";
                            break block26;
                        }
                        case 'o': {
                            stringBuffer2.append(((AbstractFormat)object).getName());
                            break block26;
                        }
                        case 'r': {
                            stringBuffer2.append((String)transformCodes[this.rotation]);
                            break block26;
                        }
                        case 'S': {
                            stringBuffer2.append(l);
                            break block26;
                        }
                        case 'z': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("FocalLength").toString());
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                try {
                                    stringBuffer2.append(abstractInfo.getIntAttribute("Year"));
                                }
                                catch (Exception exception) {}
                            }
                            break block26;
                        }
                        case 'm': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Model"));
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                try {
                                    stringBuffer2.append(abstractInfo.getAttribute("Title").toString());
                                }
                                catch (Exception exception) {}
                            }
                            break block26;
                        }
                        case 'M': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Make").toString());
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                try {
                                    stringBuffer2.append(abstractInfo.getAttribute("Artist").toString());
                                }
                                catch (Exception exception) {}
                            }
                            break block26;
                        }
                        case '0': {
                            string = string + '0';
                            n = 1;
                            break block26;
                        }
                        case 'A': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Album").toString());
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'b': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Band").toString());
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'C': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Comments").toString());
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'L': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Language").toString());
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'g': {
                            try {
                                stringBuffer2.append(MP3.GENRES[abstractInfo.getIntAttribute("Genre")]);
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'l': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("timestamp"));
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'T': {
                            try {
                                stringBuffer2.append(abstractInfo.getIntAttribute("Track"));
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'e': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Composer").toString());
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'E': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Conductor").toString());
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'x': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("Metering").toString());
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'X': {
                            try {
                                stringBuffer2.append(abstractInfo.getAttribute("ExpoProgram").toString());
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                        case 'n': {
                            stringBuffer2.append(((AbstractFormat)object).getType());
                            break block26;
                        }
                        case '%': {
                            stringBuffer2.append(c);
                            break block26;
                        }
                    }
                    stringBuffer2.append('%');
                    stringBuffer2.append(c);
                }
            }
            ++n2;
        }
        if (this.inccount) {
            ++counter;
        }
        if (stringBuffer2.length() == 0) {
            stringBuffer2.append(object.toString());
        }
        return stringBuffer2;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return null;
    }

    public static String makeValidPathName(String string) {
        return FileNameFormat.makeValidPathName(string, null);
    }

    public static String makeValidPathName(String string, String string2) {
        if (string.indexOf(46) < 0 && string2 != null) {
            string = string + '.' + string2;
        }
        string = string.replace('/', '-');
        string = string.replace('\\', '-');
        string = string.replace(':', '_');
        string = string.replace(File.pathSeparatorChar, '-');
        string = string.replace('*', '_');
        string = string.replace('?', '_');
        string = string.replace(' ', '_');
        return string;
    }

    private static String getDateFormatted(DateFormat dateFormat, AbstractInfo abstractInfo) {
        String string = null;
        try {
            if (abstractInfo != null) {
                string = dateFormat.format(abstractInfo.getAttribute("DateTimeOriginal"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string == null) {
            string = dateFormat.format(new Date());
        }
        return string;
    }
}

