/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.io.File;
import java.util.List;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.renderer.BaseConfigurableTableModel;
import photoorganizer.renderer.VirtualFolder;

class AlbumTableModel
extends BaseConfigurableTableModel {
    VirtualFolder medias;

    AlbumTableModel(Controller controller) {
        this.updateView(controller.getSerializer());
    }

    public synchronized void updateModel(VirtualFolder virtualFolder) {
        this.medias = virtualFolder;
    }

    public synchronized void updateModel(File[] fileArray) {
        if (fileArray == null) {
            this.medias = new VirtualFolder("Empty");
            return;
        }
        this.clear();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                this.medias.add(new VirtualFolder(fileArray[n].getName()));
            } else {
                this.medias.addMedia(fileArray[n]);
            }
            ++n;
        }
    }

    public synchronized void clear() {
        if (this.medias == null) {
            this.medias = new VirtualFolder("Content");
        } else {
            List list = this.medias.getContent();
            if (list != null) {
                list.clear();
            }
            this.medias.clear();
        }
    }

    public synchronized void updateModel(List list) {
        if (list == null) {
            this.medias = new VirtualFolder("Empty");
            return;
        }
        this.clear();
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof AbstractFormat) {
                this.medias.addMedia((AbstractFormat)list.get(n));
            } else {
                File file = (File)list.get(n);
                if (file.isDirectory()) {
                    this.medias.add(new VirtualFolder(file.getName()));
                } else {
                    this.medias.addMedia(file);
                }
            }
            ++n;
        }
    }

    public synchronized void delete(int[] nArray) {
        int n = 0;
        List list = this.medias.getContent();
        int n2 = list.size() - 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            if (n5 < list.size() && n5 >= 0) {
                list.set(n5, null);
                ++n;
                if (n5 > n2) {
                    n2 = n5;
                } else if (n5 < n3) {
                    n3 = n5;
                }
            }
            ++n4;
        }
        if (n == 0) {
            return;
        }
        while (list.remove(null)) {
        }
        this.fireTableRowsDeleted(n3, n2);
    }

    public int getRowCount() {
        return this.medias == null ? 0 : (this.medias.getContent() == null ? 0 : this.medias.getContent().size());
    }

    public Object getValueAt(int n, int n2) {
        if (this.medias != null && n >= 0 && n < this.medias.getContent().size()) {
            AbstractFormat abstractFormat;
            Object e = this.medias.getContent().get(n);
            if (e instanceof AbstractFormat) {
                return this.getValueAt(((AbstractFormat)e).getFile(), ((AbstractFormat)e).getInfo(), n2);
            }
            if (e instanceof File && (abstractFormat = MediaFormatFactory.createMediaFormat((File)e)) != null && abstractFormat.isValid()) {
                return this.getValueAt((File)e, abstractFormat.getInfo(), n2);
            }
        }
        return null;
    }

    public Object getElementAt(int n) {
        return this.medias.getContent().get(n);
    }

    protected int getDescriptionIndex() {
        return 1;
    }
}

