/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.MP3;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.media.ContentMatcher;
import photoorganizer.media.PlaybackRequest;
import rogatkin.GranulatedLayout;

public class PlaybackProperties
extends JPanel {
    public static final int START_YEAR = 1938;
    public static final String[] PLAY_ATTRIBUTES = new String[]{"Album", "ArtistWebpage", "AudioFileWebpage", "AudioSourceWebpage", "Band", "CDIdentifier", "Comments", "Composer", "Conductor", "ContentGroup", "CopyrightText", "Copyright", "CopyrightWebpage", "FileOwner", "FileType", "InitialKey", "InternetRadioStationName", "InternetRadioStationOwner", "InternetRadioStationWebpage", "ISRC", "Language", "Lyricist", "MediaType", "Original", "OriginalArtist", "OriginalLyricist", "OriginalTitle", "OriginalYear", "Ownership", "Publisher", "PublishersWebpage", "RecordingDates", "Remixer", "Reverb", "Subtitle", "Title", "Track", "UniqueFileIdentifier", "UserDefinedText", "Bitrate", "Mode", "Samplerate"};
    protected Controller controller;
    protected Window window;
    protected ListSelectionPanel gsp;
    protected ListSelectionPanel asp;
    protected ListSelectionPanel ysp;
    protected ListSelectionPanel dsp;
    protected JCheckBox cb_intro;
    protected JCheckBox cb_exclude;
    protected JRadioButton rb_rand;
    protected JRadioButton rb_shuffl;
    protected ContentMatcher matcher;
    protected JComboBox cb_schema;

    public PlaybackProperties(Controller controller, Window window) {
        this.setLayout((LayoutManager)new GranulatedLayout(5, 13, 20, 4, 8, 8));
        this.controller = controller;
        if (window == null) {
            throw new IllegalArgumentException("Window cannot be null.");
        }
        this.window = window;
        this.add((Component)new JLabel("Schema name"), "0,0");
        this.cb_schema = new JComboBox();
        this.add(this.cb_schema, "1,0,2");
        this.cb_schema.setEditable(true);
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        this.gsp = new GenreSelectionPanel();
        jTabbedPane.insertTab("Genre", null, this.gsp, "Provide genre of music you would like to listen", 0);
        this.asp = new ArtistSelectionPanel();
        jTabbedPane.insertTab("Artist", null, this.asp, "Provide artist of music you would like to listen", 1);
        this.ysp = new YearSelectionPanel();
        jTabbedPane.insertTab("Years", null, this.ysp, "Provide years of music you would like to listen", 2);
        this.dsp = new AdditionsSelectionPanel();
        jTabbedPane.insertTab("Additions", null, this.dsp, "Provide additional requirements to music you would like to listen", 3);
        this.add((Component)jTabbedPane, "0,1,5,9");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rb_rand = new JRadioButton("Random");
        this.add((Component)this.rb_rand, "0,10");
        buttonGroup.add(this.rb_rand);
        this.rb_rand.setSelected(true);
        this.rb_shuffl = new JRadioButton("Shuffle");
        this.add((Component)this.rb_shuffl, "1,10");
        buttonGroup.add(this.rb_shuffl);
        this.cb_exclude = new JCheckBox("Exclude");
        this.add((Component)this.cb_exclude, "2,10");
        this.cb_intro = new JCheckBox("Introductory mode");
        this.add((Component)this.cb_intro, "3,10,2");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("OK");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlaybackProperties.this.matcher = new ContentMatcher();
                PlaybackProperties.this.matcher.setGenres(PlaybackProperties.this.gsp.getData());
                PlaybackProperties.this.matcher.setArtists(PlaybackProperties.this.asp.getData());
                PlaybackProperties.this.matcher.setYears(PlaybackProperties.this.ysp.getData());
                PlaybackProperties.this.matcher.setExcludeMode(PlaybackProperties.this.cb_exclude.isSelected());
                PlaybackProperties.this.matcher.setExtraConditions(PlaybackProperties.this.dsp.getData());
                PlaybackProperties.this.window.dispose();
            }
        });
        jButton = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlaybackProperties.this.window.dispose();
            }
        });
        jPanel.add(new JButton("Help"));
        jPanel.add(new JButton("Advanced >>"));
        this.add((Component)jPanel, "1,11,4,2");
    }

    public ContentMatcher getMatcher() {
        return this.matcher;
    }

    public void applyTo(PlaybackRequest playbackRequest) {
        playbackRequest.matcher = this.getMatcher();
        if (!this.cb_intro.isSelected()) {
            playbackRequest.introFrames = 0;
        }
        playbackRequest.shuffled = this.rb_shuffl.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doModal(Controller controller, PlaybackRequest playbackRequest) {
        JFrame jFrame = new JFrame("Selection criteria specification");
        jFrame.setIconImage(controller.getMainIcon());
        final PlaybackProperties playbackProperties = new PlaybackProperties(controller, jFrame);
        jFrame.setContentPane(playbackProperties);
        jFrame.setDefaultCloseOperation(2);
        jFrame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent windowEvent) {
                PlaybackProperties playbackProperties2 = playbackProperties;
                synchronized (playbackProperties2) {
                    playbackProperties.notify();
                }
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
        PlaybackProperties playbackProperties2 = playbackProperties;
        synchronized (playbackProperties2) {
            try {
                playbackProperties.wait();
                playbackProperties.applyTo(playbackRequest);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static PlaybackProperties doPropertiesDialog(Controller controller, Frame frame) {
        PlaybackProperties playbackProperties = null;
        JDialog jDialog = new JDialog(frame == null ? controller.getMainFrame() : frame, "Selection criteria specification", true);
        playbackProperties = new PlaybackProperties(controller, jDialog);
        jDialog.setContentPane(playbackProperties);
        jDialog.pack();
        jDialog.show();
        return playbackProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] doModal(Controller controller, Object[] objectArray) {
        if (objectArray == null) return null;
        if (objectArray.length == 0) {
            return null;
        }
        JFrame jFrame = new JFrame("Selection criteria specification");
        jFrame.setIconImage(controller.getMainIcon());
        final PlaybackProperties playbackProperties = new PlaybackProperties(controller, jFrame);
        jFrame.getContentPane().add((Component)playbackProperties, "Center");
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent windowEvent) {
                PlaybackProperties playbackProperties2 = playbackProperties;
                synchronized (playbackProperties2) {
                    playbackProperties.notify();
                }
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
        PlaybackProperties playbackProperties2 = playbackProperties;
        synchronized (playbackProperties2) {
            try {
                playbackProperties.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        ContentMatcher contentMatcher = playbackProperties.getMatcher();
        if (contentMatcher == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof AbstractFormat) {
                if (contentMatcher.match((AbstractFormat)objectArray[n2])) {
                    objectArray[n++] = objectArray[n2];
                }
            } else if (objectArray[n2] instanceof File && contentMatcher.match(MediaFormatFactory.createMediaFormat((File)objectArray[n2]))) {
                objectArray[n++] = objectArray[n2];
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    class AdditionsSelectionPanel
    extends ListSelectionPanel {
        JList l_types;
        JTextField tf_addition;
        Object[] selectedItems;

        AdditionsSelectionPanel() {
            this.selectedItems = new Object[1];
            this.tf_addition = new JTextField();
            this.add((Component)this.tf_addition, "3,1,2");
            this.l_types = new JList<String>(PLAY_ATTRIBUTES);
            this.add((Component)new JScrollPane(this.l_types), "3,2,2,5");
            this.tf_addition.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ AdditionsSelectionPanel this$1;
                {
                    this.this$1 = additionsSelectionPanel;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.this$1.updateUiState();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.this$1.updateUiState();
                }
            });
            this.updateUiState();
        }

        Object[] getSelectedItems() {
            String string = this.tf_addition.getText().trim();
            if (string.length() == 0) {
                return null;
            }
            Object[] objectArray = this.l_types.getSelectedValues();
            if (objectArray != null && objectArray.length > 0) {
                string = string + "{" + objectArray[0];
                int n = 1;
                while (n < objectArray.length) {
                    string = string + "," + objectArray[n];
                    ++n;
                }
                string = string + "}";
            }
            this.selectedItems[0] = string;
            return this.selectedItems;
        }

        void clearSelection() {
            this.l_types.removeSelectionInterval(0, PLAY_ATTRIBUTES.length - 1);
            this.tf_addition.setText("");
        }

        Object[] getAllItems() {
            return null;
        }
    }

    class YearSelectionPanel
    extends ListSelectionPanel {
        JList l_years;

        YearSelectionPanel() {
            this.l_years = new JList(new DefaultListModel());
            this.add((Component)new JScrollPane(this.l_years), "3,1,1,6");
            int n = Calendar.getInstance().get(1);
            DefaultListModel defaultListModel = (DefaultListModel)this.l_years.getModel();
            int n2 = 1938;
            while (n2 <= n) {
                defaultListModel.addElement(new Integer(n2));
                ++n2;
            }
            this.l_years.addListSelectionListener(this);
            this.updateUiState();
        }

        Object[] getSelectedItems() {
            return this.l_years.getSelectedValues();
        }

        void clearSelection() {
            this.l_years.removeSelectionInterval(0, ((DefaultListModel)this.l_years.getModel()).size() - 1);
        }

        Object[] getAllItems() {
            return ((DefaultListModel)this.l_years.getModel()).toArray();
        }
    }

    class ArtistSelectionPanel
    extends ListSelectionPanel {
        JTextField tf_artist;
        Object[] selectedItems;

        ArtistSelectionPanel() {
            this.selectedItems = new Object[1];
            this.tf_artist = new JTextField();
            this.add((Component)this.tf_artist, "3,1,2");
            this.tf_artist.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ ArtistSelectionPanel this$1;
                {
                    this.this$1 = artistSelectionPanel;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.this$1.updateUiState();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.this$1.updateUiState();
                }
            });
            this.updateUiState();
        }

        Object[] getSelectedItems() {
            String string = this.tf_artist.getText().trim();
            if (string.length() == 0) {
                return null;
            }
            this.selectedItems[0] = string;
            return this.selectedItems;
        }

        void clearSelection() {
            this.tf_artist.setText("");
        }

        Object[] getAllItems() {
            return null;
        }
    }

    class GenreSelectionPanel
    extends ListSelectionPanel {
        JList l_genres;

        GenreSelectionPanel() {
            Object[] objectArray = (String[])MP3.GENRES.clone();
            Arrays.sort(objectArray);
            this.l_genres = new JList<Object>(objectArray);
            this.add((Component)new JScrollPane(this.l_genres), "3,1,2,6");
            this.l_genres.addListSelectionListener(this);
            this.updateUiState();
        }

        Object[] getSelectedItems() {
            return this.l_genres.getSelectedValues();
        }

        void clearSelection() {
            this.l_genres.removeSelectionInterval(0, MP3.GENRES.length - 1);
        }

        Object[] getAllItems() {
            return MP3.GENRES;
        }
    }

    class ListSelectionPanel
    extends JPanel
    implements ActionListener,
    ListSelectionListener {
        JList resultList;
        JButton btnCopy;
        JButton btnCopyAll;
        JButton btnDelete;
        JButton btnDeleteAll;

        ListSelectionPanel() {
            this.setLayout((LayoutManager)new GranulatedLayout(5, 8, 20, 4, 8, 8));
            this.resultList = new JList(new DefaultListModel());
            this.add((Component)new JScrollPane(this.resultList), "0,1,2,6");
            this.resultList.addListSelectionListener(this);
            this.btnCopy = new JButton("<");
            this.add((Component)this.btnCopy, "2,2");
            this.btnCopy.addActionListener(this);
            this.btnCopyAll = new JButton("<<");
            this.add((Component)this.btnCopyAll, "2,3");
            this.btnCopyAll.addActionListener(this);
            this.btnDelete = new JButton(">");
            this.add((Component)this.btnDelete, "2,4");
            this.btnDelete.addActionListener(this);
            this.btnDeleteAll = new JButton(">>");
            this.add((Component)this.btnDeleteAll, "2,5");
            this.btnDeleteAll.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            DefaultListModel defaultListModel = (DefaultListModel)this.resultList.getModel();
            if ("<".equals(string)) {
                this.addElements(this.getSelectedItems(), defaultListModel);
                this.clearSelection();
            } else if ("<<".equals(string)) {
                this.addElements(this.getAllItems(), defaultListModel);
            } else if (">".equals(string)) {
                this.removeElements(this.resultList.getSelectedValues(), defaultListModel);
            } else if (">>".equals(string)) {
                defaultListModel.removeAllElements();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateUiState();
        }

        Object[] getData() {
            DefaultListModel defaultListModel = (DefaultListModel)this.resultList.getModel();
            return defaultListModel.toArray();
        }

        void updateUiState() {
            Object[] objectArray = this.getSelectedItems();
            this.btnCopy.setEnabled(objectArray != null && objectArray.length > 0);
            this.btnCopyAll.setEnabled(this.getAllItems() != null);
            objectArray = this.resultList.getSelectedValues();
            this.btnDelete.setEnabled(objectArray != null && objectArray.length > 0);
            this.btnDeleteAll.setEnabled(((DefaultListModel)this.resultList.getModel()).size() > 0);
        }

        void addElements(Object[] objectArray, DefaultListModel defaultListModel) {
            int n = 0;
            while (objectArray != null && n < objectArray.length) {
                if (!defaultListModel.contains(objectArray[n])) {
                    defaultListModel.addElement(objectArray[n]);
                }
                ++n;
            }
        }

        void removeElements(Object[] objectArray, DefaultListModel defaultListModel) {
            int n = 0;
            while (objectArray != null && n < objectArray.length) {
                defaultListModel.removeElement(objectArray[n]);
                ++n;
            }
        }

        Object[] getSelectedItems() {
            return null;
        }

        void clearSelection() {
        }

        Object[] getAllItems() {
            return null;
        }
    }
}

