/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.CIFF;
import photoorganizer.formats.Exif;
import photoorganizer.formats.JFXX;
import photoorganizer.renderer.AttributeTableModel;
import photoorganizer.renderer.HashPropTableModel;
import photoorganizer.renderer.PropertiesTableModel;

public class PropertiesPanel
extends JTabbedPane {
    public PropertiesPanel(AbstractFormat abstractFormat) {
        AbstractInfo abstractInfo = abstractFormat.getInfo();
        if (abstractInfo instanceof Exif) {
            this.insertTab("Main", null, new JScrollPane(new JTable(new PropertiesTableModel((Exif)abstractInfo))), "Main image IFD", 0);
            this.insertTab("Thumbnail", null, new JScrollPane(new JTable(new PropertiesTableModel((Exif)abstractInfo, false))), "Thumbnail image IFD", 1);
        } else if (abstractInfo instanceof JFXX) {
            this.insertTab("Picture", null, new JScrollPane(new JTable(new HashPropTableModel(((JFXX)abstractInfo).getPictureInfo()))), "[Picture info]", 0);
            this.insertTab("Camera", null, new JScrollPane(new JTable(new HashPropTableModel(((JFXX)abstractInfo).getCameraInfo()))), "[Camera info]", 1);
            this.insertTab("Diagnostic", null, new JScrollPane(new JTable(new HashPropTableModel(((JFXX)abstractInfo).getDiagInfo()))), "[Diag info]", 2);
        } else if (abstractInfo instanceof CIFF) {
            this.insertTab("Heap", null, new JScrollPane(new JTable(new HashPropTableModel(((CIFF)abstractInfo).getProperties()))), "CIFF Heap", 0);
        } else if (abstractFormat.getType() == "MP3") {
            this.insertTab("ID3", null, new JScrollPane(new JTable(new AttributeTableModel(abstractInfo, AbstractInfo.PLAY_ATTRIBUTES))), "Music fragment attributes extracted from ID3 tag v1 & v2", 0);
            this.insertTab("Media", null, new JScrollPane(new JTable(new AttributeTableModel(abstractInfo, AbstractInfo.MEDIA_ATTRIBUTES))), "Media attributes", 1);
        }
    }

    public void setProperties(AbstractFormat abstractFormat) {
    }

    public static void showProperties(AbstractFormat abstractFormat, Controller controller) {
        JFrame jFrame = new JFrame("Properties of " + abstractFormat.getFile());
        jFrame.getContentPane().add(new PropertiesPanel(abstractFormat));
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setIconImage(controller.getMainIcon());
    }
}

