/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.renderer.StatusBar;
import photoorganizer.renderer.VirtualFolder;
import rogatkin.Serializer;

class RipperModel
extends VirtualFolder
implements TreeModel {
    EventListenerList listenerList = new EventListenerList();
    boolean music;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public RipperModel(boolean bl) {
        super("" + Math.round(Math.random() * 10000.0));
        this.music = bl;
    }

    public void reset(boolean bl) {
        this.music = bl;
        this.clear();
        this.medias = null;
    }

    public Object getChild(Object object, int n) {
        if (object instanceof List) {
            return ((List)object).get(n);
        }
        return null;
    }

    public Object getRoot() {
        return this;
    }

    public int getChildCount(Object object) {
        if (object instanceof List) {
            return ((List)object).size();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        return false;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        Object[] objectArray;
        if (object != null) {
            VirtualFolder virtualFolder = (VirtualFolder)(treePath == null ? this : treePath.getLastPathComponent());
            virtualFolder.setName(object.toString());
        }
        if (treePath == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this;
        } else {
            objectArray = treePath.getPath();
        }
        this.fireTreeStructureChanged(this, objectArray, null, null);
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof List) {
            return ((List)object).indexOf(object2);
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = RipperModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = RipperModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
    }

    public void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n = 0;
        while (n < objectArray3.length - 1) {
            if (objectArray3[n] == (class$javax$swing$event$TreeModelListener == null ? RipperModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[n + 1]).treeStructureChanged(treeModelEvent);
            }
            n += 2;
        }
    }

    public void fireTreeNodesChanged(Object[] objectArray) {
        Object[] objectArray2 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n = objectArray2.length - 2;
        while (n >= 0) {
            if (objectArray2[n] == (class$javax$swing$event$TreeModelListener == null ? RipperModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent((Object)this, objectArray, null, null);
                }
                ((TreeModelListener)objectArray2[n + 1]).treeNodesChanged(treeModelEvent);
            }
            n -= 2;
        }
    }

    public boolean add(Object object) {
        if (!this.music) {
            if (object != null) {
                if (object instanceof VirtualFolder) {
                    return super.add(object);
                }
                throw new ClassCastException("Only VirtualFolder can be added in this way");
            }
            throw new IllegalArgumentException("Can not add null folder");
        }
        throw new UnsupportedOperationException("New folder can not be added to music layout");
    }

    public String toString() {
        if (this.size() == 0 && (this.medias == null || this.medias.size() == 0)) {
            return MessageFormat.format("Empty {0} Layout", this.music ? "Music" : "Data");
        }
        return MessageFormat.format("{0} Layout - {1}/{2}/{3}", this.music ? "Music" : "Data", this.name, new Integer(this.size()), new Integer(this.medias == null ? 0 : this.medias.size()));
    }

    public void doDisk(Controller controller) {
        Serializer serializer = controller.getSerializer();
        String string = (String)serializer.getProperty((Object)"MediaOptions", (Object)"RipperFolder");
        if (string == null) {
            return;
        }
        final File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            return;
        }
        final StatusBar statusBar = (StatusBar)controller.component(Controller.COMP_STATUSBAR);
        if (this.music) {
            new Thread(new Runnable(){

                public void run() {
                    Iterator iterator = RipperModel.this.medias.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        AbstractFormat abstractFormat = e instanceof File ? MediaFormatFactory.createMediaFormat((File)e) : (e instanceof AbstractFormat ? (AbstractFormat)e : null);
                        if (abstractFormat == null || !abstractFormat.isValid() || !"MP3".equals(abstractFormat.getType())) continue;
                        String string = abstractFormat.getName();
                        int n = string.lastIndexOf(46);
                        if (n > 0) {
                            string = string.substring(0, n) + ".wav";
                        }
                        File file2 = new File(file, string);
                        try {
                            Controller.convertToWav(abstractFormat, file2.getPath(), statusBar);
                        }
                        catch (Exception exception) {
                            System.err.println("Exception at convertion of " + abstractFormat + " to " + file2 + ':' + exception);
                        }
                    }
                }
            }, "Convert to wav").start();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

