/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.PopupCombo;
import rogatkin.GranulatedLayout;
import rogatkin.Helpable;
import rogatkin.Persistable;
import rogatkin.Serializer;

public class ThumbnailsOptionsTab
extends JPanel
implements DocumentListener,
Persistable,
Helpable {
    public static final String SECNAME = "ThumbnailsOptions";
    static final String FIXAXIS = "FixedNumber";
    static final String VERTAXIS = "Vertical";
    static final String CELLWIDTH = "CellWidth";
    static final String CELLHEIGHT = "CellHeight";
    public static final String TOOLTIPMASK = "ToolTipMask";
    public static final String LABELMASK = "LabelMask";
    public static final String FILEMASK = "FileMask";
    public static final String SHOWCOMMENT = "ShowComment";
    public static final String BORDER = "Border";
    public static final String SELECTEDBORDER = "SelectedBorder";
    private JTextField tf_cellwidth;
    private JTextField tf_cellheight;
    private JTextField tf_fixedaxis;
    private JTextField tf_tooltipmask;
    private JTextField tf_labelmask;
    private JTextField tf_thumbfilemask;
    private JCheckBox cb_scrollv;
    private JCheckBox cb_comment;
    private JComboBox cb_border;
    private JComboBox cb_sel_border;
    private JLabel lb_col_row;
    private Controller controller;

    public ThumbnailsOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout((LayoutManager)new GranulatedLayout(7, 6, 20, 4, 8, 8));
        this.lb_col_row = new JLabel("Number of ");
        this.add((Component)this.lb_col_row, "0,0,2,1");
        this.tf_fixedaxis = new JTextField();
        this.add((Component)this.tf_fixedaxis, "2,0,1,1");
        this.tf_fixedaxis.setHorizontalAlignment(4);
        this.cb_scrollv = new JCheckBox("Scroll vertically");
        this.add((Component)this.cb_scrollv, "3,0,2,1,12");
        this.add((Component)new JLabel("Thumbnail file mask"), "0,2,2,1");
        this.tf_thumbfilemask = new JTextField();
        this.add((Component)this.tf_thumbfilemask, "2,2,3,1");
        this.tf_thumbfilemask.getDocument().addDocumentListener(this);
        this.add((Component)new JLabel("Thumbnail"), "0,1,1");
        this.add((Component)new JLabel("width:", 4), "1,1,1,1");
        this.tf_cellwidth = new JTextField(4);
        this.add((Component)this.tf_cellwidth, "2,1,1,1");
        this.tf_cellwidth.setHorizontalAlignment(4);
        this.add((Component)new JLabel("height:", 4), "3,1,1,1");
        this.tf_cellheight = new JTextField(4);
        this.add((Component)this.tf_cellheight, "4,1,1,1");
        this.tf_cellheight.setHorizontalAlignment(4);
        this.cb_comment = new JCheckBox("Comment as label");
        this.add((Component)this.cb_comment, "5,1,2");
        this.add((Component)new JLabel("Tooltip mask"), "0,3,2,1");
        this.tf_tooltipmask = new JTextField();
        this.add((Component)this.tf_tooltipmask, "2,3,3,1");
        this.tf_tooltipmask.getDocument().addDocumentListener(this);
        this.add((Component)new JLabel("Label mask"), "0,4,2");
        this.tf_labelmask = new JTextField();
        this.add((Component)this.tf_labelmask, "2,4,3");
        this.tf_labelmask.getDocument().addDocumentListener(this);
        this.add((Component)new PopupCombo(Resources.MASKS[1], "<", this, "5,2,1", this.tf_thumbfilemask), "5,2,2");
        this.add((Component)new PopupCombo(Resources.MASKS[1], "<", this, "5,3,1", this.tf_tooltipmask), "5,3,2");
        this.add((Component)new PopupCombo(Resources.MASKS[1], "<", this, "5,4,1", this.tf_labelmask), "5,4,2");
        this.add((Component)new JLabel(BORDER), "4,5");
        this.add((Component)new JLabel("Selected border"), "0,5,2");
        this.cb_border = new JComboBox<String>(Resources.BORDERS);
        this.add(this.cb_border, "5,5,2");
        this.cb_sel_border = new JComboBox<String>(Resources.BORDERS);
        this.add(this.cb_sel_border, "2,5,2");
        this.cb_scrollv.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ThumbnailsOptionsTab.this.lb_col_row.setText("Number of " + (((AbstractButton)changeEvent.getSource()).isSelected() ? "columns" : "rows"));
            }
        });
    }

    public String getHelp() {
        return "<html>\n<h2>Format escape sequences for pictures and music</h2>\n<pre>\n %D - date/time stamp in current locale,\n %d - date stamp,\n %t - time stamp,\n %s - shutter speed/bitrate,\n %a - aperture value/sample rate,\n %f - flash/protected (yes, no),\n %q - quality/mode\n %c - counter, can be specified as %0..0c, if leading zeros have to be present,\n %o - original file name,\n %r - transformation code expanded to: r90, r270, r180, TrPose, TrVerse, HMirr, VMirr\n %S - file size (undocumented),\n %z - focal length (zoom)/year,\n %M - make/artist\n %m - model/title\n %x - metering mode,\n %X - exposure program\n %n - type extension\n Format escape sequences for music\n %A - album,\n %b - band,\n %C - comment,\n %L - language,\n %g - genre,\n %l - length,\n %T - track,\n %e - composer,\n %E - conductor\n </pre>";
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.tf_tooltipmask.getDocument()) {
            this.tf_tooltipmask.setToolTipText(new FileNameFormat(this.tf_tooltipmask.getText()).format(this.controller.sampleJpeg));
        } else if (document == this.tf_labelmask.getDocument()) {
            this.tf_labelmask.setToolTipText(new FileNameFormat(this.tf_labelmask.getText()).format(this.controller.sampleJpeg));
        } else if (document == this.tf_thumbfilemask.getDocument()) {
            this.tf_thumbfilemask.setToolTipText(FileNameFormat.makeValidPathName(new FileNameFormat(this.tf_thumbfilemask.getText()).format(this.controller.sampleJpeg)));
        }
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        Integer n = (Integer)serializer.getProperty((Object)SECNAME, (Object)FIXAXIS);
        if (n != null) {
            this.tf_fixedaxis.setText(n.toString());
        }
        if ((n = (Integer)serializer.getProperty((Object)SECNAME, (Object)VERTAXIS)) != null) {
            this.cb_scrollv.setSelected(n == 1);
        }
        if ((n = (Integer)serializer.getProperty((Object)SECNAME, (Object)CELLWIDTH)) != null) {
            this.tf_cellwidth.setText(n.toString());
        }
        if ((n = (Integer)serializer.getProperty((Object)SECNAME, (Object)CELLHEIGHT)) != null) {
            this.tf_cellheight.setText(n.toString());
        }
        this.tf_tooltipmask.setText(Serializer.arrayToString((Object)serializer.getProperty((Object)SECNAME, (Object)TOOLTIPMASK)));
        this.tf_labelmask.setText(Serializer.arrayToString((Object)serializer.getProperty((Object)SECNAME, (Object)LABELMASK)));
        this.tf_thumbfilemask.setText(Serializer.arrayToString((Object)serializer.getProperty((Object)SECNAME, (Object)FILEMASK)));
        this.cb_comment.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)SHOWCOMMENT), (int)0) == 1);
        this.cb_border.setSelectedItem(serializer.getProperty((Object)SECNAME, (Object)BORDER));
        this.cb_sel_border.setSelectedItem(serializer.getProperty((Object)SECNAME, (Object)SELECTEDBORDER));
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        try {
            serializer.setProperty((Object)SECNAME, (Object)FIXAXIS, (Object)new Integer(this.tf_fixedaxis.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        serializer.setProperty((Object)SECNAME, (Object)VERTAXIS, (Object)(this.cb_scrollv.isSelected() ? Resources.I_YES : Resources.I_NO));
        try {
            serializer.setProperty((Object)SECNAME, (Object)CELLWIDTH, (Object)new Integer(this.tf_cellwidth.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            serializer.setProperty((Object)SECNAME, (Object)CELLHEIGHT, (Object)new Integer(this.tf_cellheight.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        serializer.setProperty((Object)SECNAME, (Object)TOOLTIPMASK, (Object)this.tf_tooltipmask.getText());
        serializer.setProperty((Object)SECNAME, (Object)LABELMASK, (Object)this.tf_labelmask.getText());
        serializer.setProperty((Object)SECNAME, (Object)FILEMASK, (Object)this.tf_thumbfilemask.getText());
        serializer.setProperty((Object)SECNAME, (Object)SHOWCOMMENT, (Object)(this.cb_comment.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)BORDER, this.cb_border.getSelectedItem());
        serializer.setProperty((Object)SECNAME, (Object)SELECTEDBORDER, this.cb_sel_border.getSelectedItem());
    }

    public static Border createBorder(String string) {
        if ("BevelLowered".equals(string)) {
            return new BevelBorder(1);
        }
        if ("BevelRaised".equals(string)) {
            return new BevelBorder(0);
        }
        if ("Etched".equals(string)) {
            return new EtchedBorder();
        }
        if ("Line".equals(string)) {
            return new LineBorder(Color.blue);
        }
        return null;
    }
}

