/* PhotoOrganizer - $RCSfile: InfoReader.java,v $ 
 * Copyright (C) 2001 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  
 *  Visit http://drogatkin.openestate.net to get the latest infromation
 *  about Rogatkin's products.
 *  $Id: InfoReader.java,v 1.2 2001/04/17 09:01:01 dmitriy Exp $
 */

package photoorganizer.formats.mp3;

import java.io.*;
import java.net.*;
import java.text.*;
import de.vdheide.mp3.MP3File;
import de.vdheide.mp3.FrameDamagedException;
public class InfoReader {
	static final String LAYER_NAMES[] = { "I", "II", "III" };
	static final String S_FREQ[] = {"44.1", "48", "32", "0"};
	static final String MODE_NAMES[] = { "stereo", "j-stereo", "dual-ch", "mono" };

	static final int BITRATES[][][] = 
	{
			{
			{0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448},
			{0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384},
			{0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320}
			
			},
			{
			{0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256},
			{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160},
			{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}
			
			},
			{
			{0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256},
			{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160},
			{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}
			
			}
	};
	
	public final static String GENRES [] = {
		"Blues", // 0
		"Classic Rock", // 1
		"Country", // 2
		"Dance", // 3
		"Disco", // 4
		"Funk", // 5
		"Grunge", // 6
		"Hip-Hop", // 7
		"Jazz", // 8
		"Metal", // 9
		"New Age", // 10
		"Oldies", // 11
		"Other", // 12
		"Pop", // 13
		"R&B", // 14
		"Rap", // 15
		"Reggae", // 16
		"Rock", // 17
		"Techno", // 18
		"Industrial", // 19
		"Alternative", // 20
		"Ska", // 21
		"Death Meta", // 22
		"Pranks", // 23
		"Soundtrack", // 24
		"Euro-Techno", // 25
		"Ambient", // 26
		"Trip-Hop", // 27
		"Vocal", // 28
		"Jazz+Funk", // 29
		"Fusion", // 30
		"Trance", // 31
		"Classical", // 32
		"Instrumental", // 33
		"Acid", // 34
		"House", // 35
		"Game" , // 36
		"Sound Clip", // 37
		"Gospel", // 38
		"Noise", // 39
		"AlternRock", // 40
		"Bass", // 41
		"Soul", // 42
		"Punk", // 43
		"Space", // 44
		"Meditative", // 45
		"Instrumental Pop", // 46
		"Instrumental Rock", // 47
		"Ethnic", // 48
		"Gothic", // 49
		"Darkwave", // 50
		"Techno-Industrial", // 51
		"Electronic", // 52
		"Pop-Folk", // 53
		"Eurodance", // 54
		"Dream", // 55
		"Southern Rock", // 56
		"Comedy", // 57
		"Cult", // 58
		"Gangsta", // 59
		"Top 40", // 60
		"Christian Rap", // 61
		"Pop/Funk", // 62
		"Jungle", // 63
		"Native American", // 64
		"Cabaret", // 65
		"New Wave", // 66
		"Psychadelic", // 67
		"Rave", // 68
		"Showtunes", // 69
		"Trailer", // 70
		"Lo-Fi", // 71
		"Tribal", // 72
		"Acid Punk", // 73
		"Acid Jazz", // 74
		"Polka", // 75
		"Retro", // 76
		"Musical", // 77
		"Rock & Roll", // 78
		"Hard Rock", // 79
		// WinAmp expanded this table with next codes:
		"Folk", // 80
		"Folk-Rock", // 81
		"National Folk", // 82
		"Swing", // 83
		"Fast Fusion", // 84
		"Bebob", // 85
		"Latin", // 86
		"Revival", // 87
		"Celtic", // 88
		"Bluegrass", // 89
		"Avantgarde", // 90
		"Gothic Rock", // 91
		"Progressive Rock", // 92
		"Psychedelic Rock", // 93
		"Symphonic Rock", // 94
		"Slow Rock", // 95
		"Big Band", // 96
		"Chorus", // 97
		"Easy Listening", // 98
		"Acoustic", // 99
		"Humour", // 100
		"Speech", // 101
		"Chanson", // 102
		"Opera", // 103
		"Chamber Music", // 104
		"Sonata", // 105
		"Symphony", // 106
		"Booty Brass", // 107
		"Primus", // 108
		"Porn Groove", // 109
		"Satire", // 110
		"Slow Jam", // 111
		"Club", // 112
		"Tango", // 113
		"Samba", // 114
		"Folklore", // 115
		"Ballad", // 116
		"Poweer Ballad", // 117
		"Rhytmic Soul", // 118
		"Freestyle", // 119
		"Duet", // 120
		"Punk Rock", // 121
		"Drum Solo", // 122
		"A Capela", // 123
		"Euro-House", // 124
		"Dance Hall" // 125 
		};
 
	public boolean read(InputStream _is) throws IOException {
		if (!skipToSync(_is))
			return false;
		byte[] buff = new byte[4];
		_is.read(buff);
		HeaderInfo hi = unpackHeader(buff);
		int secs = 200;
		System.out.println("Indexes: "+hi.version+'/'+(hi.lay-1)+'/'+hi.bitrateIndex);
		System.out.println(MessageFormat.format("{0,number}Kbps  {1}  {2}  {3,number}:{4,number,##}",
												new Object[]{new Integer(BITRATES[hi.version][hi.lay-1][hi.bitrateIndex]),
												S_FREQ[hi.samplingFrequency],
												MODE_NAMES[hi.mode],
												new Integer(secs/60),
												new Integer(secs%60)}));
						   
		return true;
	}
	
	boolean skipToSync(InputStream _is) throws IOException  {
		for (int i = 0; i < 8000; i++) {
			int r = _is.read();
			if (r < 0)
				return false;
			if (r == 0xff)
				return true;
		}
		return false;
	}
	
	HeaderInfo unpackHeader (byte[] _packedHeader) {
		HeaderInfo hi = new HeaderInfo();
		hi.version = (_packedHeader[1]>>3) & 0x1;           //+1 = 13
		hi.lay = 4 - ((_packedHeader[1]>>1) & 3);           //+2 = 15
		if (hi.lay == 0)
			System.err.println("Unknown layer:"+hi.lay);
		else 
			System.out.println("Layer:"+hi.lay);
		hi.errorProtection = (_packedHeader[1]) & 1;       //+1 = 16

		hi.bitrateIndex = (_packedHeader[2]>>4) & 0xf;      //+4 = 20
		hi.samplingFrequency = (_packedHeader[2]>>2) & 3;   //+2 = 22
		hi.padding = (_packedHeader[2]>>1) & 1;             //+1 = 23
		hi.extension = (_packedHeader[2]) & 1;              //+1 = 24

		hi.mode = (_packedHeader[3]>>6) & 3;                //+2 = 26
		hi.modeExt = (_packedHeader[3]>>4) & 3;             //+2 = 28
		hi.copyright = (_packedHeader[3]>>3) & 1;           //+1 = 29
		hi.original = (_packedHeader[3]>>2) & 1;            //+1 = 30
		hi.emphasis = (_packedHeader[3]) & 3;               //+2 = 32  
		return hi;
	}
	
	static public void main(String[] args) {
		if (args.length == 0) {
			System.out.println("Usage: file/url [... file/url]");
			System.exit(255);
		}
		if (true) 
		 try {
			MP3File mp3f = new MP3File(args[0]);
			System.out.println("File:"+args[0]+"\n BR:"+mp3f.getBitrate()
							   +"Kbps, frequency "+(mp3f.getSamplerate()/1000)+'.'+(mp3f.getSamplerate()%1000)+"Khz, mode:"+MODE_NAMES[mp3f.getMode()] 
							   +", duration:"+(mp3f.getLength()/60)+':'+(mp3f.getLength()%60)+" minutes.\n"
							   +mp3f.getTitle().getTextContent()+" by "+mp3f.getArtist().getTextContent()+"\nAlbum:"
							   +mp3f.getAlbum().getTextContent()+'('+mp3f.getYear().getTextContent()+"), Genre "+GENRES[Integer.parseInt(mp3f.getGenre().getTextContent())]);
			return ;
		 } catch(Exception e) { //IO, FrameDamagedException
			 System.err.println("The file "+args[0]+" not available, corrupted or not supported media. "+e);
		 }
			
		
		InfoReader ir = new InfoReader();
		for (int i=0; i<args.length; i++) {
			System.out.println("Reading "+args[i]+"...");
			InputStream is = null;
			try {
				is = new URL(args[i]).openStream();
			} catch(Exception e) {
				try {
					is = new BufferedInputStream(new FileInputStream(args[i]));
				} catch(Exception e2) {
					System.out.println("Can't open stream for "+args[i]+':'+e2);
				}
			}
			try {
				System.out.println(args[i]+" seems to be "+(ir.read(is)?"":"in")+"valid file.");
				is.close();
			} catch (IOException ioe) {
				System.out.println("Error in reading "+args[i]+':'+ioe);
			}
		}
	}
}
