/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.Control;
import javax.media.protocol.DataSource;

public class CaptureControlsDialog
extends Dialog
implements WindowListener,
ActionListener {
    private DataSource dataSource;
    private CheckboxMenuItem menuItem;
    private Button buttonClose;
    private int nControlCount;

    public CaptureControlsDialog(Frame parentFrame, DataSource dataSource, CheckboxMenuItem menuItem) {
        super(parentFrame, false);
        this.dataSource = dataSource;
        this.menuItem = menuItem;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public boolean isEmpty() {
        return this.nControlCount < 1;
    }

    private void init() throws Exception {
        this.setTitle("Capture Device Controls");
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        BorderedPanel panelContent = new BorderedPanel(new BorderLayout());
        panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)panelContent, "Center");
        Object[] arrControls = this.dataSource.getControls();
        int nCount = arrControls.length;
        Panel panel = panelContent;
        this.nControlCount = 0;
        int i2 = 0;
        while (i2 < nCount) {
            if (arrControls[i2] instanceof Control) {
                ++this.nControlCount;
                Component componentControl = ((Control)arrControls[i2]).getControlComponent();
                Panel panelNext = new Panel(new BorderLayout(6, 6));
                panelNext.add(componentControl, "North");
                panel.add((Component)panelNext, "Center");
                panel = panelNext;
            }
            ++i2;
        }
        panel = this.createPanelButtons();
        panelContent.add((Component)panel, "South");
        this.pack();
        this.addWindowListener(this);
        this.setResizable(false);
    }

    private Panel createPanelButtons() throws Exception {
        Panel panelButtons = new Panel(new FlowLayout(1));
        Panel panel = new Panel(new GridLayout(1, 0, 6, 6));
        panelButtons.add(panel);
        this.buttonClose = new Button("Close");
        this.buttonClose.addActionListener(this);
        panel.add(this.buttonClose);
        return panelButtons;
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals(this.buttonClose.getLabel())) {
            if (this.menuItem != null) {
                this.menuItem.setState(false);
            }
            ((Component)this).setVisible(false);
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        if (this.menuItem != null) {
            this.menuItem.setState(false);
        }
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }
}

