/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.net.URL;

public class MessageDialog
extends Dialog
implements ActionListener,
WindowListener {
    public static final String ACTION_OK = " OK ";
    public static final String ACTION_CANCEL = "Cancel";
    protected String strMessage;
    protected Image image;
    private Button buttonOK;
    private Button buttonCancel;
    private boolean needCancel;
    private String strAction;

    public MessageDialog(Frame frame, String strTitle, String strMessage, Image image, boolean boolModal, boolean needCancel) {
        super(frame, strTitle, boolModal);
        this.strMessage = strMessage;
        this.image = image;
        this.needCancel = needCancel;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public MessageDialog(Frame frame, String strTitle, String strMessage, Image image, boolean boolModal) {
        this(frame, strTitle, strMessage, image, boolModal, false);
    }

    public static String createErrorDialog(Frame frame, String strMessage) {
        if (frame == null) {
            frame = new Frame();
        }
        Image image = MessageDialog.loadImage("/images/iconError.gif");
        MessageDialog dlg = new MessageDialog(frame, "JMStudio Error", strMessage, image, true);
        dlg.show();
        return dlg.strAction;
    }

    public static String createErrorDialog(Frame frame, Exception exception) {
        String strAction = MessageDialog.createErrorDialog(frame, null, exception);
        return strAction;
    }

    public static String createErrorDialog(Frame frame, String strText, Exception exception) {
        String strMessage = exception.getMessage();
        if (strMessage == null || strMessage.trim().length() < 1) {
            strMessage = exception.getClass().getName();
        }
        strMessage = "Exception. " + String.valueOf('\r') + strMessage;
        if (strText != null) {
            strMessage = String.valueOf(strText) + String.valueOf('\r') + strMessage;
        }
        String strAction = MessageDialog.createErrorDialog(frame, strMessage);
        return strAction;
    }

    public static String createInfoDialog(Frame frame, String strMessage) {
        if (frame == null) {
            frame = new Frame();
        }
        Image image = MessageDialog.loadImage("/images/iconInfo.gif");
        MessageDialog dlg = new MessageDialog(frame, "JMStudio", strMessage, image, true);
        dlg.show();
        return dlg.strAction;
    }

    public static String createWarningDialog(Frame frame, String strMessage) {
        if (frame == null) {
            frame = new Frame();
        }
        Image image = MessageDialog.loadImage("/images/iconWarning.gif");
        MessageDialog dlg = new MessageDialog(frame, "JMStudio Warning", strMessage, image, true);
        dlg.show();
        return dlg.strAction;
    }

    public static String createOKCancelDialog(Frame frame, String strMessage) {
        if (frame == null) {
            frame = new Frame();
        }
        Image image = MessageDialog.loadImage("/images/iconQuery.gif");
        MessageDialog dlg = new MessageDialog(frame, "JMStudio Query", strMessage, image, true, true);
        dlg.show();
        return dlg.strAction;
    }

    public static void createErrorDialogModeless(Frame frame, String strMessage) {
        if (frame == null) {
            frame = new Frame();
        }
        Image image = MessageDialog.loadImage("/images/iconError.gif");
        MessageDialog dlg = new MessageDialog(frame, "JMStudio Error", strMessage, image, false);
        dlg.show();
    }

    public static void createErrorDialogModeless(Frame frame, String strText, Exception exception) {
        String strMessage = exception.getMessage();
        if (strMessage == null || strMessage.trim().length() < 1) {
            strMessage = exception.getClass().getName();
        }
        strMessage = "Exception. " + String.valueOf('\r') + strMessage;
        if (strText != null) {
            strMessage = String.valueOf(strText) + String.valueOf('\r') + strMessage;
        }
        MessageDialog.createErrorDialogModeless(frame, strMessage);
    }

    public static Image loadImage(String strFileName) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Class<?> classObject = Class.forName("MessageDialog");
            URL url = classObject.getResource(strFileName);
            if (url != null) {
                Object objImageProducer = url.getContent();
                if (objImageProducer instanceof ImageProducer) {
                    ImageProducer imageProducer = (ImageProducer)objImageProducer;
                    image = toolkit.createImage(imageProducer);
                } else if (objImageProducer instanceof BufferedInputStream) {
                    BufferedInputStream streamImage = (BufferedInputStream)objImageProducer;
                    byte[] arrImageBytes = new byte[streamImage.available()];
                    streamImage.read(arrImageBytes);
                    image = toolkit.createImage(arrImageBytes);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public static Image loadImage(String strFileName, Component component, boolean boolWait) {
        Image image;
        block2: {
            image = MessageDialog.loadImage(strFileName);
            if (image == null || !boolWait) break block2;
            MediaTracker trackerMedia = new MediaTracker(component);
            trackerMedia.addImage(image, 1001);
            try {
                trackerMedia.waitForID(1001);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    protected void init() throws Exception {
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(6, 6));
        ((Component)this).setBackground(Color.lightGray);
        if (this.strMessage != null) {
            MessageArea fieldMessage = new MessageArea(this.strMessage);
            this.add((Component)fieldMessage, "Center");
        }
        Panel panelImage = new Panel(new FlowLayout(1));
        this.add((Component)panelImage, "West");
        if (this.image != null) {
            MediaTracker trackerMedia = new MediaTracker(this);
            trackerMedia.addImage(this.image, 1001);
            try {
                trackerMedia.waitForID(1001);
            }
            catch (Exception exception) {}
            ImageArea fieldImage = new ImageArea(this.image);
            panelImage.add(fieldImage);
        }
        Panel panelButtons = new Panel(new FlowLayout(1));
        this.add((Component)panelButtons, "South");
        this.buttonOK = new Button(ACTION_OK);
        this.buttonOK.addActionListener(this);
        panelButtons.add(this.buttonOK);
        if (this.needCancel) {
            this.buttonCancel = new Button(ACTION_CANCEL);
            this.buttonCancel.addActionListener(this);
            panelButtons.add(this.buttonCancel);
        }
        Panel panel = new Panel();
        this.add((Component)panel, "North");
        panel = new Panel();
        this.add((Component)panel, "East");
        this.pack();
        Dimension dimDialog = this.getPreferredSize();
        ((Component)this).setSize(dimDialog);
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimScreen.width - dimDialog.width) / 2, (dimScreen.height - dimDialog.height) / 2);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent event) {
        this.strAction = event.getActionCommand();
        if (this.strAction.equals(ACTION_OK)) {
            this.dispose();
        }
        if (this.strAction.equals(ACTION_CANCEL)) {
            this.dispose();
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }
}

