/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.parser.video;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.format.WavAudioFormat;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.util.LoopThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadAction;
import java.awt.Dimension;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.MediaException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public class MpegParser
extends BasicPullParser {
    boolean saveOutputFlag = false;
    String AoutName = "Audio.mpg";
    String VoutName = "Video.mpg";
    FileOutputStream aout;
    FileOutputStream vout;
    boolean throwOutputFlag = false;
    boolean hideAudioTracks = false;
    boolean hideVideoTracks = false;
    private static final long NO_PTS_VAL = -3333333L;
    private static final float EPSILON_PTS = 45000.0f;
    private static final float EPSILON_NS = 5.0E8f;
    private static final long PRE_ROLLING_DELTA_NS = 500000000L;
    private static final byte UNKNOWN_TYPE = 0;
    private static final byte AUDIO_TYPE = 1;
    private static final byte VIDEO_TYPE = 2;
    private static final byte SYS11172_TYPE = 3;
    private static final int AUDIO_TRACK_BUF_SIZE = 100000;
    private static final int VIDEO_TRACK_BUF_SIZE = 200000;
    private static final int PACK_START_CODE = 442;
    private static final int SYSTEM_HEADER_START_CODE = 443;
    private static final int PACKET_START_CODE_24 = 1;
    private static final int END_CODE = 441;
    private static final int MIN_STREAM_CODE = 188;
    private static final int MAX_STREAM_CODE = 255;
    private static final int PRIVATE_STREAM2_CODE = 191;
    private static final int VIDEO_PICTURE_START_CODE = 256;
    private static final int VIDEO_SEQUENCE_HEADER_CODE = 435;
    private static final int VIDEO_GROUP_START_CODE = 440;
    private static final int MAX_AUDIO_STREAMS = 32;
    private static final int MAX_VIDEO_STREAMS = 16;
    private static final int MAX_NUM_STREAMS = 48;
    private static final int MIN_AUDIO_ID = 0;
    private static final int MAX_AUDIO_ID = 31;
    private static final int MIN_VIDEO_ID = 32;
    private static final int MAX_VIDEO_ID = 47;
    private static int MAX_TRACKS_SUPPORTED = 48;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("video.mpeg"), new ContentDescriptor("audio.mpeg")};
    private PullSourceStream stream;
    private TrackList[] trackList = new TrackList[MAX_TRACKS_SUPPORTED];
    private Track[] tracks;
    private Track[] videoTracks;
    private Track[] audioTracks;
    private int videoCount;
    private int audioCount;
    private int numSupportedTracks;
    private int numTracks;
    private int numPackets;
    private int initTmpBufLen;
    private byte[] initTmpStreamBuf;
    private byte streamType = 0;
    private long streamContentLength;
    private SystemHeader sysHeader = new SystemHeader();
    private boolean sysHeaderSeen = false;
    private boolean EOMflag = false;
    private boolean parserErrorFlag = false;
    private boolean durationInitialized = false;
    private boolean sysPausedFlag = false;
    private boolean seekableStreamFlag = false;
    private boolean randomAccessStreamFlag = true;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    private Time durationNs = Duration.DURATION_UNKNOWN;
    private long lastSetPositionTimeNs;
    private long startPTS = -3333333L;
    private long currentPTS = -3333333L;
    private long endPTS = -3333333L;
    private long AVstartTimeNs;
    private long AVcurrentTimeNs;
    private long AVlastTimeNs;
    private MpegBufferThread mpThread;
    private Object buffersSync = new Object();
    static /* synthetic */ Class class$com$ibm$media$parser$video$MpegParser$MpegBufferThread;
    static /* synthetic */ Class array$B;

    protected boolean supports(SourceStream[] streams) {
        return super.supports(streams);
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        this.stream = (PullSourceStream)this.streams[0];
        this.streamContentLength = this.stream.getContentLength();
        this.seekableStreamFlag = this.streams[0] instanceof Seekable;
        this.randomAccessStreamFlag = this.seekableStreamFlag && ((Seekable)((Object)this.streams[0])).isRandomAccess();
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public void start() throws IOException {
        this.sysPausedFlag = false;
        super.start();
    }

    public void stop() {
        super.stop();
        this.sysPausedFlag = true;
        if (this.streamType == 3) {
            Object object = this.buffersSync;
            synchronized (object) {
                this.buffersSync.notifyAll();
            }
        }
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.streamType == 3) {
            if (this.hideAudioTracks && this.videoTracks != null) {
                return this.videoTracks;
            }
            if (this.hideVideoTracks && this.audioTracks != null) {
                return this.audioTracks;
            }
        }
        if (this.tracks != null) {
            return this.tracks;
        }
        try {
            this.initTmpBufLen = 100000;
            this.initTmpStreamBuf = new byte[this.initTmpBufLen];
            this.initTmpBufLen = this.detectStreamType(this.initTmpStreamBuf);
            switch (this.streamType) {
                case 1: 
                case 2: {
                    this.initTrackAudioVideoOnly();
                    break;
                }
                case 3: {
                    this.initTrackSystemStream();
                    break;
                }
                default: {
                    throw new BadHeaderException("Couldn't detect stream type");
                }
            }
            this.initDuration();
            if (this.saveOutputFlag) {
                this.aout = new FileOutputStream(this.AoutName);
                this.vout = new FileOutputStream(this.VoutName);
            }
            if (this.streamType == 3) {
                if (jmfSecurity != null) {
                    String permission = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            permission = "thread";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                            permission = "thread group";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable e2) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        Constructor cons = jdk12CreateThreadAction.cons;
                        this.mpThread = (MpegBufferThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$ibm$media$parser$video$MpegParser$MpegBufferThread != null ? class$com$ibm$media$parser$video$MpegParser$MpegBufferThread : (class$com$ibm$media$parser$video$MpegParser$MpegBufferThread = MpegParser.class$("com.ibm.media.parser.video.MpegParser$MpegBufferThread"))));
                    }
                    catch (Exception exception) {}
                } else {
                    this.mpThread = new MpegBufferThread();
                }
                if (this.mpThread != null) {
                    this.mpThread.start();
                }
                if (this.saveOutputFlag || this.throwOutputFlag) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.streamType == 3) {
                if (this.hideAudioTracks) {
                    return this.videoTracks;
                }
                if (this.hideVideoTracks) {
                    return this.audioTracks;
                }
            }
            return this.tracks;
        }
        catch (BadDataException badDataException) {
            this.parserErrorFlag = true;
            throw new BadHeaderException("Bad data");
        }
        catch (BadHeaderException e3) {
            this.parserErrorFlag = true;
            throw e3;
        }
        catch (IOException e4) {
            this.updateEOMState();
            this.EOMflag = true;
            throw e4;
        }
    }

    private int detectStreamType(byte[] streamBuf) throws IOException {
        int i2 = 0;
        int videoCount = 0;
        int audioCount = 0;
        boolean found = false;
        if (this.streamType != 0) {
            return 0;
        }
        try {
            this.readBytes(this.stream, streamBuf, 4);
            block7: while (!found && i2 < streamBuf.length - 5) {
                int code = (streamBuf[i2] & 0xFF) << 24 | (streamBuf[i2 + 1] & 0xFF) << 16 | (streamBuf[i2 + 2] & 0xFF) << 8 | streamBuf[i2 + 3] & 0xFF;
                switch (code) {
                    case 442: {
                        this.readBytes(this.stream, streamBuf, ++i2 + 3, 1);
                        if ((streamBuf[i2 + 3] & 0xFFFFFFF1) != 33) continue block7;
                        this.streamType = (byte)3;
                        found = true;
                        continue block7;
                    }
                    case 435: {
                        if (i2 == 0) {
                            this.streamType = (byte)2;
                            found = true;
                        }
                    }
                    case 256: 
                    case 440: {
                        ++videoCount;
                        break;
                    }
                    default: {
                        if ((code & 0xFFF80000) != -524288 || (code & 0x60000) == 0) break;
                        ++audioCount;
                        if (i2 != 0) break;
                        this.streamType = 1;
                        found = true;
                    }
                }
                this.readBytes(this.stream, streamBuf, ++i2 + 3, 1);
            }
        }
        catch (IOException e2) {
            if (this.streamType == 0) {
                if (videoCount > 0) {
                    this.streamType = (byte)2;
                } else if (audioCount > 0) {
                    this.streamType = 1;
                }
            }
            this.updateEOMState();
            this.EOMflag = true;
            throw e2;
        }
        if (this.streamType == 0) {
            if (videoCount > 4) {
                this.streamType = (byte)2;
            } else if (audioCount > 20) {
                this.streamType = 1;
            }
        }
        return i2 + 4;
    }

    private void initTrackAudioVideoOnly() throws IOException, BadHeaderException, BadDataException {
        int possibleLen;
        int itmp = 0;
        this.numTracks = 1;
        this.tracks = new Track[1];
        this.trackList[0] = new TrackList();
        int n2 = possibleLen = this.streamType == 1 ? 100000 : 200000;
        if (this.initTmpBufLen < possibleLen) {
            if (possibleLen > this.initTmpStreamBuf.length) {
                byte[] tmpBuf2 = new byte[possibleLen];
                System.arraycopy(this.initTmpStreamBuf, 0, tmpBuf2, 0, this.initTmpBufLen);
                this.initTmpStreamBuf = tmpBuf2;
            }
            try {
                itmp = this.readBytes(this.stream, this.initTmpStreamBuf, this.initTmpBufLen, possibleLen - this.initTmpBufLen);
            }
            catch (IOException iOException) {
                this.updateEOMState();
                this.EOMflag = true;
            }
            this.initTmpBufLen += itmp;
        }
        TrackList trackInfo = this.trackList[0];
        do {
            this.extractStreamInfo(this.initTmpStreamBuf, 0, this.initTmpBufLen, true);
            if (trackInfo.infoFlag) break;
            try {
                itmp = this.readBytes(this.stream, this.initTmpStreamBuf, possibleLen);
            }
            catch (IOException iOException) {
                this.updateEOMState();
                this.EOMflag = true;
                break;
            }
            this.initTmpBufLen = itmp;
        } while (!trackInfo.infoFlag);
        if (!trackInfo.infoFlag) {
            this.numTracks = 0;
            this.tracks = null;
            throw new BadHeaderException("Sorry, No tracks found");
        }
        ((Seekable)((Object)this.stream)).seek(0L);
        this.initTmpBufLen = 0;
        this.EOMflag = false;
    }

    private void initTrackSystemStream() throws IOException, BadHeaderException, BadDataException {
        int v;
        TrackList trackInfo;
        this.tracks = new Track[MAX_TRACKS_SUPPORTED];
        int i2 = 0;
        while (i2 < this.tracks.length) {
            this.tracks[i2] = null;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.trackList.length) {
            this.trackList[i2] = null;
            ++i2;
        }
        this.mpegSystemParseBitstream(false, 0L, -3333333L);
        if (this.numTracks == 0) {
            throw new BadHeaderException("Sorry, No tracks found");
        }
        Track[] tmpTracks = new Track[this.numTracks];
        i2 = 0;
        while (i2 < this.numTracks) {
            tmpTracks[i2] = this.tracks[i2];
            ++i2;
        }
        this.tracks = tmpTracks;
        if (this.hideAudioTracks) {
            i2 = 0;
            while (i2 < this.numTracks) {
                if (this.tracks[i2] != null) {
                    trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                    if (trackInfo.trackType == 2) {
                        ++this.videoCount;
                    }
                }
                ++i2;
            }
            if (this.videoCount == 0) {
                throw new BadHeaderException("Sorry, No video tracks found");
            }
            this.videoTracks = new Track[this.videoCount];
            i2 = 0;
            v = 0;
            while (i2 < this.numTracks) {
                if (this.tracks[i2] != null) {
                    trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                    if (trackInfo.trackType == 2) {
                        this.videoTracks[v] = this.tracks[i2];
                    }
                }
                ++i2;
            }
        }
        if (this.hideVideoTracks) {
            i2 = 0;
            while (i2 < this.numTracks) {
                if (this.tracks[i2] != null) {
                    trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                    if (trackInfo.trackType == 1) {
                        ++this.audioCount;
                    }
                }
                ++i2;
            }
            if (this.audioCount == 0) {
                throw new BadHeaderException("Sorry, No video tracks found");
            }
            this.audioTracks = new Track[this.audioCount];
            i2 = 0;
            v = 0;
            while (i2 < this.numTracks) {
                if (this.tracks[i2] != null) {
                    trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                    if (trackInfo.trackType == 1) {
                        this.audioTracks[v] = this.tracks[i2];
                    }
                }
                ++i2;
            }
        }
    }

    public String getName() {
        return "Parser for MPEG-1 file format";
    }

    private long convPTStoNanoseconds(long val) {
        return val * 100000L / 9L;
    }

    private long convNanosecondsToPTS(long val) {
        return val * 9L / 100000L;
    }

    private long convBytesToTimeAV(long bytes) {
        long time;
        if (this.streamType == 1) {
            if (((Audio)this.trackList[0].media).bitRate == 0) {
                time = 0L;
            } else {
                time = (bytes << 3) / (long)((Audio)this.trackList[0].media).bitRate;
                time *= 1000000L;
            }
        } else if (((Video)this.trackList[0].media).bitRate == 0) {
            time = 0L;
        } else {
            time = (bytes << 3) / (long)((Video)this.trackList[0].media).bitRate;
            time *= 1000000000L;
        }
        return time;
    }

    private long convTimeToBytesAV(long time) {
        long bytes;
        if (this.streamType == 1) {
            bytes = (time >> 3) * (long)((Audio)this.trackList[0].media).bitRate;
            bytes /= 1000000L;
        } else {
            bytes = (time >> 3) * (long)((Video)this.trackList[0].media).bitRate;
            bytes /= 1000000000L;
        }
        return bytes;
    }

    public Time getDuration() {
        if (this.durationInitialized) {
            return this.durationNs;
        }
        if (this.EOMflag) {
            this.durationInitialized = true;
        }
        return this.durationNs;
    }

    private void initDuration() {
        if (this.streamContentLength != -1L) {
            if (this.streamType == 3) {
                if (this.randomAccessStreamFlag) {
                    this.initDurationSystemSeekableRA();
                }
            } else {
                this.updateDurationAudioVideoOnly();
            }
        }
    }

    private void updateDurationAudioVideoOnly() {
        this.AVstartTimeNs = 0L;
        this.AVcurrentTimeNs = 0L;
        this.AVlastTimeNs = this.convBytesToTimeAV(this.streamContentLength);
        this.durationNs = new Time(this.AVlastTimeNs - this.AVstartTimeNs);
        this.durationInitialized = true;
    }

    private void initDurationSystemSeekableRA() {
        long ltmp;
        long baseLocation = 0L;
        int saveNumPackets = this.numPackets;
        boolean saveEOMflag = this.EOMflag;
        baseLocation = ((Seekable)((Object)this.stream)).tell();
        if (this.startPTS == -3333333L) {
            this.EOMflag = false;
            ((Seekable)((Object)this.stream)).seek(0L);
            try {
                this.mpegSystemParseBitstream(true, 65536L, -3333333L);
            }
            catch (Exception exception) {}
        }
        if (this.startPTS == -3333333L) {
            this.startPTS = 0L;
        }
        if (this.endPTS == -3333333L) {
            this.EOMflag = false;
            this.currentPTS = -3333333L;
            ltmp = this.streamContentLength - 131072L;
            if (ltmp < 0L) {
                ltmp = 0L;
            }
            ((Seekable)((Object)this.stream)).seek(ltmp);
            try {
                this.mpegSystemParseBitstream(true, 131072L, -3333333L);
            }
            catch (Exception exception) {}
            this.endPTS = this.currentPTS;
        }
        if (this.endPTS == -3333333L) {
            this.endPTS = this.startPTS;
        }
        if ((ltmp = this.endPTS - this.startPTS) < 0L) {
            ltmp = 0L;
            this.parserErrorFlag = true;
        }
        this.durationNs = new Time(this.convPTStoNanoseconds(ltmp));
        this.lastSetPositionTimeNs = this.convPTStoNanoseconds(this.startPTS);
        ((Seekable)((Object)this.stream)).seek(baseLocation);
        this.EOMflag = saveEOMflag;
        this.numPackets = saveNumPackets;
        this.durationInitialized = true;
    }

    private void updateEOMState() {
        if (!this.durationInitialized) {
            if (this.streamContentLength == -1L) {
                this.streamContentLength = this.getLocation(this.stream);
            }
            if (this.streamType == 3) {
                long ltmp;
                if (this.startPTS == -3333333L) {
                    this.startPTS = 0L;
                }
                if (this.endPTS == -3333333L) {
                    this.endPTS = this.currentPTS;
                }
                if (this.endPTS == -3333333L) {
                    this.endPTS = this.startPTS;
                }
                if ((ltmp = this.endPTS - this.startPTS) < 0L) {
                    ltmp = 0L;
                    this.parserErrorFlag = true;
                }
                this.durationNs = new Time(this.convPTStoNanoseconds(ltmp));
                this.durationInitialized = true;
            } else {
                this.updateDurationAudioVideoOnly();
            }
        }
    }

    public Time getMediaTime() {
        Time mtime;
        if (this.streamType == 3) {
            mtime = this.currentPTS == -3333333L ? new Time(0L) : new Time(this.convPTStoNanoseconds(this.currentPTS - this.startPTS));
        } else {
            this.AVcurrentTimeNs = this.convBytesToTimeAV(this.getLocation(this.stream));
            mtime = new Time(this.AVcurrentTimeNs);
        }
        return mtime;
    }

    public Time setPosition(Time where, int rounding) {
        Time newTime = null;
        if (!this.durationInitialized || this.durationNs == Duration.DURATION_UNKNOWN) {
            return new Time(0L);
        }
        Time preWhere = new Time(where.getNanoseconds() - 500000000L);
        if (this.streamType == 3) {
            Object object = this.buffersSync;
            synchronized (object) {
                long preWherePTS = this.convNanosecondsToPTS(preWhere.getNanoseconds());
                long wherePTS = this.convNanosecondsToPTS(where.getNanoseconds());
                long newPTS = this.setPositionSystemSeekableRA(preWherePTS += this.startPTS, wherePTS += this.startPTS);
                newTime = new Time(this.convPTStoNanoseconds(newPTS));
                this.lastSetPositionTimeNs = this.convPTStoNanoseconds(newPTS);
                this.flushInnerBuffers();
                this.EOMflag = false;
                this.parserErrorFlag = false;
            }
            if (this.mpThread != null) {
                this.mpThread.start();
            }
        } else {
            long newTimeNs;
            this.lastSetPositionTimeNs = newTimeNs = this.setPositionAudioVideoOnly(preWhere.getNanoseconds(), where.getNanoseconds());
            newTime = new Time(newTimeNs);
            this.EOMflag = false;
            this.parserErrorFlag = false;
        }
        return newTime;
    }

    private long setPositionAudioVideoOnly(long where, long origWhere) {
        long newTime;
        if ((float)origWhere <= (float)this.AVstartTimeNs + 5.0E8f) {
            newTime = this.AVstartTimeNs;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)origWhere >= (float)this.AVlastTimeNs - 5.0E8f) {
            newTime = this.AVlastTimeNs - this.AVstartTimeNs;
            ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
        } else {
            newTime = where;
            long pos = this.convTimeToBytesAV(where);
            ((Seekable)((Object)this.stream)).seek(pos);
        }
        return newTime;
    }

    private long setPositionSystemSeekableRA(long wherePTS, long origWherePTS) {
        long newTime = -3333333L;
        long lres = -1L;
        long saveStartPTS = this.startPTS;
        boolean saveEOMflag = this.EOMflag;
        boolean zeroPosFlag = false;
        if (this.endPTS == -3333333L || this.startPTS == -3333333L) {
            newTime = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)origWherePTS <= (float)this.startPTS + 45000.0f) {
            newTime = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)origWherePTS >= (float)this.endPTS - 45000.0f) {
            newTime = this.endPTS - this.startPTS;
            ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
        } else if ((float)(this.endPTS - this.startPTS) < 45000.0f) {
            newTime = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else {
            long pos = (long)((float)this.streamContentLength * ((float)(wherePTS - this.startPTS) / (float)(this.endPTS - this.startPTS)));
            long step = 20480L;
            if ((pos -= step) < 0L) {
                pos = 0L;
            }
            long range = this.streamContentLength - pos;
            while (true) {
                ((Seekable)((Object)this.stream)).seek(pos);
                this.currentPTS = -3333333L;
                this.startPTS = -3333333L;
                this.EOMflag = false;
                try {
                    lres = this.mpegSystemParseBitstream(true, range, wherePTS);
                }
                catch (IOException iOException) {
                    lres = -2L;
                    saveEOMflag = true;
                }
                catch (Exception exception) {
                    lres = -1L;
                }
                if (lres >= 0L) {
                    newTime = this.currentPTS - saveStartPTS;
                    ((Seekable)((Object)this.stream)).seek(lres);
                    break;
                }
                if (lres == -2L) {
                    newTime = this.endPTS - saveStartPTS;
                    ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
                    break;
                }
                if ((pos -= step) <= 0L) {
                    if (zeroPosFlag) {
                        newTime = 0L;
                        ((Seekable)((Object)this.stream)).seek(0L);
                        break;
                    }
                    pos = 0L;
                    zeroPosFlag = true;
                }
                range = 3L * step;
            }
            this.startPTS = saveStartPTS;
            this.EOMflag = saveEOMflag;
        }
        return newTime;
    }

    private long mpegSystemParseBitstream(boolean justLooking, long range, long newPTS) throws IOException, BadHeaderException, BadDataException {
        long baseLocation;
        byte[] buf1 = new byte[1];
        int code = 0;
        boolean read4 = true;
        boolean packFound = false;
        long lastPacketLocation = baseLocation = this.getLocation(this.stream);
        long lastLastPacketLocation = baseLocation;
        long loc = baseLocation + 4L;
        long lastCurrentPTS = -3333333L;
        long savePTS = -3333333L;
        block5: while (!this.EOMflag || justLooking) {
            if (!justLooking && !this.isThereEnoughInnerBuffersSpace()) break;
            if (justLooking) {
                if (this.getLocation(this.stream) - baseLocation > range) break;
                if (newPTS != -3333333L) {
                    if (newPTS < this.startPTS) {
                        return -1L;
                    }
                    if (newPTS <= this.currentPTS) {
                        if (newPTS == this.currentPTS) {
                            return lastPacketLocation;
                        }
                        this.currentPTS = lastCurrentPTS;
                        return lastLastPacketLocation;
                    }
                }
            }
            if (read4) {
                code = this.readInt(this.stream, true);
            } else {
                this.readBytes(this.stream, buf1, 1);
                code = code << 8 & 0xFFFFFF00 | buf1[0] & 0xFF;
            }
            switch (code) {
                case 442: {
                    this.parsePackHeader();
                    read4 = true;
                    packFound = true;
                    break;
                }
                case 443: {
                    this.parseSystemHeader();
                    read4 = true;
                    break;
                }
                case 441: {
                    this.EOMflag = true;
                    if (this.endPTS == -3333333L) {
                        this.endPTS = this.currentPTS;
                    }
                    if (justLooking && newPTS == -3333333L) continue block5;
                    this.updateEOMState();
                    break;
                }
                default: {
                    if (code >> 8 == 1 && (!justLooking || packFound & justLooking)) {
                        if (justLooking && newPTS != -3333333L) {
                            loc = this.getLocation(this.stream);
                            savePTS = this.currentPTS;
                        }
                        byte bval = (byte)(code & 0xFF);
                        this.parsePacket(bval, justLooking);
                        read4 = true;
                        if (!justLooking || newPTS == -3333333L || savePTS == this.currentPTS) continue block5;
                        lastCurrentPTS = savePTS;
                        lastLastPacketLocation = lastPacketLocation;
                        lastPacketLocation = loc - 4L;
                        break;
                    }
                    read4 = false;
                    break;
                }
            }
        }
        return this.EOMflag ? -2L : -1L;
    }

    private void parsePackHeader() throws IOException, BadDataException {
        byte[] buf1 = new byte[1];
        this.readBytes(this.stream, buf1, 1);
        if ((buf1[0] & 0xFFFFFFF0) != 32) {
            throw new BadDataException("invalid pack header");
        }
        if ((buf1[0] & 1) != 1) {
            throw new BadDataException("illegal marker bit");
        }
        this.skip(this.stream, 7);
    }

    private void parseSystemHeader() throws IOException, BadHeaderException {
        byte[] buf1 = new byte[1];
        int len = this.readShort(this.stream, true);
        if (this.sysHeaderSeen) {
            this.skip(this.stream, len);
        } else {
            this.sysHeader.resetSystemHeader();
            this.sysHeader.headerLen = len;
            int itmp = this.readInt(this.stream, true);
            len -= 4;
            if ((itmp & 0x80000100) != -2147483392) {
                throw new BadHeaderException("illegal marker bits in system header");
            }
            this.sysHeader.rateBound = (itmp & 0x7FFFFE00) >> 9;
            this.sysHeader.audioBound = (itmp & 0xFC) >> 2;
            this.sysHeader.fixedFlag = (itmp & 2) >> 1;
            this.sysHeader.CSPSFlag = itmp & 1;
            this.readBytes(this.stream, buf1, 1);
            byte bval = buf1[0];
            --len;
            if ((bval & 0x20) != 32) {
                throw new BadHeaderException("illegal marker bits in system header");
            }
            this.sysHeader.audioLockFlag = (bval & 0x80) >> 7;
            this.sysHeader.videoLockFlag = (bval & 0x40) >> 6;
            this.sysHeader.videoBound = bval & 0x1F;
            this.readBytes(this.stream, buf1, 1);
            --len;
            this.sysHeader.reserved = buf1[0];
            while (len > 1) {
                int i2;
                int size;
                short stmp;
                this.readBytes(this.stream, buf1, 1);
                bval = buf1[0];
                --len;
                if ((bval & 0xFFFFFF80) != -128) break;
                if (bval == -72) {
                    stmp = this.readShort(this.stream, true);
                    len -= 2;
                    if ((stmp & 0xC000) != 49152) {
                        throw new BadHeaderException("illegal marker bits in system header");
                    }
                    size = stmp & 0x1FFF;
                    this.sysHeader.allAudioSTDFlag = true;
                    i2 = 0;
                    while (i2 <= 31) {
                        this.sysHeader.STDBufBoundScale[i2] = 0;
                        this.sysHeader.STDBufSizeBound[i2] = size;
                        ++i2;
                    }
                    continue;
                }
                if (bval == -71) {
                    stmp = this.readShort(this.stream, true);
                    len -= 2;
                    if ((stmp & 0xC000) != 49152) {
                        throw new BadHeaderException("illegal marker bits in system header");
                    }
                    size = stmp & 0x1FFF;
                    this.sysHeader.allVideoSTDFlag = true;
                    i2 = 32;
                    while (i2 <= 47) {
                        this.sysHeader.STDBufBoundScale[i2] = 1;
                        this.sysHeader.STDBufSizeBound[i2] = size;
                        ++i2;
                    }
                    continue;
                }
                if ((bval & 0xFF) < 188 || (bval & 0xFF) > 255) {
                    throw new BadHeaderException("illegal track number in system header");
                }
                int streamID = this.getStreamID(bval);
                if (streamID < 0 || streamID >= 48) continue;
                stmp = this.readShort(this.stream, true);
                len -= 2;
                if ((stmp & 0xC000) != 49152) {
                    throw new BadHeaderException("illegal marker bits in system header");
                }
                int scale = (stmp & 0x2000) >> 13;
                size = stmp & 0x1FFF;
                this.sysHeader.streamFlags[streamID] = true;
                this.sysHeader.STDBufBoundScale[streamID] = scale;
                this.sysHeader.STDBufSizeBound[streamID] = size;
            }
            if (len < 0) {
                throw new BadHeaderException("illegal system header");
            }
            if (len > 0) {
                this.skip(this.stream, len);
            }
            this.sysHeaderSeen = true;
        }
    }

    private void parsePacket(byte bval, boolean justLooking) throws IOException, BadDataException {
        int count = 0;
        int STDBufSize = 0;
        int STDBufScale = 0;
        int numWrittenToTmpBuf = 0;
        byte[] tmpBuf = null;
        byte[] buf1 = new byte[1];
        if ((bval & 0xFF) < 188 || (bval & 0xFF) > 255) {
            throw new BadDataException("invalid stream(track) number");
        }
        int streamID = this.getStreamID(bval);
        short packetLen = this.readShort(this.stream, true);
        buf1[0] = bval;
        if ((buf1[0] & 0xFF) != 191) {
            do {
                this.readBytes(this.stream, buf1, 1);
                ++count;
            } while (buf1[0] == -1);
            if ((buf1[0] & 0xFFFFFFC0) == 64) {
                STDBufScale = (buf1[0] & 0x20) >> 5;
                STDBufSize = (buf1[0] & 0x1F) << 8;
                this.readBytes(this.stream, buf1, 1);
                STDBufSize |= buf1[0];
                this.readBytes(this.stream, buf1, 1);
                count += 2;
            }
            if ((buf1[0] & 0xFFFFFFE0) == 32) {
                long pts = (long)(buf1[0] & 0xE) << 29;
                pts = pts << 31 >> 31;
                if ((buf1[0] & 1) != 1) {
                    throw new BadDataException("illegal marker bit");
                }
                int itmp = this.readInt(this.stream, true);
                count += 4;
                if ((itmp & 0x10001) != 65537) {
                    throw new BadDataException("illegal marker bit");
                }
                int itmp2 = (itmp & 0xFFFE0000) >> 2;
                pts |= (long)(itmp2 & 0x3FFFFFFF);
                this.currentPTS = pts |= (long)((itmp & 0xFFFE) >> 1);
                if (this.startPTS == -3333333L) {
                    this.startPTS = this.currentPTS;
                    if (this.startPTS > 0L && (float)this.startPTS <= 45000.0f) {
                        this.startPTS = 0L;
                    }
                }
                if ((buf1[0] & 0xFFFFFFF0) == 48) {
                    this.skip(this.stream, 5);
                    count += 5;
                }
            } else if (buf1[0] != 15) {
                throw new BadDataException("invalid packet");
            }
        }
        int dataSize = packetLen - count;
        if (justLooking) {
            this.skip(this.stream, dataSize);
            return;
        }
        if (streamID < 0 || streamID >= 48) {
            this.skip(this.stream, dataSize);
        } else {
            if (this.trackList[streamID] == null) {
                this.trackList[streamID] = new TrackList();
            }
            TrackList trackInfo = this.trackList[streamID];
            if (!trackInfo.infoFlag) {
                tmpBuf = new byte[dataSize];
                numWrittenToTmpBuf = this.extractStreamInfo(tmpBuf, streamID, dataSize, false);
            }
            if (!trackInfo.infoFlag) {
                this.trackList[streamID] = null;
                if (numWrittenToTmpBuf < dataSize) {
                    this.skip(this.stream, dataSize - numWrittenToTmpBuf);
                }
            } else {
                if (this.startPTS == -3333333L) {
                    trackInfo.startPTS = this.currentPTS;
                }
                if (trackInfo.emptyBufSpace() < dataSize) {
                    trackInfo.enlargeBuffer(dataSize);
                }
                if (numWrittenToTmpBuf > 0) {
                    trackInfo.copyTmpBufferToInnerBuffer(tmpBuf, numWrittenToTmpBuf);
                }
                trackInfo.copyStreamDataToInnerBuffer(dataSize - numWrittenToTmpBuf);
                ++trackInfo.numPackets;
                if (dataSize > trackInfo.maxPacketSize) {
                    trackInfo.maxPacketSize = dataSize;
                }
            }
        }
        ++this.numPackets;
    }

    private int extractStreamInfo(byte[] tmpBuf, int streamID, int dataLen, boolean AVOnlyState) throws IOException, BadDataException {
        int stype = 0;
        TrackList trackInfo = this.trackList[streamID];
        if (trackInfo.trackType == 0) {
            stype = AVOnlyState ? this.streamType : (streamID < 32 ? 1 : 2);
            trackInfo.init((byte)stype);
            this.sysHeader.streamFlags[streamID] = true;
            trackInfo.startPTS = this.currentPTS;
        }
        int numBytes = stype == 1 ? this.extractAudioInfo(tmpBuf, trackInfo, dataLen, AVOnlyState) : this.extractVideoInfo(tmpBuf, trackInfo, dataLen, AVOnlyState);
        if (trackInfo.infoFlag) {
            if (AVOnlyState) {
                this.tracks[0] = new MediaTrack(trackInfo);
            } else {
                this.tracks[this.numTracks] = new MediaTrack(trackInfo);
                ++this.numTracks;
            }
        }
        return numBytes;
    }

    private int extractAudioInfo(byte[] tmpBuf, TrackList trackInfo, int dataLen, boolean AVOnlyState) throws IOException, BadDataException {
        Audio audio = new Audio();
        int[] samplingFrequencyTable = new int[]{44100, 48000, 32000};
        short[] sArray = new short[15];
        sArray[1] = 32;
        sArray[2] = 48;
        sArray[3] = 56;
        sArray[4] = 64;
        sArray[5] = 80;
        sArray[6] = 96;
        sArray[7] = 112;
        sArray[8] = 128;
        sArray[9] = 160;
        sArray[10] = 192;
        sArray[11] = 224;
        sArray[12] = 256;
        sArray[13] = 320;
        sArray[14] = 384;
        short[] bitrateIndexTableL2 = sArray;
        short[] sArray2 = new short[15];
        sArray2[1] = 8;
        sArray2[2] = 16;
        sArray2[3] = 24;
        sArray2[4] = 32;
        sArray2[5] = 40;
        sArray2[6] = 48;
        sArray2[7] = 56;
        sArray2[8] = 64;
        sArray2[9] = 80;
        sArray2[10] = 96;
        sArray2[11] = 112;
        sArray2[12] = 128;
        sArray2[13] = 144;
        sArray2[14] = 160;
        short[] bitrateIndexTableL23Ext = sArray2;
        int numBytes = AVOnlyState ? dataLen : this.readBytes(this.stream, tmpBuf, dataLen);
        int i2 = 0;
        while (i2 < numBytes - 3) {
            if (tmpBuf[i2] == -1 && (tmpBuf[i2 + 1] & 0xFFFFFFF0) == -16) {
                audio.ID = (tmpBuf[i2 + 1] & 8) >> 3;
                audio.layer = 4 - ((tmpBuf[i2 + 1] & 6) >> 1);
                audio.protection = tmpBuf[i2 + 1] & 1;
                int br = (tmpBuf[i2 + 2] & 0xF0) >> 4;
                int sr = (tmpBuf[i2 + 2] & 0xC) >> 2;
                if (sr < 0 || sr >= samplingFrequencyTable.length) {
                    throw new BadDataException("Non Standard sample rates not supported");
                }
                audio.mode = (tmpBuf[i2 + 3] & 0xC0) >> 6;
                audio.modeExt = (tmpBuf[i2 + 3] & 0x30) >> 4;
                audio.channels = audio.mode == 3 ? 1 : 2;
                audio.copyright = (tmpBuf[i2 + 3] & 8) >> 3;
                audio.original = (tmpBuf[i2 + 3] & 4) >> 2;
                audio.emphasis = tmpBuf[i2 + 3] & 3;
                boolean bl = audio.valid = br != 15;
                if (audio.ID == 1) {
                    audio.sampleRate = samplingFrequencyTable[sr];
                    audio.bitRate = audio.layer == 3 ? (br < 2 ? bitrateIndexTableL2[br] : (br == 2 ? 40 : bitrateIndexTableL2[br - 1])) : (audio.layer == 2 ? bitrateIndexTableL2[br] : br << 5);
                } else {
                    audio.sampleRate = samplingFrequencyTable[sr] >> 1;
                    audio.bitRate = audio.layer == 3 || audio.layer == 2 ? bitrateIndexTableL23Ext[br] : (br < 9 ? bitrateIndexTableL2[br] : (br == 9 ? 144 : (br == 10 ? bitrateIndexTableL2[br - 1] : (br == 11 ? 176 : bitrateIndexTableL2[br - 2]))));
                }
                trackInfo.readFrameSize = audio.bitRate * 1000 >> 3;
                trackInfo.infoFlag = true;
                trackInfo.media = audio;
                break;
            }
            ++i2;
        }
        return numBytes;
    }

    private int extractVideoInfo(byte[] tmpBuf, TrackList trackInfo, int dataLen, boolean AVOnlyState) throws IOException, BadDataException {
        Video video = new Video();
        float[] fArray = new float[16];
        fArray[1] = 1.0f;
        fArray[2] = 0.6735f;
        fArray[3] = 0.7031f;
        fArray[4] = 0.7615f;
        fArray[5] = 0.8055f;
        fArray[6] = 0.8437f;
        fArray[7] = 0.8935f;
        fArray[8] = 0.9375f;
        fArray[9] = 0.9815f;
        fArray[10] = 1.0255f;
        fArray[11] = 1.0695f;
        fArray[12] = 1.125f;
        fArray[13] = 1.1575f;
        fArray[14] = 1.2015f;
        fArray[15] = 1.0f;
        float[] aspectRatioTable = fArray;
        float[] fArray2 = new float[16];
        fArray2[1] = 23.976f;
        fArray2[2] = 24.0f;
        fArray2[3] = 25.0f;
        fArray2[4] = 29.97f;
        fArray2[5] = 30.0f;
        fArray2[6] = 50.0f;
        fArray2[7] = 59.94f;
        fArray2[8] = 60.0f;
        fArray2[9] = -1.0f;
        fArray2[10] = -1.0f;
        fArray2[11] = -1.0f;
        fArray2[12] = -1.0f;
        fArray2[13] = -1.0f;
        fArray2[14] = -1.0f;
        fArray2[15] = -1.0f;
        float[] pictureRateTable = fArray2;
        int numBytes = AVOnlyState ? dataLen : this.readBytes(this.stream, tmpBuf, dataLen);
        int i2 = 0;
        while (i2 < numBytes - 10) {
            int code = tmpBuf[i2] << 24 & 0xFF000000 | tmpBuf[i2 + 1] << 16 & 0xFF0000 | tmpBuf[i2 + 2] << 8 & 0xFF00 | tmpBuf[i2 + 3] & 0xFF;
            if (code == 435) {
                video.width = (tmpBuf[i2 + 4] & 0xFF) << 4;
                video.width |= tmpBuf[i2 + 4 + 1] >> 4 & 0xF;
                video.height = (tmpBuf[i2 + 4 + 1] & 0xF) << 8;
                video.height |= tmpBuf[i2 + 4 + 2] & 0xFF;
                int pr = (tmpBuf[i2 + 4 + 3] & 0xF0) >> 4;
                video.pelAspectRatio = aspectRatioTable[pr];
                pr = tmpBuf[i2 + 4 + 3] & 0xF;
                video.pictureRate = pictureRateTable[pr];
                pr = (tmpBuf[i2 + 4 + 4] & 0xFF) << 10 | (tmpBuf[i2 + 4 + 5] & 0xFF) << 2 | (tmpBuf[i2 + 4 + 6] & 0xC0) >> 6;
                video.bitRate = pr * 400;
                if ((double)video.pelAspectRatio == 0.0 || (double)video.pictureRate == 0.0) {
                    throw new BadDataException("video header corrupted");
                }
                if ((double)video.pictureRate < 23.0) {
                    trackInfo.readFrameSize = 65536;
                } else {
                    trackInfo.readFrameSize = video.bitRate >> 3;
                    if (trackInfo.readFrameSize > 100000) {
                        trackInfo.readFrameSize = 100000;
                    }
                }
                trackInfo.infoFlag = true;
                trackInfo.media = video;
                break;
            }
            ++i2;
        }
        return numBytes;
    }

    private int getStreamID(byte bval) {
        return (bval & 0xFF) - 192;
    }

    private long getLocation() {
        return this.getLocation(this.stream);
    }

    boolean isThereEnoughInnerBuffersSpace() {
        int i2 = 0;
        while (i2 < this.numTracks) {
            TrackList trackInfo;
            if (this.tracks[i2] != null && (trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo()).emptyBufSpace() < 2 * trackInfo.maxPacketSize) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    void flushInnerBuffers() {
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.tracks[i2] != null) {
                TrackList trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                trackInfo.flushBuffer();
            }
            ++i2;
        }
    }

    void saveInnerBuffersToFiles() {
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.tracks[i2] != null) {
                TrackList trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                trackInfo.saveBufToFile();
            }
            ++i2;
        }
    }

    void throwInnerBuffersContents() {
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.tracks[i2] != null) {
                TrackList trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                trackInfo.resetBuf();
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static /* synthetic */ byte access$0() {
        return 0;
    }

    static /* synthetic */ long access$1() {
        return -3333333L;
    }

    static /* synthetic */ byte access$3() {
        return 3;
    }

    static /* synthetic */ byte access$4() {
        return 1;
    }

    static /* synthetic */ byte access$5() {
        return 2;
    }

    static /* synthetic */ int access$6() {
        return 200000;
    }

    static /* synthetic */ int access$7() {
        return 100000;
    }

    static /* synthetic */ int access$29() {
        return 48;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    private abstract class Media {
        abstract Format createFormat();

        Media() {
            MpegParser.this = MpegParser.this;
        }
    }

    private class Audio
    extends Media {
        boolean valid = false;
        int ID;
        int layer;
        int protection;
        int bitRate;
        int sampleRate;
        int mode;
        int modeExt;
        int copyright;
        int original;
        int emphasis;
        int channels;
        AudioFormat format;

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            String encodingString = this.layer == 3 ? "mpeglayer3" : "mpegaudio";
            int bitsPerSample = 16;
            int frameSizeInBits = (this.layer == 1 ? 352 : 1024) * this.channels * bitsPerSample;
            int bytesPerSecond = this.bitRate * 1000 >> 3;
            this.format = new WavAudioFormat(encodingString, this.sampleRate, bitsPerSample, this.channels, frameSizeInBits, bytesPerSecond, 0, 1, -1.0f, array$B != null ? array$B : (array$B = MpegParser.class$("[B")), null);
            return this.format;
        }

        public String toString() {
            System.out.println("Audio Media: " + this.format);
            System.out.println("Number of channels " + this.channels);
            System.out.println("valid " + this.valid);
            System.out.println("ID " + this.ID);
            System.out.println("layer " + this.layer);
            System.out.println("protection " + this.protection);
            System.out.println("bitrate " + this.bitRate);
            System.out.println("sample rate " + this.sampleRate);
            System.out.println("Mode " + this.mode + " ext " + this.modeExt);
            System.out.println("copyright " + this.copyright);
            System.out.println("original " + this.original);
            System.out.println("emphasis " + this.emphasis);
            System.out.println("channels " + this.channels);
            return super.toString();
        }

        Audio() {
            MpegParser.this = MpegParser.this;
        }
    }

    private class Video
    extends Media {
        int width;
        int height;
        float pelAspectRatio;
        float pictureRate;
        int bitRate;
        VideoFormat format;

        Format createFormat() {
            int size = (int)((double)(this.width * this.height) * 1.5);
            if (this.format != null) {
                return this.format;
            }
            this.format = new VideoFormat("mpeg", new Dimension(this.width, this.height), size, array$B != null ? array$B : (array$B = MpegParser.class$("[B")), this.pictureRate);
            return this.format;
        }

        public String toString() {
            System.out.println("Video Media: " + this.format);
            System.out.println("width " + this.width);
            System.out.println("height " + this.height);
            System.out.println("pixel aspect ratio " + this.pelAspectRatio);
            System.out.println("picture rate " + this.pictureRate);
            System.out.println("bitrate " + this.bitRate);
            return super.toString();
        }

        Video() {
            MpegParser.this = MpegParser.this;
        }
    }

    private class TrackList {
        byte trackType = MpegParser.access$0();
        Time duration = Duration.DURATION_UNKNOWN;
        long startPTS = MpegParser.access$1();
        boolean infoFlag = false;
        int numPackets;
        int maxPacketSize;
        int readFrameSize;
        Media media;
        boolean supported = false;
        byte[] buf;
        int readPtr;
        int writePtr;
        int bufLen;
        MpegParser parser = MpegParser.this;

        void init(byte stype) {
            this.supported = true;
            this.trackType = stype;
            if (MpegParser.this.streamType == MpegParser.access$3() && (stype == MpegParser.access$4() || stype == MpegParser.access$5())) {
                this.bufLen = stype == MpegParser.access$4() ? MpegParser.access$7() : MpegParser.access$6();
                this.buf = new byte[this.bufLen];
                this.readPtr = 0;
                this.writePtr = 0;
            }
        }

        int emptyBufSpace() {
            if (this.readPtr <= this.writePtr) {
                return this.bufLen - (this.writePtr - this.readPtr) - 1;
            }
            return this.readPtr - this.writePtr - 1;
        }

        int readyDataBytes() {
            if (this.readPtr <= this.writePtr) {
                return this.writePtr - this.readPtr;
            }
            return this.bufLen - (this.readPtr - this.writePtr);
        }

        void enlargeBuffer(int moreSize) {
            byte[] tmpBuf = new byte[this.bufLen + moreSize];
            int itmp = this.readyDataBytes();
            this.copyFromInnerBuffer(tmpBuf, this.readyDataBytes());
            this.bufLen += moreSize;
            this.readPtr = 0;
            this.writePtr = itmp;
            this.buf = tmpBuf;
        }

        void copyTmpBufferToInnerBuffer(byte[] tmpBuf, int size) {
            int itmp = this.bufLen - this.writePtr;
            if (size > itmp) {
                System.arraycopy(tmpBuf, 0, this.buf, this.writePtr, itmp);
                System.arraycopy(tmpBuf, itmp, this.buf, 0, size - itmp);
                this.writePtr = size - itmp;
            } else {
                System.arraycopy(tmpBuf, 0, this.buf, this.writePtr, size);
                this.writePtr += size;
            }
        }

        void copyStreamDataToInnerBuffer(int size) throws IOException {
            int itmp = this.bufLen - this.writePtr;
            if (size > itmp) {
                this.parser.readBytes(MpegParser.this.stream, this.buf, this.writePtr, itmp);
                this.parser.readBytes(MpegParser.this.stream, this.buf, 0, size - itmp);
                this.writePtr = size - itmp;
            } else {
                this.parser.readBytes(MpegParser.this.stream, this.buf, this.writePtr, size);
                this.writePtr += size;
            }
        }

        void copyFromInnerBuffer(byte[] dstBuf, int size) {
            int itmp = this.bufLen - this.readPtr;
            if (size > itmp) {
                System.arraycopy(this.buf, this.readPtr, dstBuf, 0, itmp);
                System.arraycopy(this.buf, 0, dstBuf, itmp, size - itmp);
                this.readPtr = size - itmp;
            } else {
                System.arraycopy(this.buf, this.readPtr, dstBuf, 0, size);
                this.readPtr += size;
            }
        }

        void flushBuffer() {
            this.readPtr = 0;
            this.writePtr = 0;
        }

        public String toString() {
            System.out.println("track type " + this.trackType + "(0 ?, 1 audio, 2 video)");
            System.out.println("start PTS " + this.startPTS);
            System.out.println("info flag " + this.infoFlag);
            System.out.println("number of packets " + this.numPackets);
            System.out.println("maximum packet size " + this.maxPacketSize);
            System.out.println("supported " + this.supported);
            System.out.println("inner buffer length " + this.bufLen);
            System.out.println("duration (?) " + this.duration);
            return this.media.toString();
        }

        void saveBufToFile() {
            FileOutputStream fout;
            int size = this.readyDataBytes();
            int itmp = this.bufLen - this.readPtr;
            FileOutputStream fileOutputStream = fout = this.trackType == MpegParser.access$4() ? MpegParser.this.aout : MpegParser.this.vout;
            if (size == 0) {
                return;
            }
            try {
                if (size > itmp) {
                    fout.write(this.buf, this.readPtr, itmp);
                    fout.write(this.buf, 0, size - itmp);
                } else {
                    fout.write(this.buf, this.readPtr, size);
                }
                fout.flush();
                this.readPtr = 0;
                this.writePtr = 0;
            }
            catch (IOException iOException) {
                System.out.println("   EE>> problem in writing to files");
            }
        }

        void resetBuf() {
            this.readPtr = 0;
            this.writePtr = 0;
        }

        TrackList() {
            MpegParser.this = MpegParser.this;
        }
    }

    private class MediaTrack
    implements Track {
        private TrackList trackInfo;
        private boolean enabled;
        private long sequenceNumber;
        private Format format;
        private TrackListener listener;
        MpegParser parser;

        MediaTrack(TrackList trackInfo) {
            this.parser = MpegParser.this = MpegParser.this;
            this.trackInfo = trackInfo;
            this.enabled = true;
            this.format = trackInfo.media.createFormat();
        }

        public void setTrackListener(TrackListener l2) {
            this.listener = l2;
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.trackInfo.duration;
        }

        public Time getStartTime() {
            if (MpegParser.this.streamType == MpegParser.access$3()) {
                return new Time((double)MpegParser.this.startPTS / 90000.0);
            }
            return new Time(MpegParser.this.AVstartTimeNs);
        }

        public void readFrame(Buffer buffer) {
            byte[] data;
            if (buffer == null) {
                return;
            }
            if (!this.enabled) {
                buffer.setDiscard(true);
                return;
            }
            buffer.setFormat(this.format);
            int size = this.trackInfo.readFrameSize;
            Object obj = buffer.getData();
            if (obj == null || !(obj instanceof byte[]) || ((byte[])obj).length < size) {
                data = new byte[size];
                buffer.setData(data);
            } else {
                data = (byte[])obj;
            }
            int len = MpegParser.this.streamType == MpegParser.access$3() ? this.systemStreamReadFrame(buffer, data, size) : this.AudioVideoOnlyReadFrame(buffer, data, size);
            if (len > -1) {
                buffer.setLength(len);
                if (this.trackInfo.trackType == MpegParser.access$5()) {
                    buffer.setTimeStamp(MpegParser.this.lastSetPositionTimeNs);
                }
                buffer.setHeader(null);
                buffer.setOffset(0);
                buffer.setSequenceNumber(++this.sequenceNumber);
            }
        }

        private int AudioVideoOnlyReadFrame(Buffer buffer, byte[] data, int size) {
            int counter;
            int read1;
            block10: {
                read1 = 0;
                int read2 = size;
                int actualBytesRead = 0;
                counter = 0;
                if (MpegParser.this.sysPausedFlag || MpegParser.this.parserErrorFlag) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    return -1;
                }
                if (MpegParser.this.initTmpBufLen > 0) {
                    read1 = MpegParser.this.initTmpBufLen > size ? size : MpegParser.this.initTmpBufLen;
                    System.arraycopy(MpegParser.this.initTmpStreamBuf, 0, data, 0, read1);
                    MpegParser mpegParser = MpegParser.this;
                    mpegParser.initTmpBufLen = mpegParser.initTmpBufLen - read1;
                    read2 -= read1;
                    counter = read1;
                }
                if (read2 > 0 && !MpegParser.this.EOMflag) {
                    try {
                        actualBytesRead = this.parser.readBytes(MpegParser.this.stream, data, read1, read2);
                        if (actualBytesRead == -2) {
                            if (read1 == 0) {
                                buffer.setDiscard(true);
                                return -1;
                            }
                        } else {
                            counter += actualBytesRead;
                        }
                    }
                    catch (IOException iOException) {
                        MpegParser.this.updateEOMState();
                        MpegParser.this.EOMflag = true;
                        if (MpegParser.this.AVlastTimeNs != 0L) break block10;
                        MpegParser.this.AVcurrentTimeNs = MpegParser.this.convBytesToTimeAV(MpegParser.this.getLocation());
                        MpegParser.this.AVlastTimeNs = MpegParser.this.AVcurrentTimeNs;
                    }
                }
            }
            if (MpegParser.this.EOMflag) {
                if (read1 > 0) {
                    return read1;
                }
                buffer.setLength(0);
                buffer.setEOM(true);
                return -1;
            }
            return counter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int systemStreamReadFrame(Buffer buffer, byte[] data, int size) {
            Object object = MpegParser.this.buffersSync;
            synchronized (object) {
                int i2;
                TrackList AtrackInfo;
                try {
                    int itmp;
                    while ((itmp = this.trackInfo.readyDataBytes()) < size && !MpegParser.this.sysPausedFlag) {
                        if (MpegParser.this.EOMflag || MpegParser.this.parserErrorFlag) {
                            if (itmp > 0) {
                                size = itmp;
                                break;
                            }
                            buffer.setLength(0);
                            buffer.setEOM(true);
                            return -1;
                        }
                        MpegParser.this.buffersSync.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    buffer.setDiscard(true);
                    return -1;
                }
                if (MpegParser.this.sysPausedFlag) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    return -1;
                }
                this.trackInfo.copyFromInnerBuffer(data, size);
                int i3 = 0;
                while (i3 < MpegParser.this.numTracks) {
                    if (MpegParser.this.tracks[i3] != null && !MpegParser.this.tracks[i3].isEnabled()) {
                        AtrackInfo = ((MediaTrack)MpegParser.this.tracks[i3]).getTrackInfo();
                        AtrackInfo.readPtr = 0;
                        AtrackInfo.writePtr = 0;
                    }
                    ++i3;
                }
                if (MpegParser.this.hideAudioTracks) {
                    i2 = 0;
                    while (i2 < MpegParser.this.numTracks) {
                        if (MpegParser.this.tracks[i2] != null) {
                            AtrackInfo = ((MediaTrack)MpegParser.this.tracks[i2]).getTrackInfo();
                            if (AtrackInfo.trackType == MpegParser.access$4()) {
                                AtrackInfo.readPtr = 0;
                                AtrackInfo.writePtr = 0;
                            }
                        }
                        ++i2;
                    }
                }
                if (MpegParser.this.hideVideoTracks) {
                    i2 = 0;
                    while (i2 < MpegParser.this.numTracks) {
                        if (MpegParser.this.tracks[i2] != null) {
                            AtrackInfo = ((MediaTrack)MpegParser.this.tracks[i2]).getTrackInfo();
                            if (AtrackInfo.trackType == MpegParser.access$5()) {
                                AtrackInfo.readPtr = 0;
                                AtrackInfo.writePtr = 0;
                            }
                        }
                        ++i2;
                    }
                }
                MpegParser.this.buffersSync.notifyAll();
                return size;
            }
        }

        public int mapTimeToFrame(Time t) {
            return 0;
        }

        public Time mapFrameToTime(int frameNumber) {
            return null;
        }

        private TrackList getTrackInfo() {
            return this.trackInfo;
        }
    }

    private class SystemHeader {
        int headerLen;
        int rateBound;
        int audioBound;
        int fixedFlag;
        int CSPSFlag;
        int audioLockFlag;
        int videoLockFlag;
        int videoBound;
        int reserved;
        boolean allAudioSTDFlag = false;
        boolean allVideoSTDFlag = false;
        boolean[] streamFlags = new boolean[MpegParser.access$29()];
        int[] STDBufBoundScale = new int[MpegParser.access$29()];
        int[] STDBufSizeBound = new int[MpegParser.access$29()];

        SystemHeader() {
            MpegParser.this = MpegParser.this;
            int i2 = 0;
            while (i2 < MpegParser.access$29()) {
                this.streamFlags[i2] = false;
                this.STDBufBoundScale[i2] = 0;
                this.STDBufSizeBound[i2] = 0;
                ++i2;
            }
        }

        void resetSystemHeader() {
            this.headerLen = 0;
            this.rateBound = 0;
            this.audioBound = 0;
            this.fixedFlag = 0;
            this.CSPSFlag = 0;
            this.audioLockFlag = 0;
            this.videoLockFlag = 0;
            this.videoBound = 0;
            this.reserved = 0;
            this.allAudioSTDFlag = false;
            this.allVideoSTDFlag = false;
            int i2 = 0;
            while (i2 < MpegParser.access$29()) {
                this.streamFlags[i2] = false;
                this.STDBufBoundScale[i2] = 0;
                this.STDBufSizeBound[i2] = 0;
                ++i2;
            }
        }

        void printFields() {
            System.out.println("headerLen " + this.headerLen);
            System.out.println("rateBound " + this.rateBound);
            System.out.println("audioBound " + this.audioBound);
            System.out.println("fixedFlag " + this.fixedFlag);
            System.out.println("CSPSFlag " + this.CSPSFlag);
            System.out.println("audioLockFlag " + this.audioLockFlag);
            System.out.println("videoLockFlag " + this.videoLockFlag);
            System.out.println("videoBound " + this.videoBound);
            System.out.println("reserved " + this.reserved);
            System.out.println("allAudioSTDFlag " + this.allAudioSTDFlag);
            System.out.println("allVideoSTDFlag " + this.allVideoSTDFlag);
            int i2 = 0;
            while (i2 < MpegParser.access$29()) {
                if (this.streamFlags[i2]) {
                    System.out.println("[" + i2 + "]  STDBufBoundScale " + this.STDBufBoundScale[i2] + "     STDBufSizeBound " + this.STDBufSizeBound[i2]);
                }
                ++i2;
            }
        }
    }

    private class MpegBufferThread
    extends LoopThread {
        MpegBufferThread() {
            MpegParser.this = MpegParser.this;
            this.setName(String.valueOf(this.getName()) + " (MpegBufferThread)");
            this.useAudioPriority();
        }

        public boolean process() {
            while (!MpegParser.this.EOMflag && !MpegParser.this.parserErrorFlag) {
                Object object = MpegParser.this.buffersSync;
                synchronized (object) {
                    block13: {
                        try {
                            boolean alreadyWaitFlag = false;
                            while (!MpegParser.this.isThereEnoughInnerBuffersSpace()) {
                                if (alreadyWaitFlag) {
                                    MpegParser.this.buffersSync.notifyAll();
                                }
                                MpegParser.this.buffersSync.wait(100L);
                                alreadyWaitFlag = true;
                                if (MpegParser.this.saveOutputFlag) {
                                    MpegParser.this.saveInnerBuffersToFiles();
                                }
                                if (!MpegParser.this.throwOutputFlag) continue;
                                MpegParser.this.throwInnerBuffersContents();
                            }
                            MpegParser.this.mpegSystemParseBitstream(false, 0L, MpegParser.access$1());
                            MpegParser.this.buffersSync.notifyAll();
                            if (!MpegParser.this.EOMflag) break block13;
                        }
                        catch (InterruptedException interruptedException) {
                            MpegParser.this.parserErrorFlag = true;
                            MpegParser.this.buffersSync.notifyAll();
                        }
                        catch (BadDataException badDataException) {
                            MpegParser.this.parserErrorFlag = true;
                            MpegParser.this.buffersSync.notifyAll();
                        }
                        catch (BadHeaderException badHeaderException) {
                            MpegParser.this.parserErrorFlag = true;
                            MpegParser.this.buffersSync.notifyAll();
                        }
                        catch (IOException iOException) {
                            MpegParser.this.updateEOMState();
                            MpegParser.this.EOMflag = true;
                            if (MpegParser.this.endPTS == MpegParser.access$1()) {
                                MpegParser.this.endPTS = MpegParser.this.currentPTS;
                            }
                            MpegParser.this.buffersSync.notifyAll();
                        }
                        Object var3_3 = null;
                        break;
                    }
                }
            }
            this.pause();
            return true;
        }
    }

    private class BadDataException
    extends MediaException {
        BadDataException() {
            MpegParser.this = MpegParser.this;
        }

        private BadDataException(String reason) {
            super(reason);
            MpegParser.this = MpegParser.this;
        }
    }
}

