/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.DefaultSecurity;
import com.sun.media.DisabledSecurity;
import com.sun.media.IESecurity;
import com.sun.media.JDK12Security;
import com.sun.media.JMFSecurity;
import com.sun.media.NetscapeSecurity;
import com.sun.media.util.Registry;
import java.util.Date;

public class JMFSecurityManager {
    private static JMFSecurity security;
    private static JMFSecurity enabledSecurity;
    private static SecurityManager securityManager;
    private static int count;
    public static final boolean DEBUG = false;
    private static final String STR_NOPERM = "No permission to capture from applets";
    static /* synthetic */ Class class$com$sun$media$JMFSecurityManager;

    public static JMFSecurity getJMFSecurity() throws SecurityException {
        return security;
    }

    public static boolean isLinkPermissionEnabled() {
        if (security == null) {
            return true;
        }
        return security.isLinkPermissionEnabled();
    }

    public static void loadLibrary(String name) throws UnsatisfiedLinkError {
        try {
            JMFSecurity s = JMFSecurityManager.getJMFSecurity();
            if (s != null) {
                s.loadLibrary(name);
            } else {
                System.loadLibrary(name);
            }
        }
        catch (Throwable t) {
            throw new UnsatisfiedLinkError("JMFSecurityManager: " + t);
        }
    }

    public static synchronized void disableSecurityFeatures() {
        security = DisabledSecurity.security;
        ++count;
    }

    public static synchronized void enableSecurityFeatures() {
        if (--count <= 0) {
            security = enabledSecurity;
        }
    }

    public static void checkCapture() {
        if (security == null) {
            return;
        }
        Object captureFromApplets = Registry.get("secure.allowCaptureFromApplets");
        if (captureFromApplets == null || !(captureFromApplets instanceof Boolean) || !((Boolean)captureFromApplets).booleanValue()) {
            throw new RuntimeException(STR_NOPERM);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        long expireTime;
        security = null;
        enabledSecurity = null;
        Date today = new Date();
        Date expire = new Date(99, 11, 25);
        long currentTime = today.getTime();
        if (currentTime > (expireTime = expire.getTime())) {
            System.err.println("WARNING: jmf2.0 beta license has expired. Please install jmf2.0 FCS");
            security = DisabledSecurity.security;
        } else {
            securityManager = System.getSecurityManager();
            boolean jdk122 = false;
            boolean jdk11 = false;
            boolean msjvm = false;
            try {
                String javaVendor;
                String javaVersion = System.getProperty("java.version");
                if (!javaVersion.equals("")) {
                    if (javaVersion.startsWith("1.1")) {
                        jdk11 = true;
                    } else {
                        char c2 = javaVersion.charAt(0);
                        if (c2 >= '0' && c2 <= '9' && javaVersion.compareTo("1.2") >= 0) {
                            jdk122 = true;
                        }
                    }
                }
                if ((javaVendor = System.getProperty("java.vendor", "Sun").toLowerCase()).indexOf("icrosoft") > 0) {
                    msjvm = true;
                }
            }
            catch (Throwable t) {
                System.out.println(t);
            }
            if (securityManager != null) {
                if (securityManager.toString().indexOf("netscape") != -1) {
                    security = NetscapeSecurity.security;
                } else if (securityManager.toString().indexOf("com.ms.security") != -1 || msjvm) {
                    security = (class$com$sun$media$JMFSecurityManager != null ? class$com$sun$media$JMFSecurityManager : (class$com$sun$media$JMFSecurityManager = JMFSecurityManager.class$("com.sun.media.JMFSecurityManager"))).getClassLoader() == null ? IESecurity.security : DisabledSecurity.security;
                } else if (securityManager.toString().indexOf("sun.applet.AppletSecurity") != -1 || securityManager.toString().indexOf("sun.plugin.ActivatorSecurityManager") != -1) {
                    if (jdk11) {
                        security = DefaultSecurity.security;
                    }
                    if (jdk122) {
                        security = JDK12Security.security;
                    }
                } else if (securityManager.toString().indexOf("java.lang.SecurityManager") != -1) {
                    if (jdk122) {
                        security = JDK12Security.security;
                    }
                } else {
                    security = jdk122 ? JDK12Security.security : DefaultSecurity.security;
                }
            }
            enabledSecurity = security;
        }
    }
}

