/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.codec.video.jpeg.RTPDePacketizer;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.control.QualityControl;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeDecoder
extends BasicCodec {
    private VideoFormat inputFormat;
    private YUVFormat outputFormat;
    private int decimation = -1;
    private static final int DEC422 = 0;
    private static final int DEC420 = 1;
    private static final int DEC444 = 2;
    private static boolean loaded;
    private static boolean canLoad;
    private boolean dropFrame = false;
    private RTPDePacketizer rtpdp;
    private int peer;
    private int quality;
    private Control[] controls;
    private DC dc;

    public NativeDecoder() {
        this.inputFormats = new Format[]{new VideoFormat("jpeg"), new VideoFormat("mjpg"), new VideoFormat("jpeg/rtp")};
        this.outputFormats = new YUVFormat[1];
        this.outputFormats[0] = new YUVFormat();
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (BasicPlugIn.matches(in, this.inputFormats) == null) {
            return new Format[0];
        }
        Format[] out = new Format[]{this.computeOutputFormat(in)};
        return out;
    }

    public Format setInputFormat(Format input) {
        this.inputFormat = (VideoFormat)input;
        if (this.inputFormat.getEncoding().equals("jpeg/rtp")) {
            this.rtpdp = new RTPDePacketizer();
        }
        return input;
    }

    public Format setOutputFormat(Format output) {
        this.outputFormat = (YUVFormat)output;
        return output;
    }

    private final YUVFormat computeOutputFormat(Format in) {
        VideoFormat jpeg = (VideoFormat)in;
        Dimension size = jpeg.getSize();
        int strideY = 0;
        int strideUV = 0;
        int strideHeight = 0;
        int dec = this.decimation;
        if (dec == -1) {
            dec = 1;
        }
        dec = this.decToYUVType(dec);
        if (size != null) {
            strideY = size.width;
            strideHeight = size.height;
        } else {
            size = new Dimension(320, 240);
            strideY = 320;
            strideHeight = 240;
        }
        switch (dec) {
            case 2: {
                strideY = strideY % 16 == 0 ? strideY : (strideY + 16) / 16 * 16;
                strideHeight = strideHeight % 16 == 0 ? strideHeight : (strideHeight + 16) / 16 * 16;
                break;
            }
            case 4: {
                strideY = strideY % 16 == 0 ? strideY : (strideY + 16) / 16 * 16;
                strideHeight = strideHeight % 8 == 0 ? strideHeight : (strideHeight + 8) / 8 * 8;
                break;
            }
            default: {
                strideY = strideY % 8 == 0 ? strideY : (strideY + 8) / 8 * 8;
                strideHeight = strideHeight % 8 == 0 ? strideHeight : (strideHeight + 8) / 8 * 8;
            }
        }
        strideUV = strideY;
        if (dec == 4 || dec == 2) {
            strideUV /= 2;
        }
        int offsetY = 0;
        int offsetU = strideY * strideHeight;
        int offsetV = offsetU + strideUV * strideHeight / (dec == 2 ? 2 : 1);
        int datasize = offsetU + 2 * (offsetV - offsetU);
        YUVFormat yuv = new YUVFormat(size, datasize, Format.byteArray, jpeg.getFrameRate(), dec, strideY, strideUV, offsetY, offsetU, offsetV);
        return yuv;
    }

    private final int decToYUVType(int dec) {
        if (dec == 1) {
            return 2;
        }
        if (dec == 0) {
            return 4;
        }
        if (dec == 2) {
            return 8;
        }
        return 2;
    }

    private final int yuvTypeToDec(int dec) {
        if (dec == 2) {
            return 1;
        }
        if (dec == 4) {
            return 0;
        }
        if (dec == 8) {
            return 2;
        }
        return 1;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native JPEG converter");
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmjpeg");
                loaded = true;
            }
            catch (Throwable throwable) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native JPEG converter");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on JPEG converter");
        }
        if (this.peer != 0) {
            this.close();
        }
        try {
            this.peer = this.initJPEGDecoder();
        }
        catch (Throwable throwable) {}
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize JPEG converter");
        }
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeJPEGDecoder(this.peer);
        }
        this.peer = 0;
    }

    public void reset() {
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        Dimension size;
        int type;
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (inBuffer.isDiscard()) {
            this.updateOutput(outBuffer, this.outputFormat, 0, 0);
            outBuffer.setDiscard(true);
            return 4;
        }
        Format inFormat = inBuffer.getFormat();
        if (inFormat.getEncoding().equals("jpeg/rtp")) {
            int retVal = this.rtpdp.process(inBuffer);
            if (retVal != 0) {
                return retVal;
            }
            type = this.rtpdp.getType();
            this.quality = this.rtpdp.getQuality();
            if (type != this.decimation) {
                this.decimation = type;
                this.outputFormat = this.computeOutputFormat(inBuffer.getFormat());
                outBuffer.setFormat(this.outputFormat);
            }
        } else if (inFormat instanceof JPEGFormat) {
            JPEGFormat jfmt = (JPEGFormat)inFormat;
            type = this.decimation;
            if (jfmt.getDecimation() != -1) {
                type = jfmt.getDecimation();
            }
            if (jfmt.getQFactor() != -1) {
                this.quality = jfmt.getQFactor();
            }
            if (type != this.decimation) {
                this.decimation = type;
                this.outputFormat = this.computeOutputFormat(inBuffer.getFormat());
                outBuffer.setFormat(this.outputFormat);
            }
        }
        Format outFormat = outBuffer.getFormat();
        byte[] inData = (byte[])inBuffer.getData();
        byte[] outData = (byte[])outBuffer.getData();
        if (this.decimation == -1) {
            int length = inBuffer.getLength();
            int[] width = new int[1];
            int[] height = new int[1];
            int[] dec = new int[1];
            this.peekJFIF(inData, length, width, height, dec);
            this.decimation = dec[0];
            this.outputFormat = this.computeOutputFormat(inFormat);
            outBuffer.setFormat(this.outputFormat);
        }
        if (outData == null || outData.length < this.outputFormat.getMaxDataLength()) {
            outData = new byte[this.outputFormat.getMaxDataLength()];
            outBuffer.setData(outData);
        }
        if (this.peer == 0) {
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return 1;
            }
        }
        if ((size = this.inputFormat.getSize()) == null) {
            size = this.outputFormat.getSize();
        }
        int outWidth = size.width;
        if (this.dropFrame && inBuffer.getTimeStamp() != 0L) {
            outBuffer.setDiscard(true);
            outBuffer.setTimeStamp(inBuffer.getTimeStamp());
            return 0;
        }
        int returnVal = this.decodeJPEG(this.peer, this.yuvTypeToDec(this.outputFormat.getYuvType()), this.quality, size.width, size.height, inData, outData, outWidth, size.height, inBuffer.getLength(), 0);
        outBuffer.setLength(returnVal);
        outBuffer.setOffset(0);
        inBuffer.setLength(0);
        outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        return 0;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Decoder";
    }

    private native int initJPEGDecoder();

    private native int decodeJPEG(int var1, int var2, int var3, int var4, int var5, byte[] var6, byte[] var7, int var8, int var9, int var10, int var11);

    private native boolean freeJPEGDecoder(int var1);

    private native boolean peekJFIF(byte[] var1, int var2, int[] var3, int[] var4, int[] var5);

    public Object[] getControls() {
        if (this.dc == null) {
            this.dc = new DC();
            this.controls = new Control[1];
            this.controls[0] = this.dc;
        }
        return this.controls;
    }

    void dropNextFrame(boolean on) {
        this.dropFrame = on;
    }

    static {
        canLoad = true;
    }

    class DC
    implements FrameProcessingControl,
    QualityControl {
        public Component getControlComponent() {
            return null;
        }

        public boolean setMinimalProcessing(boolean on) {
            NativeDecoder.this.dropNextFrame(true);
            return true;
        }

        public int getFramesDropped() {
            return 0;
        }

        public void setFramesBehind(float framesBehind) {
            if (framesBehind > 0.0f) {
                NativeDecoder.this.dropNextFrame(true);
            } else {
                NativeDecoder.this.dropNextFrame(false);
            }
        }

        public float setQuality(float quality) {
            return 1.0f;
        }

        public float getQuality() {
            return 1.0f;
        }

        public float getPreferredQuality() {
            return 1.0f;
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return true;
        }

        DC() {
            NativeDecoder.this = NativeDecoder.this;
        }
    }
}

