/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.RColor;

final class ColorTransform {
    static final int needA = 1;
    static final int needB = 2;
    int flags;
    int ra;
    int rb;
    int ga;
    int gb;
    int ba;
    int bb;
    byte[] redMap;
    byte[] greenMap;
    byte[] blueMap;

    private static void BuildMapChannel(int a2, int b2, byte[] map) {
        int c2 = b2 << 8;
        int n2 = 256;
        int i2 = 0;
        while (n2-- != 0) {
            map[i2++] = (c2 & 0xFFFF0000) == 0 ? (int)(c2 >> 8) : (c2 > 0 ? -1 : 0);
            c2 += a2;
        }
    }

    void BuildMapChannels() {
        this.redMap = new byte[256];
        this.greenMap = new byte[256];
        this.blueMap = new byte[256];
        if (this.redMap == null || this.greenMap == null || this.blueMap == null) {
            this.blueMap = null;
            this.greenMap = null;
            this.redMap = null;
            return;
        }
        ColorTransform.BuildMapChannel(this.ra, this.rb, this.redMap);
        ColorTransform.BuildMapChannel(this.ga, this.gb, this.greenMap);
        ColorTransform.BuildMapChannel(this.ba, this.bb, this.blueMap);
    }

    void Clear() {
        this.flags = 0;
        this.ba = 256;
        this.ga = 256;
        this.ra = 256;
        this.bb = 0;
        this.gb = 0;
        this.rb = 0;
    }

    private static int ApplyChannel(int x, int a2, int b2) {
        if (((x = (x * a2 >> 8) + b2) & 0xFF00) == 0) {
            return x;
        }
        if (x > 0) {
            return 255;
        }
        return 0;
    }

    private static int ApplyChannelB(int x, int a2, int b2) {
        if (((x += b2) & 0xFF00) == 0) {
            return x;
        }
        if (x > 0) {
            return 255;
        }
        return 0;
    }

    void ApplyColorMap(int[] rgb, int n2) {
        if (this.flags == 0 || this.redMap == null) {
            return;
        }
        int i2 = 0;
        while (i2 < n2) {
            int c2 = rgb[i2];
            int red = this.redMap[c2 >> 16 & 0xFF] & 0xFF;
            int green = this.greenMap[c2 >> 8 & 0xFF] & 0xFF;
            int blue = this.blueMap[c2 & 0xFF] & 0xFF;
            rgb[i2] = 0xFF000000 | red << 16 | green << 8 | blue;
            ++i2;
        }
    }

    int ApplyColorMap(int rgb) {
        if (this.flags == 0 || this.redMap == null) {
            return rgb;
        }
        int red = this.redMap[rgb >> 16 & 0xFF] & 0xFF;
        int green = this.greenMap[rgb >> 8 & 0xFF] & 0xFF;
        int blue = this.blueMap[rgb & 0xFF] & 0xFF;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    void Apply(RColor color) {
        if (this.flags == 0) {
            return;
        }
        int c2 = color.color;
        int red = ColorTransform.ApplyChannel(c2 >> 16 & 0xFF, this.ra, this.rb);
        int green = ColorTransform.ApplyChannel(c2 >> 8 & 0xFF, this.ga, this.gb);
        int blue = ColorTransform.ApplyChannel(c2 & 0xFF, this.ba, this.bb);
        c2 = 0xFF000000 | red << 16 | green << 8 | blue;
        color.RecalcSolid(Flash.gApplet.display, c2);
    }

    void ApplyGradient(RColor color) {
        if (this.flags == 0 || color.gcolorRamp == null) {
            return;
        }
        int[] c2 = color.gcolorRamp;
        int i2 = c2.length - 1;
        while (i2 >= 0) {
            int red = ColorTransform.ApplyChannel(c2[i2] >> 16 & 0xFF, this.ra, this.rb);
            int green = ColorTransform.ApplyChannel(c2[i2] >> 8 & 0xFF, this.ga, this.gb);
            int blue = ColorTransform.ApplyChannel(c2[i2] & 0xFF, this.ba, this.bb);
            c2[i2] = 0xFF000000 | red << 16 | green << 8 | blue;
            --i2;
        }
    }

    ColorTransform() {
    }
}

