/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Flash;
import java.io.ByteArrayInputStream;

final class SoundMixer
extends ByteArrayInputStream {
    private int length;
    private int index;

    SoundMixer(byte[] data, int loopCount) {
        super(data);
        this.count = loopCount < 0 ? Integer.MAX_VALUE : data.length * loopCount;
        this.length = data.length;
        Flash.stopAllSoundStreams = false;
    }

    public synchronized int read() {
        if (Flash.stopAllSoundStreams) {
            return -1;
        }
        if (this.pos < this.count) {
            ++this.pos;
            if (this.index >= this.length) {
                this.index = 0;
            }
            return this.buf[this.index++] & 0xFF;
        }
        return -1;
    }

    private int localRead(byte[] dstBuf, int dstIndex, int len) {
        if (this.index >= this.length) {
            return -1;
        }
        if (this.index + len > this.length) {
            len = this.length - this.index;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.index, dstBuf, dstIndex, len);
        this.index += len;
        return len;
    }

    public synchronized int read(byte[] dstBuf, int dstIndex, int len) {
        if (Flash.stopAllSoundStreams) {
            return -1;
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        if (this.index + len <= this.length) {
            System.arraycopy(this.buf, this.index, dstBuf, dstIndex, len);
            this.index += len;
        } else {
            int count = 0;
            while (count < len) {
                int n2 = this.localRead(dstBuf, dstIndex + count, len - count);
                if (n2 >= 0) {
                    count += n2;
                    continue;
                }
                this.index = 0;
            }
        }
        this.pos += len;
        return len;
    }

    public synchronized long skip(long n2) {
        if (Flash.stopAllSoundStreams) {
            return 0L;
        }
        if ((long)this.pos + n2 > (long)this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n2);
        this.index = (int)((long)this.index + n2);
        while (this.index >= this.length) {
            this.index -= this.length;
        }
        return n2;
    }

    public synchronized int available() {
        if (Flash.stopAllSoundStreams) {
            return 0;
        }
        return this.count - this.pos;
    }

    public synchronized void reset() {
        this.index = 0;
        this.pos = 0;
    }

    public static synchronized void StopAllStreams() {
        Flash.stopAllSoundStreams = true;
    }
}

