/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class AuParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private Format format;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private int encoding;
    private String encodingString;
    private int sampleRate;
    private int samplesPerBlock;
    private int bytesPerSecond;
    private int blockSize;
    private long minLocation;
    private long maxLocation;
    private PullSourceStream stream;
    public static final int AU_SUN_MAGIC = 779316836;
    public static final int AU_SUN_INV_MAGIC = 1684960046;
    public static final int AU_DEC_MAGIC = 779314176;
    public static final int AU_DEC_INV_MAGIC = 6583086;
    public static final int AU_ULAW_8 = 1;
    public static final int AU_LINEAR_8 = 2;
    public static final int AU_LINEAR_16 = 3;
    public static final int AU_LINEAR_24 = 4;
    public static final int AU_LINEAR_32 = 5;
    public static final int AU_FLOAT = 6;
    public static final int AU_DOUBLE = 7;
    public static final int AU_ADPCM_G721 = 23;
    public static final int AU_ADPCM_G722 = 24;
    public static final int AU_ADPCM_G723_3 = 25;
    public static final int AU_ADPCM_G723_5 = 26;
    public static final int AU_ALAW_8 = 27;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.basic")};

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.minLocation = this.getLocation(this.stream);
        this.maxLocation = this.dataSize == -1 ? Long.MAX_VALUE : this.minLocation + (long)this.dataSize;
        this.tracks[0] = new AuTrack((AudioFormat)this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        int sampleSizeInBits;
        long contentLength;
        boolean bigEndian;
        int magic = this.readInt(this.stream, true);
        if (magic == 779316836 || magic == 779314176) {
            bigEndian = true;
        } else if (magic == 1684960046 || magic == 6583086) {
            bigEndian = false;
        } else {
            throw new BadHeaderException("Invalid magic number " + Integer.toHexString(magic));
        }
        int headerSize = this.readInt(this.stream);
        if (headerSize < 24) {
            throw new BadHeaderException("AU Parser: header size should be atleast 24 but is " + headerSize);
        }
        this.dataSize = this.readInt(this.stream);
        if (this.dataSize == -1 && (contentLength = this.stream.getContentLength()) != -1L) {
            this.dataSize = (int)(contentLength - (long)headerSize);
            if (this.dataSize < 0) {
                this.dataSize = -1;
            }
        }
        int encoding = this.readInt(this.stream);
        this.blockSize = -1;
        switch (encoding) {
            case 1: {
                this.encodingString = "ULAW";
                sampleSizeInBits = 8;
                this.blockSize = 1;
                break;
            }
            case 27: {
                this.encodingString = "alaw";
                sampleSizeInBits = 8;
                this.blockSize = 1;
                break;
            }
            case 2: {
                this.encodingString = "LINEAR";
                sampleSizeInBits = 8;
                this.blockSize = 1;
                break;
            }
            case 3: {
                this.encodingString = "LINEAR";
                sampleSizeInBits = 16;
                this.blockSize = 2;
                break;
            }
            case 4: {
                this.encodingString = "LINEAR";
                sampleSizeInBits = 24;
                this.blockSize = 3;
                break;
            }
            case 5: {
                this.encodingString = "LINEAR";
                sampleSizeInBits = 32;
                this.blockSize = 4;
                break;
            }
            case 6: {
                this.encodingString = "float";
                sampleSizeInBits = 32;
                this.blockSize = 4;
                break;
            }
            case 7: {
                this.encodingString = "double";
                sampleSizeInBits = 64;
                this.blockSize = 8;
                break;
            }
            case 23: {
                this.encodingString = "??? what adpcm";
                sampleSizeInBits = 4;
                break;
            }
            case 25: {
                this.encodingString = "G723_3";
                sampleSizeInBits = 3;
                break;
            }
            case 26: {
                this.encodingString = "G723_5";
                sampleSizeInBits = 5;
                break;
            }
            default: {
                throw new BadHeaderException("Unsupported encoding: " + Integer.toHexString(encoding));
            }
        }
        int sampleRate = this.readInt(this.stream);
        if (sampleRate < 0) {
            throw new BadHeaderException("Negative Sample Rate " + sampleRate);
        }
        int channels = this.readInt(this.stream);
        if (channels < 1) {
            throw new BadHeaderException("Number of channels is " + channels);
        }
        if (this.blockSize != -1) {
            this.blockSize *= channels;
        }
        this.skip(this.stream, headerSize - 24);
        this.bytesPerSecond = channels * sampleSizeInBits * sampleRate / 8;
        int frameSizeInBytes = channels * sampleSizeInBits / 8;
        this.bufferSize = this.bytesPerSecond;
        if (this.dataSize != -1) {
            double durationSeconds = (double)this.dataSize / (double)this.bytesPerSecond;
            this.duration = new Time(durationSeconds);
        }
        boolean signed = true;
        this.format = new AudioFormat(this.encodingString, sampleRate, sampleSizeInBits, channels, bigEndian ? 1 : 0, signed ? 1 : 0, frameSizeInBytes * 8, -1.0, Format.byteArray);
    }

    public Time setPosition(Time where, int rounding) {
        if (!this.seekable) {
            return this.getMediaTime();
        }
        if (this.blockSize < 0) {
            return this.getMediaTime();
        }
        long time = where.getNanoseconds();
        if (time < 0L) {
            time = 0L;
        }
        double newPosd = (double)(time * (long)this.bytesPerSecond) / 1.0E9;
        double remainder = newPosd % (double)this.blockSize;
        long newPos = (long)(newPosd - remainder);
        if (remainder > 0.0) {
            switch (rounding) {
                case 1: {
                    newPos += (long)this.blockSize;
                    break;
                }
                case 3: {
                    if (!(remainder > (double)this.blockSize / 2.0)) break;
                    newPos += (long)this.blockSize;
                    break;
                }
            }
        }
        if (newPos > this.maxLocation) {
            newPos = this.maxLocation;
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(newPos += this.minLocation);
        if (this.cacheStream != null) {
            AuParser auParser = this;
            synchronized (auParser) {
                this.cacheStream.abortRead();
            }
        }
        return where;
    }

    public Time getMediaTime() {
        long seekLocation = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long location = seekLocation != -1L ? seekLocation - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)location / (double)this.bytesPerSecond);
        }
        return this.mediaTime;
    }

    public Time getDuration() {
        return this.duration;
    }

    public String getName() {
        return "Parser for AU file format";
    }

    class AuTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame;
        private SettableTime frameToTime = new SettableTime();

        AuTrack(AudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize, long minLocation, long maxLocation) {
            super(AuParser.this, format, enabled, AuParser.this.duration, startTime, numBuffers, bufferSize, AuParser.this.stream, minLocation, maxLocation);
            AuParser.this = AuParser.this;
            double sampleRate = format.getSampleRate();
            int channels = format.getChannels();
            int sampleSizeInBits = format.getSampleSizeInBits();
            long durationNano = this.duration.getNanoseconds();
        }

        AuTrack(AudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize) {
            this(format, enabled, startTime, numBuffers, bufferSize, 0L, Long.MAX_VALUE);
        }
    }
}

