/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.UDPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class RTCPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;

    public String filtername() {
        return "RTCP Raw Packet Sender";
    }

    public RTCPRawSender(int port, String address) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(address);
        this.destport = port | 1;
        this.destaddresslist = null;
    }

    public RTCPRawSender(int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(port, address);
        this.setConsumer(sender);
        this.destaddresslist = null;
    }

    public RTCPRawSender(RTPPacketSender sender) {
        this.setConsumer(sender);
    }

    public void addDestAddr(InetAddress newaddr) {
        int i2 = 0;
        if (this.destaddresslist == null) {
            this.destaddresslist = new Vector();
            this.destaddresslist.addElement(this.destaddr);
        }
        i2 = 0;
        while (i2 < this.destaddresslist.size()) {
            InetAddress curraddr = (InetAddress)this.destaddresslist.elementAt(i2);
            if (curraddr.equals(newaddr)) break;
            ++i2;
        }
        if (i2 == this.destaddresslist.size()) {
            this.destaddresslist.addElement(newaddr);
        }
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public Packet handlePacket(Packet p2, int index) {
        this.assemble((RTCPCompoundPacket)p2);
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p2.data;
        udpp.offset = p2.offset;
        udpp.length = p2.length;
        udpp.remoteAddress = (InetAddress)this.destaddresslist.elementAt(index);
        udpp.remotePort = this.destport;
        return udpp;
    }

    public Packet handlePacket(Packet p2) {
        this.assemble((RTCPCompoundPacket)p2);
        PacketConsumer consumer = this.getConsumer();
        if (consumer instanceof RTPPacketSender) {
            return p2;
        }
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p2.data;
        udpp.offset = p2.offset;
        udpp.length = p2.length;
        udpp.remoteAddress = this.destaddr;
        udpp.remotePort = this.destport;
        return udpp;
    }

    public void assemble(RTCPCompoundPacket p2) {
        int len = p2.calcLength();
        p2.assemble(len, false);
    }
}

