/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPReportBlock;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPSRPacket
extends RTCPPacket {
    int ssrc;
    long ntptimestampmsw;
    long ntptimestamplsw;
    long rtptimestamp;
    long packetcount;
    long octetcount;
    RTCPReportBlock[] reports;

    RTCPSRPacket(RTCPPacket parent) {
        super(parent);
        this.type = 200;
    }

    RTCPSRPacket(int ssrc, RTCPReportBlock[] reports) {
        this.ssrc = ssrc;
        this.reports = reports;
        if (reports.length > 31) {
            throw new IllegalArgumentException("Too many reports");
        }
    }

    public String toString() {
        return "\tRTCP SR (sender report) packet for sync source " + this.ssrc + "\n\t\tNTP timestampMSW: " + this.ntptimestampmsw + "\n\t\tNTP timestampLSW: " + this.ntptimestamplsw + "\n\t\tRTP timestamp: " + this.rtptimestamp + "\n\t\tnumber of packets sent: " + this.packetcount + "\n\t\tnumber of octets (bytes) sent: " + this.octetcount + "\n" + RTCPReportBlock.toString(this.reports);
    }

    public int calcLength() {
        return 28 + this.reports.length * 24;
    }

    void assemble(DataOutputStream out) throws IOException {
        out.writeByte(128 + this.reports.length);
        out.writeByte(200);
        out.writeShort(6 + this.reports.length * 6);
        out.writeInt(this.ssrc);
        out.writeInt((int)this.ntptimestamplsw);
        out.writeInt((int)this.ntptimestampmsw);
        out.writeInt((int)this.rtptimestamp);
        out.writeInt((int)this.packetcount);
        out.writeInt((int)this.octetcount);
        int i2 = 0;
        while (i2 < this.reports.length) {
            out.writeInt(this.reports[i2].ssrc);
            out.writeInt((this.reports[i2].packetslost & 0xFFFFFF) + (this.reports[i2].fractionlost << 24));
            out.writeInt((int)this.reports[i2].lastseq);
            out.writeInt(this.reports[i2].jitter);
            out.writeInt((int)this.reports[i2].lsr);
            out.writeInt((int)this.reports[i2].dlsr);
            ++i2;
        }
    }
}

