/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp.protocol;

import com.sun.media.rtsp.protocol.CSeqHeader;
import com.sun.media.rtsp.protocol.DurationHeader;
import com.sun.media.rtsp.protocol.Parser;
import com.sun.media.rtsp.protocol.RangeHeader;
import com.sun.media.rtsp.protocol.SdpParser;
import com.sun.media.rtsp.protocol.SessionHeader;
import com.sun.media.rtsp.protocol.TransportHeader;
import java.io.ByteArrayInputStream;

public class Header
extends Parser {
    public int type;
    public Object parameter;
    public static final int TRANSPORT = 1;
    public static final int CSEQ = 2;
    public static final int SESSION = 3;
    public static final int DURATION = 4;
    public static final int RANGE = 5;
    public static final int DATE = 6;
    public static final int SERVER = 7;
    public static final int CONTENT_TYPE = 8;
    public static final int CONTENT_BASE = 9;
    public static final int CONTENT_LENGTH = 10;

    public Header(ByteArrayInputStream bin) {
        String id = this.getToken(bin);
        if (id.equals("CSeq:")) {
            this.type = 2;
            String number = this.getToken(bin);
            System.out.println("CSeq     : " + number);
            this.parameter = new CSeqHeader(number);
        } else if (id.equals("Transport:")) {
            this.type = 1;
            String tx = this.getToken(bin);
            System.out.println("xfer : " + tx);
            this.parameter = new TransportHeader(tx);
        } else if (id.equals("Session:")) {
            this.type = 3;
            String tx = this.getToken(bin);
            this.parameter = new SessionHeader(tx);
        } else if (id.equals("Duration:")) {
            this.type = 4;
            String tx = this.getToken(bin);
            System.out.println("Duration : " + tx);
            this.parameter = new DurationHeader(tx);
        } else if (id.equals("Range:")) {
            this.type = 5;
            String tx = this.getToken(bin);
            System.out.println("Range : " + tx);
            this.parameter = new RangeHeader(tx);
        } else if (id.equals("Date:")) {
            this.type = 6;
            String date = this.getStringToken(bin);
            System.out.println("Date : " + date);
        } else if (id.equals("Allow:")) {
            this.type = 6;
            String entries = this.getStringToken(bin);
            System.out.println("Allow : " + entries);
        } else if (id.equals("Server:")) {
            this.type = 7;
            String server = this.getStringToken(bin);
            System.out.println("Server   : " + server);
        } else if (id.equals("Content-Type:")) {
            this.type = 8;
            String content_type = this.getStringToken(bin);
            System.out.println("Content-Type : " + content_type);
        } else if (id.equals("Content-Base:")) {
            this.type = 9;
            String content_base = this.getStringToken(bin);
            System.out.println("Content-Base : " + content_base);
        } else if (id.equals("Content-length:")) {
            this.type = 10;
            String content_length = this.getStringToken(bin);
            System.out.println("Content-length : " + content_length);
            byte[] content = this.getContent(bin);
            System.out.println("Content : " + new String(content));
            SdpParser sdpParser = new SdpParser(content);
            sdpParser.parseData();
            this.parameter = sdpParser;
        } else if (id.length() > 0) {
            System.out.println("unknown id : <" + id + ">");
        }
    }
}

