/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp.protocol;

import com.sun.media.rtsp.protocol.Parser;
import java.io.ByteArrayInputStream;

public class SdpParser
extends Parser {
    private byte[] data;
    private ByteArrayInputStream bin;
    private double lower_range;
    private double upper_range;
    private String video_track;
    private String audio_track;

    public SdpParser(byte[] data) {
        this.data = data;
        this.bin = new ByteArrayInputStream(data);
    }

    public void parseData() {
        while (this.bin.available() > 0) {
            this.parseNextEntry();
        }
    }

    public void parseNextEntry() {
        String id = this.getToken(this.bin);
        if (id.startsWith("v=")) {
            System.out.println("version: " + id.substring(2));
        } else if (id.startsWith("a=range:")) {
            System.out.println("range: " + id.substring(8));
            int start = id.indexOf("npt=") + 4;
            int end = id.indexOf(45);
            System.out.println("lower_range: " + id.substring(start, end));
            System.out.println("upper_range: " + id.substring(end + 1));
            this.lower_range = new Double(id.substring(start, end));
            this.upper_range = new Double(id.substring(end + 1));
        } else if (id.startsWith("m=video")) {
            System.out.println("video port : " + this.getToken(this.bin));
            System.out.println("transport  : " + this.getToken(this.bin));
            System.out.println("payload    : " + this.getToken(this.bin));
            id = this.getToken(this.bin);
            this.video_track = id.substring(18);
            System.out.println("video track: <" + this.video_track + ">");
        } else if (id.startsWith("m=audio")) {
            System.out.println("audio port : " + this.getToken(this.bin));
            System.out.println("transport  : " + this.getToken(this.bin));
            System.out.println("payload    : " + this.getToken(this.bin));
            id = this.getToken(this.bin);
            this.audio_track = id.substring(18);
            System.out.println("audio track: <" + this.audio_track + ">");
        } else if (!id.startsWith("t=")) {
            id.length();
        }
    }

    public double getDuration() {
        return this.upper_range;
    }

    public String getVideoTrackID() {
        return this.video_track;
    }

    public String getAudioTrackID() {
        return this.audio_track;
    }
}

