/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class GenerateImage {
    private IndexColorModel icm;
    private DirectColorModel dcm;
    private Image image;
    private byte[] data;
    private int width;
    private int height;
    byte[] reds = new byte[256];
    byte[] greens = new byte[256];
    byte[] blues = new byte[256];

    private native int getColors(byte[] var1, int var2);

    private native boolean generateImage(String var1);

    public GenerateImage() {
        int ncolors = this.getColors(this.reds, 0);
        this.getColors(this.greens, 1);
        this.getColors(this.blues, 2);
        this.icm = new IndexColorModel(8, 256, this.reds, this.greens, this.blues, 0);
    }

    public Image getImage(String imageName) {
        this.image = null;
        this.data = null;
        if (this.generateImage(imageName)) {
            this.createImage();
            return this.image;
        }
        return null;
    }

    protected synchronized void createBuffer(int w, int h2) {
        this.width = w;
        this.height = h2;
        this.data = new byte[w * h2];
    }

    protected synchronized void createImage() {
        MemoryImageSource mis = new MemoryImageSource(this.width, this.height, (ColorModel)this.icm, this.data, 0, this.width);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.image = tk.createImage(mis);
        tk.prepareImage(this.image, this.width, this.height, null);
    }
}

