/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

class PlayListModel
extends AbstractTableModel {
    PlayListEditor PLE;
    String[] columns = new String[]{"#", "Location", "Track", "Artist", "Genre", "Time", "Bitrate"};
    String[][] rows = new String[0][this.columns.length];
    private int numColumns = this.columns.length;
    private int numRows = this.rows.length;

    PlayListModel(PlayList playList) {
        int n = playList.NumberOfTracks();
        if (n == 0) {
            return;
        }
        String[][] stringArray = new String[n][this.columns.length];
        playList.startingTrack();
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2][1] = playList.CurrentTrack();
            stringArray[n2][0] = new Integer(n2 + 1).toString();
            if (!playList.isURL(n2)) {
                ID3Tag iD3Tag = playList.getID3TrackInfo();
                if (iD3Tag != null) {
                    stringArray[n2][2] = iD3Tag.Track_name;
                    stringArray[n2][3] = iD3Tag.Artist_name;
                    stringArray[n2][4] = iD3Tag.Genre;
                    stringArray[n2][5] = MP3Globals.convSecsHoursMinutes(playList.getTrackDuration());
                    stringArray[n2][6] = playList.getTrackBitrate();
                }
            } else {
                stringArray[n2][2] = playList.getTrackDescription();
                stringArray[n2][4] = playList.getTrackGenre();
                stringArray[n2][6] = playList.getTrackBitrate();
            }
            playList.nextTrack();
            ++n2;
        }
        this.rows = stringArray;
        this.numColumns = this.columns.length;
        this.numRows = this.rows.length;
    }

    public void storePlayListEditor(PlayListEditor playListEditor) {
        this.PLE = playListEditor;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getRowCount() {
        return this.numRows;
    }

    public Object getValueAt(int n, int n2) {
        return this.rows[n][n2];
    }

    public void setValueAt(Object object, int n, int n2) {
        String string = object instanceof String ? (String)object : object.toString();
        this.rows[n][n2] = string;
        this.fireTableChanged(new TableModelEvent(this, n));
    }

    public String getColumnName(int n) {
        return this.columns[n];
    }
}

