/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.avi;

import com.sun.media.parser.video.AviParser;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.avi.FileDataSource;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;

public class DataSource
extends PushBufferDataSource {
    private String fileName;
    private javax.media.protocol.DataSource inputDataSource;
    private AviParser aviParser;
    private Track[] tracks;
    private Format[] formats;
    private int numTracks;
    private String contentType = "raw";
    private boolean connected = false;
    private PushBufferStream[] streams = new PushBufferStream[0];

    public void doConnect(String fileName) throws IOException {
        try {
            this.fileName = fileName;
            this.inputDataSource = new FileDataSource(fileName);
            this.inputDataSource.connect();
            this.aviParser = new AviParser();
            this.aviParser.setSource(this.inputDataSource);
            try {
                this.tracks = this.aviParser.getTracks();
            }
            catch (BadHeaderException badHeaderException) {
                throw new IOException("");
            }
            if (this.tracks == null || this.tracks.length <= 0) {
                throw new IOException("Unable to get the tracks");
            }
            int i2 = 0;
            while (i2 < this.tracks.length) {
                System.out.println(this.tracks[i2].getFormat().getEncoding());
                ++i2;
            }
            this.numTracks = this.tracks.length;
            this.formats = new Format[this.numTracks];
            int i3 = 0;
            while (i3 < this.numTracks) {
                System.out.println(this.tracks[i3]);
                this.formats[i3] = this.tracks[i3].getFormat();
                this.tracks[i3].setEnabled(true);
                ++i3;
            }
        }
        catch (IncompatibleSourceException e2) {
            throw new IOException(e2.getMessage());
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            System.err.println("medialocator is null");
            throw new IOException(String.valueOf(this) + ": connect() failed");
        }
        String fileName = locator.getRemainder();
        this.doConnect(fileName);
        this.streams = new PushBufferStream[this.numTracks];
        int i2 = 0;
        while (i2 < this.numTracks) {
            this.streams[i2] = new AviSourceStream(this.tracks[i2]);
            ++i2;
        }
        System.out.println("connected");
        this.connected = true;
    }

    public void disconnect() {
    }

    public void start() throws IOException {
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.streams[i2] != null) {
                ((AviSourceStream)this.streams[i2]).start();
            }
            ++i2;
        }
    }

    public void stop() throws IOException {
    }

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        System.out.println("avids: getContentType returns " + this.contentType);
        return this.contentType;
    }

    public PushBufferStream[] getStreams() {
        if (!this.connected) {
            return null;
        }
        return this.streams;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    class AviSourceStream
    extends BasicSourceStream
    implements PushBufferStream,
    Runnable {
        private BufferTransferHandler transferHandler;
        private boolean started = false;
        private Buffer buffer = new Buffer();
        private Format format;
        private Track track;

        AviSourceStream(Track track) {
            DataSource.this = DataSource.this;
            this.track = track;
            this.buffer.setData(null);
            this.format = track.getFormat();
        }

        public Format getFormat() {
            return this.format;
        }

        public void setTransferHandler(BufferTransferHandler th) {
            System.out.println("setTransferHandler: " + th);
            this.transferHandler = th;
        }

        public void connect() throws IOException {
        }

        void disconnect() {
        }

        void start() throws IOException {
            if (this.started) {
                return;
            }
            if (this.transferHandler != null) {
                new Thread(this).start();
                this.started = true;
            }
        }

        void stop() throws IOException {
            this.started = false;
        }

        public synchronized void read(Buffer b2) {
            if (this.buffer.getLength() > 0) {
                b2.setOffset(this.buffer.getOffset());
                b2.setData(this.buffer.getData());
                b2.setLength(this.buffer.getLength());
                b2.setTimeStamp(this.buffer.getTimeStamp());
                b2.setFormat(this.format);
            } else {
                b2.setLength(this.buffer.getLength());
            }
        }

        public void run() {
            while (true) {
                this.track.readFrame(this.buffer);
                AviSourceStream aviSourceStream = this;
                synchronized (aviSourceStream) {
                    if (this.transferHandler != null) {
                        this.transferHandler.transferData(this);
                    }
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
    }
}

