/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.OverallTransStats;
import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTPEventHandler;
import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtp.RTPSourceInfoCache;
import com.sun.media.rtp.RecvSSRCInfo;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.TrueRandom;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.LocalCollisionEvent;
import javax.media.rtp.event.RemoteCollisionEvent;

public class SSRCCache {
    Hashtable cache;
    RTPSourceInfoCache sourceInfoCache;
    OverallStats stats;
    OverallTransStats transstats;
    RTPEventHandler eventhandler;
    int[] clockrate = new int[128];
    static final int DATA = 1;
    static final int CONTROL = 2;
    static final int SRCDATA = 3;
    static final int RTCP_MIN_TIME = 5000;
    static final int BYE_THRESHOLD = 50;
    int alivecount;
    int pmembers = 1;
    int sendercount;
    double rtcp_bw_fraction;
    double rtcp_sender_bw_fraction;
    int rtcp_min_time = 5000;
    double tp;
    private static final int NOTIFYPERIOD = 500;
    int sessionbandwidth;
    boolean initial = true;
    boolean byestate = false;
    boolean rtcpsent = false;
    int avgrtcpsize = 128;
    Hashtable conflicttable = new Hashtable(5);
    SSRCInfo ourssrc;
    public RTPSessionMgr sm;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    SSRCCache(RTPSessionMgr sm) {
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        this.stats = sm.defaultstats;
        this.transstats = sm.transstats;
        this.sourceInfoCache = new RTPSourceInfoCache();
        this.sourceInfoCache.setMainCache(this.sourceInfoCache);
        this.sourceInfoCache.setSSRCCache(this);
        this.cache = new Hashtable(20);
        this.sm = sm;
        this.eventhandler = new RTPEventHandler(sm);
        this.setclockrates();
    }

    SSRCCache(RTPSessionMgr sm, RTPSourceInfoCache sic) {
        this.stats = sm.defaultstats;
        this.transstats = sm.transstats;
        this.sourceInfoCache = sic;
        sic.setSSRCCache(this);
        this.cache = new Hashtable(20);
        this.sm = sm;
        this.eventhandler = new RTPEventHandler(sm);
    }

    void setclockrates() {
        int i2 = 0;
        while (i2 < 16) {
            this.clockrate[i2] = 8000;
            ++i2;
        }
        this.clockrate[6] = 16000;
        this.clockrate[10] = 44100;
        this.clockrate[11] = 44100;
        this.clockrate[14] = 90000;
        this.clockrate[16] = 11025;
        this.clockrate[17] = 22050;
        this.clockrate[18] = 44100;
        int i3 = 24;
        while (i3 < 34) {
            this.clockrate[i3] = 90000;
            ++i3;
        }
        int i4 = 96;
        while (i4 < 128) {
            Format fmt = this.sm.formatinfo.get(i4);
            this.clockrate[i4] = fmt != null && fmt instanceof AudioFormat ? (int)((AudioFormat)fmt).getSampleRate() : 90000;
            ++i4;
        }
    }

    synchronized void destroy() {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            this.remove((Integer)enumeration.nextElement());
        }
        if (this.eventhandler != null) {
            this.eventhandler.close();
        }
    }

    SSRCInfo lookup(int ssrc) {
        return (SSRCInfo)this.cache.get(new Integer(ssrc));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SSRCInfo get(int ssrc, InetAddress address, int port, int mode) {
        SSRCInfo info = null;
        boolean localcollision = false;
        SSRCCache sSRCCache = this;
        synchronized (sSRCCache) {
            SSRCInfo newinfo;
            if (this.ourssrc != null && this.ourssrc.ssrc == ssrc && this.ourssrc.address != null && !this.ourssrc.address.equals(address)) {
                localcollision = true;
                this.LocalCollision(ssrc);
            }
            if ((info = this.lookup(ssrc)) != null) {
                SSRCInfo sSRCInfo = info;
                synchronized (sSRCInfo) {
                    if (info.address == null || !info.alive) {
                        info.address = address;
                        info.port = port;
                    } else if (!info.address.equals(address)) {
                        if (info.probation > 0) {
                            info.probation = 2;
                            info.address = address;
                            info.port = port;
                        } else {
                            this.stats.update(4, 1);
                            ++this.transstats.remote_coll;
                            RemoteCollisionEvent evt = new RemoteCollisionEvent(this.sm, info.ssrc);
                            this.eventhandler.postEvent(evt);
                            return null;
                        }
                    }
                }
            }
            if (info != null && mode == 1 && !(info instanceof RecvSSRCInfo)) {
                if (info.ours) {
                    return null;
                }
                System.out.println("changing to Recv");
                System.out.println("existing one is " + info);
                newinfo = new RecvSSRCInfo(info);
                System.out.println("new one is " + newinfo);
                info = newinfo;
                this.cache.put(new Integer(ssrc), info);
            }
            if (info != null && mode == 2 && !(info instanceof PassiveSSRCInfo)) {
                if (info.ours) {
                    return null;
                }
                System.out.println("changing to Passive");
                System.out.println("existing one " + info);
                newinfo = new PassiveSSRCInfo(info);
                System.out.println("new one is " + newinfo);
                info = newinfo;
                this.cache.put(new Integer(ssrc), info);
            }
            if (info == null) {
                if (mode == 3) {
                    if (this.ourssrc != null && this.ourssrc.ssrc == ssrc) {
                        return this.ourssrc;
                    }
                    info = new SendSSRCInfo(this, ssrc);
                    info.initsource((int)TrueRandom.rand());
                }
                if (mode == 1) {
                    info = new RecvSSRCInfo(this, ssrc);
                }
                if (mode == 2) {
                    info = new PassiveSSRCInfo(this, ssrc);
                }
                if (info == null) {
                    return null;
                }
                info.address = address;
                info.port = port;
                this.cache.put(new Integer(ssrc), info);
            }
            if (info.address == null && info.port == 0) {
                info.address = address;
                info.port = port;
            }
            if (!localcollision) return info;
            LocalCollisionEvent levt = null;
            levt = info instanceof RecvSSRCInfo ? new LocalCollisionEvent(this.sm, (ReceiveStream)((Object)info), this.ourssrc.ssrc) : new LocalCollisionEvent(this.sm, null, this.ourssrc.ssrc);
            this.eventhandler.postEvent(levt);
            return info;
        }
    }

    private void changessrc(SSRCInfo info) {
        info.setOurs(true);
        if (this.ourssrc != null) {
            info.sourceInfo = this.sourceInfoCache.get(this.ourssrc.sourceInfo.getCNAME(), info.ours);
            info.sourceInfo.addSSRC(info);
        }
        info.reporter.releasessrc("Local Collision Detected");
        this.ourssrc = info;
        info.reporter.restart = true;
    }

    private void LocalCollision(int ssrc) {
        int newssrc = 0;
        while (this.lookup(newssrc = (int)TrueRandom.rand()) != null) {
        }
        PassiveSSRCInfo newinfo = new PassiveSSRCInfo(this.ourssrc);
        newinfo.ssrc = newssrc;
        this.cache.put(new Integer(newssrc), newinfo);
        this.changessrc(newinfo);
        this.ourssrc = newinfo;
        this.stats.update(3, 1);
        ++this.transstats.local_coll;
    }

    SSRCInfo get(int ssrc, InetAddress address, int port) {
        SSRCCache sSRCCache = this;
        synchronized (sSRCCache) {
            SSRCInfo info;
            SSRCInfo sSRCInfo = info = this.lookup(ssrc);
            Object var7_7 = null;
            return sSRCInfo;
        }
    }

    void remove(int ssrc) {
        SSRCInfo info = (SSRCInfo)this.cache.remove(new Integer(ssrc));
        if (info != null) {
            info.delete();
        }
    }

    int getSessionBandwidth() {
        if (this.sessionbandwidth == 0) {
            throw new IllegalArgumentException("Session Bandwidth not set");
        }
        return this.sessionbandwidth;
    }

    double calcReportInterval(boolean sender, boolean recvfromothers) {
        this.rtcp_min_time = 5000;
        double rtcp_bw = this.rtcp_bw_fraction;
        if (this.initial) {
            this.rtcp_min_time /= 2;
        }
        int n2 = this.alivecount;
        if (this.sendercount > 0 && (double)this.sendercount < (double)this.alivecount * this.rtcp_sender_bw_fraction) {
            if (sender) {
                rtcp_bw *= this.rtcp_sender_bw_fraction;
                n2 = this.sendercount;
            } else {
                rtcp_bw *= 1.0 - this.rtcp_sender_bw_fraction;
                n2 -= this.sendercount;
            }
        }
        if (recvfromothers && rtcp_bw == 0.0) {
            rtcp_bw = 0.05;
            if (this.sendercount > 0 && (double)this.sendercount < (double)this.alivecount * 0.25) {
                if (sender) {
                    rtcp_bw *= 0.25;
                    n2 = this.sendercount;
                } else {
                    rtcp_bw *= 0.75;
                    n2 -= this.sendercount;
                }
            }
        }
        double time = 0.0;
        if (rtcp_bw != 0.0 && (time = (double)(this.avgrtcpsize * n2) / rtcp_bw) < (double)this.rtcp_min_time) {
            time = this.rtcp_min_time;
        }
        if (recvfromothers) {
            return time;
        }
        return time * (Math.random() + 0.5);
    }

    synchronized void updateavgrtcpsize(int size) {
        this.avgrtcpsize = (int)(0.0625 * (double)size + 0.9375 * (double)this.avgrtcpsize);
    }

    RTPSourceInfoCache getRTPSICache() {
        return this.sourceInfoCache;
    }

    Hashtable getMainCache() {
        return this.cache;
    }

    double OnExpire(boolean report) {
        if (!report) {
            double t = this.calcReportInterval(this.ourssrc.sender, false);
            double tn = this.tp + t;
            if (tn <= (double)System.currentTimeMillis()) {
                return 0.0;
            }
            return t;
        }
        double t = this.calcReportInterval(this.ourssrc.sender, false);
        boolean sendit = false;
        double tn = this.tp + t;
        double tc = System.currentTimeMillis();
        if (tn <= tc) {
            sendit = true;
        } else {
            tn = tc + t;
        }
        if (sendit) {
            return 0.0;
        }
        return t;
    }

    public void reset(int size) {
        this.tp = System.currentTimeMillis();
        this.alivecount = 1;
        this.pmembers = 1;
        this.initial = true;
        this.sendercount = 0;
        this.avgrtcpsize = size;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

