/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;

public class Parser {
    public Parser() {
        this.init();
    }

    public String getToken(ByteArrayInputStream bin) {
        PushbackInputStream pin = new PushbackInputStream(bin);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.skipWhitespace(pin);
            if (pin.available() > 0) {
                int ch = pin.read();
                while (ch != 32 && ch != 10 && ch != 13 && ch != -1) {
                    bout.write(ch);
                    ch = bin.read();
                }
            }
        }
        catch (IOException iOException) {}
        String token = new String(bout.toByteArray());
        return token;
    }

    public String getStringToken(ByteArrayInputStream bin) {
        PushbackInputStream pin = new PushbackInputStream(bin);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.skipWhitespace(pin);
            int ch = pin.read();
            while (ch != 10 && ch != 13 && ch != -1) {
                bout.write(ch);
                ch = bin.read();
            }
        }
        catch (IOException iOException) {}
        String token = new String(bout.toByteArray());
        return token;
    }

    public byte[] getContent(ByteArrayInputStream bin) {
        PushbackInputStream pin = new PushbackInputStream(bin);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.skipWhitespace(pin);
            int ch = pin.read();
            while (ch != -1) {
                bout.write(ch);
                ch = bin.read();
            }
        }
        catch (IOException iOException) {}
        return bout.toByteArray();
    }

    private void skipWhitespace(PushbackInputStream pin) {
        try {
            int ch = pin.read();
            while (ch == 32 || ch == 10 || ch == 13) {
                ch = pin.read();
            }
            pin.unread(ch);
        }
        catch (IOException iOException) {}
    }

    private void init() {
    }
}

