/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.BooleanControl;
import com.sun.media.ui.AtomicComponent;
import com.sun.media.ui.BooleanComponent;
import java.awt.Graphics;
import java.awt.Image;

public class FloatToggle
extends BooleanComponent {
    Image imageNormal;
    Image imageActive;
    Image imageDown;
    Image imageDisabled;

    public FloatToggle(String imgNormal, String imgActive, String imgDown, String imgDisabled, String tip) {
        super(tip);
        this.imageNormal = AtomicComponent.fetchImage(imgNormal);
        this.imageActive = AtomicComponent.fetchImage(imgActive);
        this.imageDown = AtomicComponent.fetchImage(imgDown);
        this.imageDisabled = AtomicComponent.fetchImage(imgDisabled);
        this.width = this.imageNormal.getWidth(this);
        this.height = this.imageNormal.getHeight(this);
        this.setSize(this.width, this.height);
        this.setVisible(true);
    }

    public void mouseActivity() {
        if (this.isEnabled()) {
            if (this.mouseIn) {
                int n2 = this.visualState = this.state ? 4 : 2;
                if (this.mouseDown) {
                    this.visualState = 4;
                }
                if (this.mouseDown && this.mouseUp) {
                    boolean bl = this.state = !this.state;
                    if (this.control != null) {
                        ((BooleanControl)this.control).setValue(this.state);
                    }
                    this.visualState = this.state ? 4 : 2;
                }
            } else {
                this.visualState = this.state ? 4 : 1;
            }
            this.repaint();
        }
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.visualState = value ? (this.state ? 4 : 1) : 8;
        this.repaint();
    }

    public void paint(Graphics g2) {
        if (this.visualState == 1) {
            g2.drawImage(this.imageNormal, 0, 0, this);
        } else if (this.visualState == 4) {
            g2.drawImage(this.imageDown, 0, 0, this);
        } else if (this.visualState == 8) {
            g2.drawImage(this.imageDisabled, 0, 0, this);
        } else if (this.visualState == 2) {
            g2.drawImage(this.imageActive, 0, 0, this);
        }
    }
}

