/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import javax.media.Format;

public class ContentDescriptor
extends Format {
    public static final String QUICKTIME = "video.quicktime";
    public static final String MSVIDEO = "video.x_msvideo";
    public static final String MPEG = "video.mpeg";
    public static final String VIVO = "video.vivo";
    public static final String BASIC_AUDIO = "audio.basic";
    public static final String WAVE = "audio.x_wav";
    public static final String AIFF = "audio.x_aiff";
    public static final String MIDI = "audio.midi";
    public static final String RMF = "audio.rmf";
    public static final String GSM = "audio.x_gsm";
    public static final String MPEG_AUDIO = "audio.x_mpegaudio";
    public static final String RAW = "raw";
    public static final String RAW_RTP = "raw.rtp";
    public static final String MIXED = "application.mixed-data";
    public static final String CONTENT_UNKNOWN = "UnknownContent";

    public String getContentType() {
        return this.getEncoding();
    }

    public ContentDescriptor(String cdName) {
        super(cdName);
    }

    public String toString() {
        if (this.encoding.equalsIgnoreCase(QUICKTIME)) {
            return "QuickTime";
        }
        if (this.encoding.equalsIgnoreCase(MSVIDEO)) {
            return "AVI";
        }
        if (this.encoding.equalsIgnoreCase(MPEG)) {
            return "MPEG Video";
        }
        if (this.encoding.equalsIgnoreCase(VIVO)) {
            return "Vivo";
        }
        if (this.encoding.equalsIgnoreCase(BASIC_AUDIO)) {
            return "Basic Audio (au)";
        }
        if (this.encoding.equalsIgnoreCase(WAVE)) {
            return "WAV";
        }
        if (this.encoding.equalsIgnoreCase(AIFF)) {
            return "AIFF";
        }
        if (this.encoding.equalsIgnoreCase(MIDI)) {
            return "MIDI";
        }
        if (this.encoding.equalsIgnoreCase(RMF)) {
            return "RMF";
        }
        if (this.encoding.equalsIgnoreCase(GSM)) {
            return "GSM";
        }
        if (this.encoding.equalsIgnoreCase(MPEG_AUDIO)) {
            return "MPEG Audio";
        }
        if (this.encoding.equalsIgnoreCase(RAW)) {
            return "RAW";
        }
        if (this.encoding.equalsIgnoreCase(RAW_RTP)) {
            return "RAW/RTP";
        }
        if (this.encoding.equalsIgnoreCase("audio.cdaudio")) {
            return "CD Audio";
        }
        return this.encoding;
    }

    public static final String mimeTypeToPackageName(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        mimeType = mimeType.toLowerCase();
        int len = mimeType.length();
        char[] nm = new char[len];
        mimeType.getChars(0, len, nm, 0);
        int i2 = 0;
        while (i2 < len) {
            char c2 = nm[i2];
            if (c2 == '/') {
                nm[i2] = 46;
            } else if (!(c2 == '.' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9')) {
                nm[i2] = 95;
            }
            ++i2;
        }
        return new String(nm);
    }
}

