/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import com.sun.media.rtp.util.Signed;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;

public class RTCPFeedbackWindow
extends Frame
implements ActionListener {
    Vector reportblks;
    int currindex;
    int size;
    Button next;
    Button prev;
    private TextField dlsrtf;
    private TextField flosttf;
    private TextField jittertf;
    private TextField lsrtf;
    private TextField numlosttf;
    private TextField ssrctf;
    private TextField seqnumtf;
    private GridBagLayout gridbag;
    private GridBagConstraints c;

    public RTCPFeedbackWindow(Vector reportblks) {
        super("RTCP Report Block/Feedback");
        this.reportblks = reportblks;
        ((Component)this).setFont(new Font("Helvetica", 0, 14));
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.setLayout(this.gridbag);
        this.Outline();
        this.next = new Button("Next Feedback");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(this.next, this.c);
        this.next.addActionListener(this);
        this.add(this.next);
        this.prev = new Button("Prev Feedback");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(this.prev, this.c);
        this.prev.addActionListener(this);
        this.prev.setEnabled(false);
        this.add(this.prev);
        if (reportblks != null) {
            this.size = reportblks.size();
            if (this.size > 0) {
                this.Fill((Feedback)reportblks.elementAt(this.currindex));
            }
            if (this.size == 1) {
                this.next.setEnabled(false);
            }
        }
        this.pack();
        this.show();
        this.addWindowListener(new 1());
    }

    public void close() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        int tempcurrindex;
        Button chosen = (Button)event.getSource();
        if (chosen == this.next && (tempcurrindex = this.currindex + 1) + 1 <= this.reportblks.size()) {
            this.Fill((Feedback)this.reportblks.elementAt(++this.currindex));
            if (tempcurrindex + 1 == this.reportblks.size()) {
                this.next.setEnabled(false);
                this.prev.setEnabled(true);
            } else {
                this.next.setEnabled(true);
                this.prev.setEnabled(true);
            }
        }
        if (chosen == this.prev) {
            tempcurrindex = this.currindex - 1;
            if (tempcurrindex >= 0) {
                this.Fill((Feedback)this.reportblks.elementAt(--this.currindex));
            }
            if (tempcurrindex == 0) {
                this.prev.setEnabled(false);
                this.next.setEnabled(true);
            } else {
                this.prev.setEnabled(true);
                this.next.setEnabled(true);
            }
        }
    }

    private void Outline() {
        Label dlsr = new Label("DLSR in secs");
        this.gridbag.setConstraints(dlsr, this.c);
        this.add(dlsr);
        this.dlsrtf = new TextField();
        this.dlsrtf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.dlsrtf, this.c);
        this.add(this.dlsrtf);
        Label flost = new Label("FractionLost");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(flost, this.c);
        this.add(flost);
        this.flosttf = new TextField();
        this.flosttf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.flosttf, this.c);
        this.add(this.flosttf);
        Label numlost = new Label("Number Lost in pkts");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(numlost, this.c);
        this.add(numlost);
        this.numlosttf = new TextField();
        this.numlosttf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.numlosttf, this.c);
        this.add(this.numlosttf);
        Label jitter = new Label("Jitter in RTPtime");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(jitter, this.c);
        this.add(jitter);
        this.jittertf = new TextField();
        this.jittertf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.jittertf, this.c);
        this.add(this.jittertf);
        Label lsr = new Label("LSR in NTPtime");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(lsr, this.c);
        this.add(lsr);
        this.lsrtf = new TextField();
        this.lsrtf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.lsrtf, this.c);
        this.add(this.lsrtf);
        Label ssrc = new Label("SSRC");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(ssrc, this.c);
        this.add(ssrc);
        this.ssrctf = new TextField();
        this.ssrctf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.ssrctf, this.c);
        this.add(this.ssrctf);
        Label seqnum = new Label("XtndSeqNum");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(seqnum, this.c);
        this.add(seqnum);
        this.seqnumtf = new TextField();
        this.seqnumtf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.seqnumtf, this.c);
        this.add(this.seqnumtf);
    }

    public void update(Report report) {
        this.reportblks = report.getFeedbackReports();
        this.size = this.reportblks.size();
        if (this.size > 0) {
            this.Fill((Feedback)this.reportblks.elementAt(this.currindex));
        }
        if (this.size == 1) {
            this.next.setEnabled(false);
            this.prev.setEnabled(false);
        } else {
            this.next.setEnabled(true);
        }
    }

    private void Fill(Feedback reportblk) {
        if (reportblk == null) {
            return;
        }
        long ssrc = reportblk.getSSRC();
        if (ssrc < 0L) {
            ssrc = Signed.UnsignedInt((int)ssrc);
        }
        ((TextComponent)this.ssrctf).setText(new Long(ssrc).toString());
        double flost = (double)reportblk.getFractionLost() / 256.0;
        ((TextComponent)this.flosttf).setText(new Double(flost).toString());
        long numlost = reportblk.getNumLost();
        ((TextComponent)this.numlosttf).setText(new Long(numlost).toString());
        long seqnum = reportblk.getXtndSeqNum();
        ((TextComponent)this.seqnumtf).setText(new Long(seqnum).toString());
        long jitter = reportblk.getJitter();
        ((TextComponent)this.jittertf).setText(new Long(jitter).toString());
        long lsr = reportblk.getLSR();
        ((TextComponent)this.lsrtf).setText(new Long(lsr).toString());
        double dlsr = (double)reportblk.getDLSR() / 65536.0;
        ((TextComponent)this.dlsrtf).setText(new Double(dlsr).toString());
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            RTCPFeedbackWindow.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }
}

