/*
 * Decompiled with CFR 0.152.
 */
package bigbrother;

import bigbrother.ADMappings;
import bigbrother.ADObject;
import bigbrother.TimeConverter;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

class ActiveDirectory {
    DirContext ctx;
    ADObject[] data;
    String rootQuery;
    String login;
    String password;
    String server;
    String domain;
    boolean connected = false;

    public boolean isConnected() {
        return this.connected;
    }

    public void login(String string, String string2, String string3, String string4) throws Exception {
        String string5 = string3;
        if (string.indexOf("@") == -1) {
            string = string + "@" + string4;
        }
        if (string5.indexOf("ldap://") != 0) {
            string5 = "ldap://" + string5;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string5);
        hashtable.put("java.naming.security.principal", string);
        hashtable.put("java.naming.security.credentials", string2);
        this.ctx = new InitialDirContext(hashtable);
        this.login = string;
        this.password = string2;
        this.server = string3;
        this.domain = string4;
        String[] stringArray = string4.split("\\.");
        this.rootQuery = "";
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.rootQuery = this.rootQuery + "dc=" + stringArray[n2] + ", ";
            ++n2;
        }
        this.rootQuery = this.rootQuery.substring(0, this.rootQuery.length() - 2);
        this.connected = true;
    }

    public void logoff() {
        this.ctx = null;
        this.data = new ADObject[0];
        this.connected = false;
    }

    public void synchronize() {
        String[] stringArray = ADMappings.getAllMappings();
        this.data = this.synchronizeHelper(this.rootQuery, stringArray, this.ctx);
        String[] stringArray2 = ADMappings.getSyncMappings();
        ADObject[] aDObjectArray = this.getDomainControllers();
        int n2 = 0;
        while (n2 < aDObjectArray.length) {
            if (!aDObjectArray[n2].getValue("cn").equalsIgnoreCase(this.server)) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
                hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                hashtable.put("java.naming.provider.url", "ldap://" + aDObjectArray[n2].getValue("cn"));
                hashtable.put("java.naming.security.principal", this.login);
                hashtable.put("java.naming.security.credentials", this.password);
                try {
                    InitialDirContext initialDirContext = new InitialDirContext(hashtable);
                    System.out.println(initialDirContext);
                    ADObject[] aDObjectArray2 = this.synchronizeHelper(this.rootQuery, stringArray2, initialDirContext);
                    int n3 = 0;
                    while (n3 < this.data.length) {
                        ADObject aDObject = this.matchObject(this.data[n3], aDObjectArray2);
                        if (aDObject != null) {
                            String string = TimeConverter.getLargerTime(this.data[n3].getValue("lastLogon"), aDObject.getValue("lastLogon"));
                            this.data[n3].setValue("lastlogon", string);
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    ADObject[] synchronizeHelper(String string, String[] stringArray, DirContext dirContext) {
        ADObject[] aDObjectArray;
        Vector<ADObject> vector = new Vector<ADObject>();
        String string2 = "(objectClass=*)";
        try {
            aDObjectArray = new SearchControls();
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string, (Attributes)new BasicAttributes(), stringArray);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                ADObject aDObject = new ADObject(searchResult, string);
                if (ADMappings.isBlackListed(aDObject)) continue;
                vector.add(new ADObject(searchResult, string));
                if (!aDObject.isFolder()) continue;
                ADObject[] aDObjectArray2 = this.synchronizeHelper(aDObject.getValue("dn"), stringArray, dirContext);
                int n2 = 0;
                while (n2 < aDObjectArray2.length) {
                    vector.add(aDObjectArray2[n2]);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        aDObjectArray = new ADObject[vector.size()];
        vector.toArray(aDObjectArray);
        return aDObjectArray;
    }

    public ADObject[] getUsers() {
        Vector<ADObject> vector = new Vector<ADObject>();
        int n2 = 0;
        while (n2 < this.data.length) {
            if (this.data[n2].isUser() && !this.data[n2].getValue("userPrincipalName").equals("")) {
                vector.add(this.data[n2]);
            }
            ++n2;
        }
        ADObject[] aDObjectArray = new ADObject[vector.size()];
        vector.toArray(aDObjectArray);
        return aDObjectArray;
    }

    public ADObject[] getDomainControllers() {
        Vector<ADObject> vector = new Vector<ADObject>();
        int n2 = 0;
        while (n2 < this.data.length) {
            if (this.data[n2].isDomainController()) {
                vector.add(this.data[n2]);
            }
            ++n2;
        }
        ADObject[] aDObjectArray = new ADObject[vector.size()];
        vector.toArray(aDObjectArray);
        return aDObjectArray;
    }

    public ADObject matchObject(ADObject aDObject, ADObject[] aDObjectArray) {
        String string = aDObject.getValue("dn");
        int n2 = 0;
        while (n2 < aDObjectArray.length) {
            if (aDObjectArray[n2].getValue("dn").equalsIgnoreCase(string)) {
                return aDObjectArray[n2];
            }
            ++n2;
        }
        return null;
    }
}

