/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminRights {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayRightEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("right_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("access_right");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%access_right%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayRights(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("rights");
        AdminUtils.displayList(adminContext);
    }

    protected static void doRightEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("right_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminRights.verifyRightEntry(adminContext)) {
                AdminRights.updateRightEntry(adminContext);
                adminContext.setForm("rights");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "rights", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminRights.verifyRightEntry(adminContext)) {
                    AdminRights.updateRightEntry(adminContext);
                    adminContext.setForm("rights");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("rights");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminRights.displayRightEntry(adminContext);
    }

    protected static void doRights(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("rights");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminRights.displayRightEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminRights.parseRightEntry(adminContext);
                AdminRights.displayRightEntry(adminContext);
                return;
            }
        } else {
            if (adminContext.action.equals("change")) {
                AdminUtils.changeRealm(adminContext);
                AdminUtils.displayList(adminContext);
                return;
            }
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getRightEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("access_right", string);
        return hashtable;
    }

    protected static void parseRightEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminRights.getRightEntry(adminContext, hashtable);
    }

    protected static void updateRightEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("access_right");
        hashtable = AdminUtils.getSessionData(adminContext, "rights");
        hashtable.put(string, "");
        AdminUtils.putSessionData(adminContext, "rights", hashtable);
    }

    protected static boolean verifyRightEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = AdminRights.getRightEntry(adminContext, AdminUtils.getFormData(adminContext, "rights"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string = "";
        String string2 = adminContext.request.getParameter("key");
        if (string2 != null) {
            string = string2;
            hashtable2.put("key", string);
        }
        if ((string2 = adminContext.request.getParameter("access_right")) == null) {
            adminContext.error_message.append("Access Right is required.<br>");
            string2 = hashtable.get("access_right");
            if (string2 != null) {
                hashtable2.put("access_right", string2);
            }
        } else {
            String string3 = DString.trim(string2);
            if (string3.length() == 0) {
                adminContext.error_message.append("Access Right is required.<br>");
                string2 = hashtable.get("access_right");
                if (string2 != null) {
                    hashtable2.put("access_right", string2);
                }
            } else if (string.equals(string3)) {
                hashtable2.put("access_right", string3);
            } else if (AdminUtils.getFormEntry(adminContext, "rights", string3) != null) {
                adminContext.error_message.append("Access Right already exists.<br>");
                string2 = hashtable.get("access_right");
                if (string2 != null) {
                    hashtable2.put("access_right", string2);
                }
            } else {
                hashtable2.put("access_right", string3);
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

