/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.ArchiveIOHandler;
import stec.iws.FileCache;
import stec.iws.FileIOHandler;
import stec.iws.IOHandler;
import stec.iws.IOManager;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class FileServlet
extends HttpServlet {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private static final int ITEMLEN = 25;
    private static final int FSIZELEN = 10;
    private String directoryTemplate;
    private FileCache fileCache;

    private static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        simpleDateFormat.applyPattern("MM/dd/yyyy, HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public String getServletInfo() {
        return "Servertec (R) Application/Web Server Version 1.7.0 01/09/2000 Preview Release\nCopyright (C) Servertec 1998-2000. All rights reserved.\n\nFileServlet";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.directoryTemplate = Utils.getItem(IOManager.getHandler(iws.basedir, "./html/directory.html"));
            int n = 4;
            String string = servletConfig.getInitParameter("cache_size");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("cache_size must be a numeric value: " + string);
                }
            }
            if (n > 0) {
                this.fileCache = new FileCache(n * 0x100000);
                String string2 = servletConfig.getInitParameter("files");
                if (string2 != null && string2.length() > 0) {
                    int n2 = DString.dcount(string2, ",");
                    int n3 = 0;
                    while (n3 < n2) {
                        String string3 = DString.extract(string2, ",", n3).trim();
                        this.fileCache.get(iws.inArchive ? new ArchiveIOHandler(string3) : new FileIOHandler(string3));
                        ++n3;
                    }
                    return;
                }
            }
        }
        catch (IOException iOException) {
            throw new ServletException(iOException.getMessage());
        }
    }

    private void sendDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IOHandler iOHandler, boolean bl) throws IOException {
        Object object;
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setDateHeader("Date", new Date().getTime());
        if (bl) {
            return;
        }
        String string = new String(this.directoryTemplate);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = httpServletRequest.getRequestURI();
        int n = string2.indexOf(63);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        string2 = Utils.normalizeURI(string2);
        String[] stringArray = iOHandler.list();
        int n2 = 0;
        while (stringArray != null && n2 < stringArray.length) {
            String string3 = stringArray[n2].length() > 25 ? stringArray[n2].substring(0, 25) : stringArray[n2];
            object = stringArray[n2];
            object = iOHandler instanceof ArchiveIOHandler ? new ArchiveIOHandler(iOHandler, (String)object) : new FileIOHandler(iOHandler, (String)object);
            String string4 = Utils.concatURIs(string2, stringArray[n2]);
            stringBuffer.append("<A HREF=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\">");
            stringBuffer.append(string3);
            stringBuffer.append("</A>");
            stringBuffer.append(" ");
            stringBuffer.append(DString.pad("", " ", 25 - string3.length(), 'L'));
            if (object.isDirectory()) {
                stringBuffer.append(DString.pad("DIR", " ", 10, 'L'));
            } else {
                stringBuffer.append(DString.pad(String.valueOf(object.length()), " ", 10, 'R'));
            }
            stringBuffer.append(" ");
            stringBuffer.append(FileServlet.formatDate(new Date(object.lastModified())));
            stringBuffer.append("<BR>");
            ++n2;
        }
        n = string2.lastIndexOf(47);
        object = n == -1 || n == 0 ? "/" : string2.substring(0, n);
        string = DString.replace(string, "%host%", ((Request)httpServletRequest).getServerName());
        string = DString.replace(string, "%uri%", string2);
        string = DString.replace(string, "%parent%", (String)object);
        string = DString.replace(string, "%directory%", stringBuffer.toString());
        string = DString.replace(string, "%date%", new Date().toString());
        httpServletResponse.setContentLength(string.length());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.write(string.getBytes());
        servletOutputStream.flush();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IOHandler iOHandler, boolean bl) throws IOException {
        Object object;
        block45: {
            byte[] byArray;
            long l;
            long l2;
            boolean bl2;
            block46: {
                Object object2;
                block47: {
                    int n;
                    boolean bl3;
                    String string = iOHandler.getCanonicalPath();
                    String string2 = Integer.toHexString(string.hashCode());
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setContentType(iws.getMimeType(string));
                    httpServletResponse.setDateHeader("Date", new Date().getTime());
                    httpServletResponse.setDateHeader("Last-Modified", iOHandler.lastModified());
                    httpServletResponse.setHeader("Accept-Ranges", "bytes");
                    httpServletResponse.setHeader("ETag", string2);
                    if (bl) {
                        return;
                    }
                    String string3 = httpServletRequest.getHeader("If-Range");
                    if (string3 == null) {
                        bl3 = true;
                    } else if (string3.equals(string2)) {
                        bl3 = true;
                    } else {
                        try {
                            long l3 = Utils.parseDate(string3);
                            bl3 = iOHandler.lastModified() <= l3;
                        }
                        catch (Exception exception) {
                            bl3 = false;
                        }
                    }
                    bl2 = false;
                    l2 = 0L;
                    l = iOHandler.length() - 1L;
                    if (bl3 && (object = httpServletRequest.getHeader("Range")) != null && (n = ((String)object).indexOf(61)) != -1 && ((String)(object2 = DString.trim(((String)object).substring(0, n)))).equalsIgnoreCase("bytes") && (n = ((String)(object = ((String)object).substring(n + 1))).indexOf(45)) != -1) {
                        try {
                            l2 = Long.parseLong(DString.trim(((String)object).substring(0, n)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            l2 = -1L;
                        }
                        try {
                            l = Long.parseLong(DString.trim(((String)object).substring(n + 1)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            l = iOHandler.length() - 1L;
                        }
                        if (l2 == -1L) {
                            l2 = iOHandler.length() - l;
                            l = iOHandler.length() - 1L;
                        }
                        if (l >= l2) {
                            bl2 = true;
                        }
                    }
                    object = httpServletResponse.getOutputStream();
                    byArray = null;
                    if (this.fileCache != null) {
                        byArray = this.fileCache.get(iOHandler);
                    }
                    if (byArray != null) break block46;
                    byArray = new byte[8192];
                    if (!bl2) break block47;
                    if (iOHandler instanceof FileIOHandler) {
                        long l4 = l - l2 + 1L;
                        RandomAccessFile randomAccessFile = new RandomAccessFile(((FileIOHandler)iOHandler).file, "r");
                        StringBuffer stringBuffer = new StringBuffer("bytes ");
                        stringBuffer.append(l2);
                        stringBuffer.append("-");
                        stringBuffer.append(l);
                        stringBuffer.append("/");
                        stringBuffer.append(iOHandler.length());
                        httpServletResponse.setHeader("Content-Range", stringBuffer.toString());
                        httpServletResponse.setContentLength((int)l4);
                        httpServletResponse.setStatus(206);
                        try {
                            randomAccessFile.seek(l2);
                            long l5 = l4 / 8192L;
                            int n2 = 0;
                            while (true) {
                                int n3;
                                if ((long)n2 >= l5) {
                                    n3 = (int)(l4 - l5 * 8192L);
                                    if (n3 > 0) {
                                        n3 = randomAccessFile.read(byArray, 0, n3);
                                        ((OutputStream)object).write(byArray, 0, n3);
                                    }
                                    break;
                                }
                                n3 = randomAccessFile.read(byArray);
                                ((OutputStream)object).write(byArray, 0, n3);
                                ++n2;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var21_36 = null;
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                            throw throwable;
                        }
                        Object var21_35 = null;
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        break block45;
                    } else {
                        int n4;
                        int n5;
                        object2 = new BufferedInputStream(iOHandler.getInputStream());
                        if (l2 > 0L) {
                            ((BufferedInputStream)object2).skip(l2);
                        }
                        int n6 = (int)(l - l2 + 1L);
                        StringBuffer stringBuffer = new StringBuffer("bytes ");
                        stringBuffer.append(l2);
                        stringBuffer.append("-");
                        stringBuffer.append(l);
                        stringBuffer.append("/");
                        stringBuffer.append(byArray.length);
                        httpServletResponse.setHeader("Content-Range", stringBuffer.toString());
                        httpServletResponse.setContentLength(n6);
                        httpServletResponse.setStatus(206);
                        int n7 = n6 / 8192;
                        int n8 = 0;
                        while (true) {
                            if (n8 >= n7) {
                                n5 = n6 - n7 * 8192;
                                break;
                            }
                            n5 = 8192;
                            while (n5 > 0 && (n4 = ((BufferedInputStream)object2).read(byArray, 0, n5)) != -1) {
                                ((OutputStream)object).write(byArray, 0, n4);
                                n5 -= n4;
                            }
                            ++n8;
                        }
                        while (n5 > 0 && (n4 = ((BufferedInputStream)object2).read(byArray, 0, n5)) != -1) {
                            ((OutputStream)object).write(byArray, 0, n4);
                            n5 -= n4;
                        }
                        Object var18_21 = null;
                        if (object2 != null) {
                            ((FilterInputStream)object2).close();
                        }
                    }
                    break block45;
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        if (object2 != null) {
                            ((FilterInputStream)object2).close();
                        }
                        throw throwable;
                    }
                }
                object2 = new BufferedInputStream(iOHandler.getInputStream());
                httpServletResponse.setContentLength((int)iOHandler.length());
                try {
                    int n;
                    while ((n = ((FilterInputStream)object2).read(byArray)) > 0) {
                        ((OutputStream)object).write(byArray, 0, n);
                    }
                }
                finally {
                    Object var18_23 = null;
                    if (object2 != null) {
                        ((FilterInputStream)object2).close();
                    }
                }
            }
            if (bl2) {
                int n = (int)(l - l2 + 1L);
                StringBuffer stringBuffer = new StringBuffer("bytes ");
                stringBuffer.append(l2);
                stringBuffer.append("-");
                stringBuffer.append(l);
                stringBuffer.append("/");
                stringBuffer.append(byArray.length);
                httpServletResponse.setHeader("Content-Range", stringBuffer.toString());
                httpServletResponse.setContentLength(n);
                httpServletResponse.setStatus(206);
                long l6 = n / 8192;
                int n9 = 0;
                while (true) {
                    if ((long)n9 >= l6) {
                        int n10 = (int)((long)n - l6 * 8192L);
                        if (n10 > 0) {
                            ((OutputStream)object).write(byArray, (int)(l6 * 8192L + l2), n10);
                        }
                        break block45;
                    }
                    ((OutputStream)object).write(byArray, (int)((long)(n9 * 8192) + l2), 8192);
                    ++n9;
                }
            }
            httpServletResponse.setContentLength(byArray.length);
            int n = byArray.length / 8192;
            int n11 = 0;
            while (true) {
                if (n11 >= n) {
                    int n12 = byArray.length - n * 8192;
                    if (n12 <= 0) break;
                    ((OutputStream)object).write(byArray, n * 8192, n12);
                    break;
                }
                ((OutputStream)object).write(byArray, n11 * 8192, 8192);
                ++n11;
            }
        }
        ((OutputStream)object).flush();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        long l;
        boolean bl;
        String string = httpServletRequest.getMethod();
        if (string.equals("GET") || string.equals("POST")) {
            bl = false;
        } else if (string.equals("HEAD")) {
            bl = true;
        } else {
            httpServletResponse.sendError(405);
            return;
        }
        Object object = httpServletRequest.getPathTranslated();
        Object object2 = object = iws.inArchive ? new ArchiveIOHandler((String)object) : new FileIOHandler((String)object);
        if (!object.exists()) {
            if (this.fileCache != null) {
                this.fileCache.remove((IOHandler)object);
            }
            httpServletResponse.sendError(404);
            return;
        }
        boolean bl2 = false;
        String string2 = httpServletRequest.getHeader("If-Modified-Since");
        if (string2 != null) {
            l = Utils.parseDate(string2);
            if (object.lastModified() <= l) {
                bl = true;
                bl2 = true;
            }
        }
        if ((string2 = httpServletRequest.getHeader("If-Unmodified-Since")) != null) {
            l = Utils.parseDate(string2);
            if (object.lastModified() > l) {
                bl = true;
                bl2 = true;
            }
        }
        if (object.isDirectory() && iws.default_page != null) {
            Object object3 = iws.default_page;
            Object object4 = object3 = object instanceof ArchiveIOHandler ? new ArchiveIOHandler((IOHandler)object, (String)object3) : new FileIOHandler((IOHandler)object, (String)object3);
            if (object3.exists()) {
                String string3;
                object = object3;
                String string4 = httpServletRequest.getRequestURI();
                int n = string4.indexOf(63);
                if (n != -1) {
                    string4 = string4.substring(0, n);
                }
                string3 = (string3 = Utils.normalizeURI(string4)).endsWith("/") ? String.valueOf(string3) + iws.default_page : String.valueOf(string3) + "/" + iws.default_page;
                httpServletResponse.sendRedirect(string3);
                return;
            }
        }
        if (object.isDirectory()) {
            if (!iws.displayDirectory) {
                httpServletResponse.sendError(403);
                return;
            }
            this.sendDirectory(httpServletRequest, httpServletResponse, (IOHandler)object, bl);
        } else {
            this.sendFile(httpServletRequest, httpServletResponse, (IOHandler)object, bl);
        }
        if (bl2) {
            httpServletResponse.setStatus(304);
            ((Response)httpServletResponse).headers.remove("Content-Length");
        }
    }
}

