/*
 * @(#)ArgsServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.StringTokenizer;
import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;

import stec.iws.Utils;

public class ArgsServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        _response.setContentType("text/html");

        ServletOutputStream out = _response.getOutputStream();

        out.println("<html>");
        out.println("<head><title>Display Arguments</title></head>");
        out.println("<body>");
        
        args(out, _request);
        
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
    
    protected static void args(ServletOutputStream out, HttpServletRequest _request) throws IOException
    {
        out.println("<h1>Arguments:</h1>");
        
        out.println("<lit>");

        String qs = _request.getQueryString();
        if(qs != null)
        {
            int counter = 0;
            
            String args = Utils.getArgs(_request);
            if(args != null)
            {
                StringTokenizer st = new StringTokenizer(args);
                while(st.hasMoreElements())
                {
                    out.println("args[" + counter + "] = [" + st.nextElement() + "]<br>");
                    counter++;
                }
            }
        }

        out.println("</lit>");
    }

    public String getServletInfo()
    {
        return "ArgsServlet";
    }
}
