/*
 * @(#)CookieCounterServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;

import stec.iws.Utils;

public class CookieCounterServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        int counter;
        Cookie cookies[] = _request.getCookies();
        if(cookies == null)
        {
            counter = 0;
        }
        else
        {
            Cookie cookie = Utils.extractCookie(cookies, "cookiecounter");
            if(cookie == null)
            {
                counter = 0;
            }    
            else
            {
                counter = Integer.parseInt(cookie.getValue());
            }
        }
        
        _response.addCookie(new Cookie("cookiecounter", String.valueOf(counter+1)));

        _response.setContentType("text/html");

        ServletOutputStream out = _response.getOutputStream();

        out.println("<html>");
        out.println("<head><title>Cookie Counter</title></head>");
        out.println("<body>");

        if(counter == 0)
        {
            out.println("cookie counter did not exist");
        }    
        else    
        {
            out.println("cookie counter is " + counter);
        }    
            
        out.println("<p>");
        out.println("[ <a href=\"./cookiecounter.html\">refresh</a> ]");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    public String getServletInfo()
    {
        return "CookieCounterServlet";
    }
}
