package org.phoenix.jtools.jlookup;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import org.phoenix.datatypes.*;
import org.phoenix.jtools.util.*;
import org.phoenix.util.*;

public class lookupTableModel extends AbstractTableModel {
	Vector data = new Vector();
	Vector columns = new Vector();
	public lookupTableModel() {
		columns.addElement("Domain");
		columns.addElement("Type");
		columns.addElement("Record");
	}
	public void add(domain a, String type, String record) {
		data.addElement(a);
		data.addElement(type);
		data.addElement(record);
		fireTableChanged(new TableModelEvent(this));
	}
	public void clear() {
		data = new Vector();
		fireTableChanged(new TableModelEvent(this));
	}
	public void setColumnData(Vector v) {
		columns = v;
	}
	public String getColumnName(int i) {
		if (i >= 0 && i < columns.size()) {
			return (String) columns.elementAt(i);
		}
		return "No Name";
	}
	public int getColumnCount() {
		return 3;
	}
	public int getRowCount() {
		return (data.size() / getColumnCount());
	}
	public Object getValueAt(int row, int col) {
		return data.elementAt((getColumnCount() * row) + col);
	}
}

