package org.phoenix.jtools;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import org.phoenix.jtools.jtelnet.*;

import org.phoenix.jtools.jscanner.*;
import org.phoenix.jtools.jlookup.*;
import org.phoenix.util.*;

public class jtools extends JFrame implements ActionListener {
	jscanner scanner = new jscanner();
	jlookup lookup = new jlookup();
	jtelnet telnet = new jtelnet();	public static final String iniFile = "jtools.ini";
	static String dnsServer = "207.250.6.10";
	public static void main(String args[]) {
		jtools jt = new jtools();
		splash s = new splash(jt.getClass().getResource("resources/jtoolsSplash.gif"));
		long start = System.currentTimeMillis();
		int i = 0;
		while (System.currentTimeMillis() - start < 1500) {
			i++;
		}
		jt.show();
		s.dispose();
	}
	public jtools() {
		super();

		setTitle("JTools");

		loadDNS();
		lookup.setDefaultDNS(dnsServer);
		scanner.setDefaultDNS(dnsServer);

		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		setBounds(0, 0, dim.width, dim.height);
		
		JTabbedPane pane = new JTabbedPane(JTabbedPane.TOP);
		pane.addTab("Port Scan", null, scanner, "Port Scan - a utility to scan tcp ports");		pane.addTab("Dns Lookup", null, lookup, "Dns Lookup - a dns client utility");
		pane.addTab("Telnet", null, telnet, "Telnet - a telnet client utility");
		getContentPane().add(pane);

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent evt) {
				System.exit(0);
			}
		});
		setJMenuBar(getMenu());
	}
	public void actionPerformed(ActionEvent e) {
		JMenuItem source = (JMenuItem)(e.getSource());
		String command = source.getText();
		if (command.equals("Quit")) {
			System.exit(0);
		} else if (command.equals("Preferences...")) {
			editDNS();
		} else if (command.equals("About...")) {
			about aboutPanel = new about(getClass().getResource("resources/aboutHeader.gif"));
			JDialog diag = new JDialog(this, "About Jtools", true);
			diag.getContentPane().add(aboutPanel);
			aboutPanel.setParent(diag);
			diag.setResizable(false);
			diag.doLayout();
			diag.setBounds(0, 0, aboutPanel.getSize().width, aboutPanel.getSize().height);
			diag.setLocation((getSize().width - diag.getSize().width) / 2, (getSize().height - diag.getSize().height) / 2);
			diag.show();
		}
	}
	public JMenuBar getMenu() {
		JMenuBar bar = new JMenuBar();
		JMenu file = new JMenu("File");
		JMenuItem prefs = new JMenuItem("Preferences...");
		JMenuItem quit = new JMenuItem("Quit");
		file.add(prefs);
		file.add(quit);
		prefs.addActionListener(this);
		quit.addActionListener(this);
		JMenu help = new JMenu("Help");
		JMenuItem about = new JMenuItem("About...");
		help.add(about);
		about.addActionListener(this);
		bar.add(file);
		bar.add(help);
		return bar;
	}
	public void editDNS() {
		JPanel top = new JPanel();
		final JTextField dns = new JTextField(dnsServer, 20);  
		top.add(new JLabel("Default DNS server"));
		top.add(dns);

		final JDialog diag = new JDialog(this, true);

		JPanel bottom = new JPanel();
		JButton ok = new JButton("OK");
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				diag.dispose();
			}
		});
		ok.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dnsServer = dns.getText();
				lookup.setDefaultDNS(dnsServer);
				scanner.setDefaultDNS(dnsServer);
				diag.dispose();
				saveDNS();
			}
		});

		bottom.add(ok);
		bottom.add(cancel);

		JPanel all = new JPanel(new BorderLayout());

		all.add("North", top);
		all.add("South", bottom);
	
		diag.getContentPane().add(all);
		diag.doLayout();
		diag.setLocation((getSize().width - all.getPreferredSize().width) / 2, (getSize().height - all.getPreferredSize().height) / 2);
		diag.pack();
		diag.show();
	}
	public void loadDNS() {
		try {
			InputStream in = new FileInputStream(iniFile);
			Properties prop = new Properties();
			prop.load(in);
			dnsServer = prop.getProperty("dnsServer");
		} catch(Exception e) {
			System.out.println("Error Loading Properties");
		}
	}
	public void saveDNS() {
		try {
			OutputStream out = new FileOutputStream(iniFile);
			Properties prop = new Properties();
			prop.setProperty("dnsServer", dnsServer);
			prop.store(out, "");
		} catch(Exception e) {
			System.out.println("Error Saving Properties");
		}
	}
}