// SerialRedirect.h : main header file for the SERIALREDIRECT application
//

#if !defined(AFX_SERIALREDIRECT_H__04614644_0C6D_11D2_85E0_00609755C47F__INCLUDED_)
#define AFX_SERIALREDIRECT_H__04614644_0C6D_11D2_85E0_00609755C47F__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CSerialRedirectApp:
// See SerialRedirect.cpp for the implementation of this class
//

#include "ParmStruct.h"


class CSerialRedirectApp : public CWinApp
{
private:
	BOOL	appInitialize();

	void	processPortDef( char *line );
	BOOL	fileLoadUserFile( CStringList *listUsers );

	void	CreateTaskbarIcons();

	BOOL	ProcessUserLoginLine( LPPARMSTRUCT pm );
    BOOL	ProcessUserTestLogin( LPPARMSTRUCT pm );


	CCriticalSection	m_criticalDataBlocks;
	CObList				m_listFreeDataBlocks;

	BOOL			m_boolSuperSocketReady;

	CString			m_cstrUserFile,m_cstrCfgFile;

	CWinThread		*m_SuperThread;
	volatile BOOL	m_boolSuperThreadTerminate;
	volatile BOOL	m_boolSuperThreadExited;

	CString			m_cstrTaskbarTip;
	int				m_curTaskbarIcon;
	int				m_busyCounter;

	class CMainFrame	*m_mainFrame;


	HICON			m_iconTaskbarIdle;
	HICON			m_iconTaskbarAct0;
	HICON			m_iconTaskbarAct1;
	HICON			m_iconTaskbarAct2;
	HICON			m_iconTaskbarAct3;

	CBitmap			m_bmpMask;

	CBitmap			m_bmpTaskbarIdle;
	CBitmap			m_bmpTaskbarAct0;
	CBitmap			m_bmpTaskbarAct1;
	CBitmap			m_bmpTaskbarAct2;
	CBitmap			m_bmpTaskbarAct3;



public:
	CString			m_wndClassInvisibleParent;
	CWnd			m_wndInvisibleParent;

	CAsyncSocket	m_SuperSocket;
	CString			m_cstrNetAddrDesc;

	CObList			m_listPortServers;


	inline void		SetMainFrame( CMainFrame *mf ){ m_mainFrame = mf; }

	void			SetTaskbarIcon( int nIcon );
	void			AnimateTaskbarIcon( BOOL );

	class CDataBlock	*dblkAlloc(void);
	void		dblkRelease( CDataBlock *blk );
	void		dblkPruneOldBlocks();

	BOOL		appShutdown();

	void		entrySuperThread(void);

	volatile int	nBytesRead;
	volatile int	nBytesWritten;

	CSerialRedirectApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSerialRedirectApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CSerialRedirectApp)
	afx_msg void OnAppAbout();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



extern CSerialRedirectApp theApp;

extern DWORD	GetElapsedTicks( DWORD timeMark );

void dataEncrypt( char *buff, int len, CString cstrKey, int & curIndex );
void dataDecrypt( char *buff, int len, CString cstrKey, int & curIndex );


#define WM_TASKBARACTION	WM_USER+1




/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SERIALREDIRECT_H__04614644_0C6D_11D2_85E0_00609755C47F__INCLUDED_)
