#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                 A taskTracker  	-- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered,gStack,gPrevCard
  put "taskTracker" into gStack
  if the short name of this stack <> gStack then exit openStack
  if gRegistered is empty then
    open stack "launcher"
  else
    lock screen
    if field "date" of card 1 is empty then
      go first card
      put the long date into field "date"
    else
      if gPrevCard is not empty then
        go card gPrevCard
      else
        go last card
      end if
    end if
    saveData
    setArrows
    unlock screen with visual plain
  end if
end openStack

on openCard
  if the short name of this stack is "taskTracker" then
    switch field "priority"
    case 1
      set the label of button "priority" to "Urgent"
      break
    case 2
      set the label of button "priority" to "High"
      break
    case 3
      set the label of button "priority" to "Medium"
      break
    case 4
      set the label of button "priority" to "Low"
    end switch
    saveData
  end if
end openCard

on clearCardOne
  put the number of field "date" into firstField
  repeat with i = firstField to the number of fields
    put empty into field i
  end repeat
  put 1 into field "record"
  put 2 into field "priority"
  set the label of button "priority" to "High"
end clearCardOne

on checkCompleted
  if the number of cards = 1 and field "deadline" is empty then exit checkCompleted
  if field "date" is empty then put the long date into field "date"
  if field "task" is empty then
    answer warning "This record is missing a task description" & return & \
        "and will not be included in any report." with "Fix later" or "Delete Record" or "Fix now"
    unlock screen
    if it is "fix now" then
      click at the loc of field "task"
      exit to metaCard
    end if
    if it is "Delete Record"  then
      if the number of cards > 1 then
        lock screen
        put the number of this card into cardNum
        delete this card
        go card cardNum
        unlock screen
      else
        clearCardOne
      end if
      repeat with i = 1 to the number of cards
        put i into field "record" of card i
      end repeat
    end if
  end if
end checkCompleted

on closeCard
  global gDontSave
  if gDontSave then
    put false into gDontSave
    exit closeCard
  end if
  if the short name of this stack is "taskTracker" then
    checkData
  else
    set cursor to watch
    save this stack
  end if
end closeCard
  w         ک Wheat    white        
       ^ 
Task Tracker      W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U monaco  	 U monaco   U 
helvetica 8records,atmain.mc
taskTracker,tasks.mc
passwords,password.mc
launcher,itmain.mc
launcher,sbdmain.mc
launcher,aetmain.mc
launcher,sbmain.mc
writer,whelper.mc
versions,version.mc
vehicleExp,vehexp.mc
invoiceTracker,invoice.mc
inventory,inventry.mc
scheduler,schedule.mc
contacts,contact.mc
calculator,calculat.mc
       	@                  i        
   date1 label   on mouseUp
  ask "Go to the first record with date" with the short date
  if it is empty then exit mouseUp
  convert it to long date
  repeat with i = 1 to the number of cards
    if field "date" of card i is it then
      lock screen
      go card i
      unlock screen with visual plain
      setarrows
      exit mouseUp
    end if
  end repeat
  answer information "No records with that date."
end mouseUp
          l            Entered 
  E date2 label           6 l            	Deadline 
  L date3 label           g l            
Completed 
  J label4            l            	Priority 
   label5                        Notes 
   label6           6 v            Task Description    New Ex  on mouseUp
  global gRegistered,gUseBlankRecord
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    toplevel  "Register"
    exit mouseUp
  end if
  
  if gUseBlankRecord is empty then put false into gUseBlankRecord
  if field "task" is empty then
    if gUseBlankRecord is false then
      answer information "You need to enter a task description" & return & \
          "for this record before creating another."
    end if
    click at the loc of field "task"
    put false into gUseBlankRecord
    exit mouseUp
  end if
  
  checkCompleted
  lock screen
  lock messages
  go last
  create card
  put the number of this card into field "record"
  put the long date into field "date"
  put "2" into field "priority"
  set the label of button "priority" to "High"
  setArrows
  unlock screen with visual plain
  click at the loc of field "task"
end mouseUp
           kk LightSalmon    & A             	     
   recNumLabel    $on mouseUp
  goCardNum
end mouseUp
         E            	Record # 
   date  	x  Mon mouseUp
  if field "date" is empty then
    put the long date into temp
  else
    put field "date" into temp
  end if
  
  convert temp to short date
  ask "Enter a Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "date"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "date"
  end if
end mouseUp
        
             
  D 	deadline  	x  aon mouseUp
  if field "deadline" is empty then
    put the long date into temp
  else
    put field "deadline" into temp
  end if
  
  convert temp to short date
  ask "Enter a Deadline" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "deadline"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "deadline"
  end if
end mouseUp
        
 L            
  K 	donedate  	x  on mouseUp
  if field "donedate" is empty then
    put the long date into temp
  else
    put field "donedate" into temp
  end if
  
  convert temp to short date
  ask "Enter a Completed Date" with temp
  if it is empty then
    put empty into field "donedate"
    exit mouseUp
  end if
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "donedate"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "donedate"
  end if
end mouseUp
        
 }            
   task  )x   on returnInField
  answer "Returns are not allowed in this field"
end returnInField

on enterInField
  answer "Returns are not allowed in this field"
end enterInField
         L  p            P    	`    @ s M  n 
   notes  )h         
                   	`    @      
   record  x    %on mouseUp
  goCardNum
end mouseUp

       Z  *          1    First @V  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go first
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   kk LightSalmon      * ,  ?         	   	  o    Prev @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go prev
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   kk LightSalmon     * ,  @         	      Next @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go next
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   kk LightSalmon   ?  * ,  A         	      Last @F  
 on mouseUp
  global gVeffect
  lock screen
checkCompleted
  go last
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   kk LightSalmon   e  * ,  B         	      Delete Ex  Ion mouseUp
  if the number of cards = 1 then
    if field "date" is empty then
      answer information "There are no more records to delete."
    else
      lock screen
      clearCardOne
      put the long date into field "date"
    end if
    exit mouseUp
  end if
  answer question "Delete all records, completed records or just this one?" with "All" or "Completed" or "Just this one" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock messages
  put the number of this card into cardNum
  if it is "completed" then
    repeat with i = the number of cards  down to 2
      set cursor to busy
      if field "donedate" of card i <> empty then  delete card i
    end repeat
    
    go card 1
    if field "donedate" of card 1 <> empty then
      if the number of cards  is 1 then
        clearCardOne
        put the long date into field "date"
      else
        delete card 1
      end if
    end if
  end if
  
  if it is "All" then
    lock screen
    repeat with i = the number of cards down to 2
      set cursor to busy
      delete card i
    end repeat
    clearCardOne
    put the long date into field "date"
    setArrows
    unlock screen with visual plain
    exit mouseUp
  end if
  
  if it is "Just this one" then
    lock screen
    if the number of cards > 1 then
      delete this card
    else
      clearCardOne
      put the long date into field "date"
    end if
    go card cardNum
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
           kk LightSalmon   C& A             	        Find Ex  on mouseUp
  global gFindStack, gFoundOne
  put "atFind" into zFindStack
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 220 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack zFindStack to it
  go card 1 of stack zFindStack
  show stack zFindStack
  select text of field "find" of stack zFindStack
end mouseUp
           kk LightSalmon    @ A              	        Sort Ex  on mouseUp
  if field "date" is empty then
    answer information "No records to sort."
    exit mouseUp
  end if
  answer question "Sort records by deadline, priority or date entered?" with  "Cancel" or "Deadline" or "Priority" or "Entered"
  if it is "Cancel" then exit mouseUp
  unlock screen
  put it into which
  if which is "Entered" then put "date" into which
  lock screen
  lock messages
  if which is "priority" then
    put "date" into whichField
  else
    put which into whichField
  end if
  repeat with i = 1 to the number of cards
    put empty into temp
    put field whichField of card i into startDate
    convert startDate to dateItems
    repeat with n = 1 to 3
      if item n of startDate < 10 then
        put "0"&item n of startDate after temp
      else
        put item n of startDate after temp
      end if
    end repeat
    put temp into field "Start items" of card i
  end repeat
  
  sort this stack by field "Start items"
  
  if which is "priority" then
    sort this stack by field "priority"
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  openCard
  unlock screen with visual plain
end mouseUp
           kk LightSalmon   C@ A              	        Import Ex  on mouseUp
  put the number of cards into znum
  if (the number of cards = 1) and (field "deadline" is empty) then
    put 1 into firstCard
  else
    answer question "Delete all records first or add to existing?" with "Delete" or "Add" or "Cancel"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Delete" then
      lock messages
      lock screen
      repeat with i = znum down to 2
        set cursor to busy
        delete card i
      end repeat
      put 1 into firstCard
      clearCardOne
      put false into renumberTasks
      unlock screen with visual plain
    else
      go card znum
      if znum = 1 then
        put 1.5 into znum
      end if
      put znum into firstCard
      put true into renumberTasks
    end if
  end if
  answer "Import Task Tracker or Palm file?" with "Palm" or "Task Tracker"
  if it is "Palm" then
    importPalm firstCard, renumberTasks -- in this script
  else
    importRecords firstCard, renumberTasks -- in this script
  end if
  setArrows
  openCard
  unlock screen with visual plain
  set cursor to watch
  save this stack
end mouseUp

on  importRecords  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a task records file to import." with "task_records.txt"
  if the result is "Cancel" then exit to metacard
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    if word 1 of temp <> "Entered" then
      answer error "This is not a valid task records file. Try again."
      close file fileName
      exit to metaCard
    end if
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into field "Date"
      put item 2 of zline into field "deadline"
      put item 3 of zline into field "donedate"
      put item 4 of zline into field "priority"
      
      put item 5 of zline into tNotes
      repeat while offset(" | ",tnotes) > 0
        put offset(" | ",tnotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of tnotes
      end repeat
      put tnotes into field "Notes"
      
      put item 6 of zline into enotes
      repeat while offset(" | ",enotes) > 0
        put offset(" | ",enotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of enotes
      end repeat
      put enotes into field "task"
      
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importRecords

on  importPalm  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a palm calendar file to import." with "calendar export.txt"
  if the result is "Cancel" then exit to metacard
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    repeat with i = 1 to znum
      if line i of temp is empty then beep next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      -- if NOT item 1 of zline is a date then next repeat
      put the long date into field "date"
      put item 1 of zline into field "task"
      put item 2 of zline into zdate
      convert zdate to long date
      put zdate into field "deadline"
      --  put item 3 of zline into field -- days before??  "start time"
      put item 4 of zline into field "donedate"
      put item 5 of zline into zpriority
      switch zpriority
      case "Highest"
        put 1 into field "priority"
        break
      case "High"
        put 2 into field "priority"
        break
      case "Medium"
        put 3 into field "priority"
        break
      case "Low"
        put 4 into field "priority"
        break
      case "Lowest"
        put 4 into field "priority"
      end switch
      put item 6 of zline into field "notes" -- category 1
      put return & item 7 of zline after field "notes" -- category 2
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importPalm
           kk LightSalmon    U A              	        Export Ex  Non mouseUp
  global gElapsed
  
  if the number of cards is 1 and field "date" is empty then
    answer information "There are no records to export."
    exit mouseUp
  end if
  
  answer question "Export to Task Tracker or Palm?" with "Cancel" or "Palm" or "Task Tracker " 
  if it is "cancel" then exit mouseUp
  unlock screen
  if it is "Palm" then
    answer question "Export just this contact or all contacts?" with "Cancel" or "Just this one" or "All"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Just this one" then
      put the number of this card into whichCard
    else
      put "all" into whichCard
    end if
    
    ask file "Save records as... " with "palm_tasks.txt"
    if the result is "Cancel" then exit mouseUp
    unlock screen
    put checkExt(it) into fileName
    put empty into whichDate
    
    -- save data from all cards to txt file
    open file fileName for write
    if the result is empty then
      lock messages
      lock screen
      put true into noRecords
      if whichCard is "all" then
        repeat with i = 1 to the number of cards
          set cursor to busy
          go card i
          put field "deadline" into temp
          if temp is not empty then delete item 1 of temp
          put field "donedate" into temp2
          if temp is not empty then delete item 1 of temp2
          put field "priority" into zpriority
          switch zpriority
          case 1
            put "Highest" into temp3
            break
          case 2
            put "High" into temp3
            break
          case 3
            put "Medium" into temp3
            break
          case 4
            put "Low" into temp3
          end switch
          
          write field  "task" & tab & temp & tab & "0" & tab & temp2 & tab & temp3 \
              & tab & "from Task Tracker" & tab & return to file fileName
        end repeat
      else
        
        put field "deadline" into temp
        if temp is not empty then delete item 1 of temp
        put field "donedate" into temp2
        if temp is not empty then delete item 1 of temp2
        put field "priority" into zpriority
        switch zpriority
        case 1
          put "Highest" into temp3
          break
        case 2
          put "High" into temp3
          break
        case 3
          put "Medium" into temp3
          break
        case 4
          put "Low" into temp3
        end switch
        
        write field  "task" & tab & temp & tab & "0" & tab & temp2 & tab & temp3 \
            & tab & "from Task Tracker" & tab & return to file fileName
      end if
      setarrows
      saveData
      unlock screen with visual plain
      close file fileName
    else
      answer "There was a problem saving this file." & return & the result & return & sysError()
    end if
    exit mouseUp
  end if
  answer question "Export all records or specific records?" with "All" or "Specific" or "Cancel"
  if it is "Cancel" then exit mouseUp
  put it into exportWhich
  put empty into completed
  put the short date into whichDate
  if it is "Specific" then
    answer question "Export old records, new records or completed records?" with "New" or "Old" or "Completed" or "Cancel"
    if it is "Cancel" then exit mouseUp
    put it into exportWhich
    unlock screen
    if exportWhich is "completed" then
      put true into completed
      put empty into whichDate
      ask file "Save records as... " with "completed_tasks.txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
    end if
    
    if exportWhich is "New" then
      ask "Export records newer than what date?" with whichDate
      if it is empty then exit mouseUp
      unlock screen
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "task_records_newer_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
    
    if exportWhich is "Old" then
      ask "Export records older than what date?" with whichDate
      if it is empty then exit mouseUp
      unlock screen
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "task_records_older_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
  end if
  
  if exportWhich is "all" then
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save records as... " with "all_task_records_" & whichDate & ".txt"
    if the result is "Cancel" then exit mouseUp
    put checkExt(it) into fileName
    put empty into whichDate
  end if
  unlock screen
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    put true into noRecords
    write "Entered" & tab & "Deadline" & tab & "Completed" & tab & "Priority" & tab \
        & "Task Decription" & tab & "Notes" & return to file fileName
    repeat with i = 1 to the number of cards
      set cursor to busy
      go card i
      put true into exportRecord
      if completed <> empty then
        if  field "donedate" is empty then
          put false into exportRecord
        end if
      end if
      if whichDate<> empty then
        put field "start date" into startDate
        convert startDate to seconds
        if exportWhich is "New" then
          if startDate <= whichDate then
            put false into exportRecord
          end if
        else -- exportWhich is "old"
          if startDate >= whichDate then
            put false into exportRecord
          end if
        end if
      end if
      if exportRecord then
        put false into noRecords
        
        put field "notes" into tnotes
        repeat while offset(return,tnotes) > 0
          put " | " into char offset(return,tnotes) of tnotes
        end repeat
        
        put field "task" into enotes
        repeat while offset(return,enotes) > 0
          put " | " into char offset(return,enotes) of enotes
        end repeat
        
        write field  "Date" & tab & field "deadline" & tab & field "donedate" & tab &  \
            field "priority" & tab & tnotes & tab & enotes & return to file fileName
      end if
    end repeat
    setarrows
    saveData
    unlock screen with visual plain
    close file fileName
    
    if  noRecords then
      answer information "No records were found to export."
    end if
    
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
           kk LightSalmon   CU A              	        Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
   kk LightSalmon    j A              	        Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "tHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "task tracker", helpStack, zStack
end mouseUp
   kk LightSalmon   Cj A              	        Quit ux   (on mouseUp
  quitSBTracker
end mouseUp
   kk LightSalmon     A      Quit          	        Save Ux   Kon mouseUp
  set cursor to watch
  save this stack
  saveData
end mouseUp
   kk LightSalmon   C A              	        Tasks To Do Lists Ex  on mouseUp
  if the number of cards is 1 and field "task" is empty then
    answer information "There are no records to report."
    exit mouseUp
  end if
  lock screen
  checkCompleted
  checkData
  if the openStacks contains "tLists" then close stack "tLists"
  setHeight "tLists"
  topLevel "tLists"
  setLoc "tLists"
  send mouseUp to button "create report" of stack "tLists"
  unlock screen with visual plain
end mouseUp
   kk LightSalmon                  	        Today Ex  
 >on mouseUp
  put the long date into field "date"
end mouseUp
   kk LightSalmon    d  (              	       	 Edit Ex  
 7on mouseUp
  send mouseUp to field "date"
end mouseUp
   kk LightSalmon      (              	       
 Choose Ex  
}on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "date" into gStartDate
  put "date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose an Entered Date"
  modal stack "dates"
end mouseUp
   kk LightSalmon      2              	     
   start items  !h          t                  F Today Ex  
 Bon mouseUp
  put the long date into field "deadline"
end mouseUp
   kk LightSalmon    e 9 (              	       G Edit Ex  
 ;on mouseUp
  send mouseUp to field "deadline"
end mouseUp
   kk LightSalmon     9 (              	       H Choose Ex  
on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "deadline" into gStartDate
  put "deadline" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Deadline"
  modal stack "dates"
end mouseUp
   kk LightSalmon     9 2              	       I 	Priority )}  on menuPick which
  switch which
  case "Urgent"
    put 1 into field "priority"
    break
  case "High"
    put 2 into field "priority"
    break
  case "Medium"
    put 3 into field "priority"
    break
  case "Low"
    put 4 into field "priority"
  end switch
end menuPick
           kk LightSalmon            High    Urgent
High
Medium
Low        	   	       M Today Ex  
 Bon mouseUp
  put the long date into field "donedate"
end mouseUp
   kk LightSalmon    d j (              	       N Edit Ex  
 ;on mouseUp
  send mouseUp to field "donedate"
end mouseUp
   kk LightSalmon     j (              	       O Choose Ex  
on mouseUp
  global gDateField,gStack,gStartDate
  
  get the loc of this stack
  add 150 to item 1 of it
  subtract 20 from item 2 of it
  set the loc of stack "dates" to it
  
  put field "donedate" into gStartDate
  put "donedate" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Done Date"
  modal stack "dates"
end mouseUp
   kk LightSalmon     j 2              	     
  Q 	priority  h         0   P          2    
Main Menu }    ^on menuPick which
checkCompleted
  set cursor to watch
  goSBTrackerStack which
end menuPick
   kk LightSalmon    
       Small Business Tracker Menu   Activity && Expense Tracker
Contact Tracker - Address Book
Schedule Tracker - Calendar
(Task Tracker - To Do List
-
Inventory Tracker
Invoice Tracker
Password Tracker
Vehicle Expense Tracker
-
Universal Calculator
Version Tracker
Writer's Helper
Small Business Tracker Welcome
       	        Add to Schedule Ex  on mouseUp
  global gUseBlankRecord,gSkipChooseDate
  put true into gUseBlankRecord
  put true into gSkipChooseDate
checkCompleted
  put field "task" into ztask
  put field "notes" into znotes
  put field "deadline" into zdate
  lock screen
  if the openStacks contains "Scheduler" then close stack "Scheduler"
  get the loc of this stack
  if item 1 of it = 210 then
    add 395 to item 1 of it
    set the loc of stack "scheduler" to it
  end if
  topLevel "scheduler"
  unlock screen with visual plain
  send mouseUp to button "new" of stack "scheduler"
  put ztask into field "event" of stack "scheduler"
  put zdate into field "date" of stack "scheduler"
  put znotes into field "notes" of stack "scheduler"
end mouseUp
   kk LightSalmon                   	        tLists   on closeCard
  global gDontSave
  put true into gDontSave
  if the visible of group "font" then hide group "font"
end closeCard
  w        Black ک Wheat ffffff      white       	darkgray    
 ?         Tasks To Do Lists      U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial   U 
Helvetica  	 U 
Helvetica   U GarthGraphic Italic   U Impact   U Monaco   U Arial   U Andale Mono   U C Helvetica Condensed  
 U C Helvetica Condensed       	P 0on closeCard
  hide group "font"
end closeCard
           ?&                                  options   i         
  2   
Urgent Tasks @D  	on mouseUp
  if the hilite of me then
    set the disabled of button "priority" to true
    set the hilitedButtonName of group "sort" to "task"
  else
    set the disabled of button "priority" to false
  end if
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon     % h              	      
List Options  D    kk LightSalmon      h              	      
All tasks @d   ron mouseUp
  set the disabled of button "priority" to false
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon    s  m      Uncompleted          	     
Completed @D   ron mouseUp
  set the disabled of button "priority" to false
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon    s % d              	      Create Report Ex  on mouseUp
  global gTaskLength,gTaskTabs
  
  if gTaskLength is empty then put 70 into gTaskLength
  
  if the hilitedButtonName of group "options" is empty then
    set the hilitedButtonName of group "options" to "All tasks"
  end if
  if the hilitedButtonName of group "sort" is empty then
    set the hilitedButtonName of group "sort" to "priority"
  end if
  put  "Priority" & tab & "Task" into temp
  
  if gTaskTabs is empty then
    set the tabstops of field "report" to "50,400,465,600"
  else
    set the tabstops of field "report" to gTaskTabs
  end if
  
  if the hilite of button "show deadlines"  AND the hilite of button "show date entered" then
    put gTaskLength - 15 into TaskLength
    put tab & "Deadline" & tab & "Entered" after temp
  else
    if the hilite of button "show deadlines"  then put tab & tab & "Deadline" after temp
    if the hilite of button "show date entered"  then put tab & tab & "Entered" after temp
    if the hilite of button "show deadlines"  OR the hilite of button "show date entered" then
      put gTaskLength into TaskLength
    else
      put gTaskLength + 20 into TaskLength
    end if
  end if
  put temp & return into field "report"
  
  set the itemDelimiter to tab
  put 1 into sortLine
  put the hilitedButtonName of group "sort" into sortBy
  if sortBy is "Date Entered" then put "date" into sortBy
  
  put true into nodata
  put the number of cards of stack "taskTracker" into zcards
  repeat with i = 1 to zcards
    if zcards > 50 then set cursor to busy
    if field "task" of card i of stack "taskTracker" is empty then next repeat
    if the hilite of button "completed" then
      if field "donedate" of card i of stack "taskTracker" is empty then
        next repeat
      end if
    else
      if field "donedate" of card i of stack "taskTracker" is NOT empty then
        next repeat
      end if
    end if
    put field "priority" of card i of stack "taskTracker" into zPriority
    if the hilite of button "Urgent tasks" AND zPriority <> "1" then next repeat
    
    switch zPriority
    case 1
      put "Urgent" into temp
      break
    case 2
      put "High" into temp
      break
    case 3
      put "Medium" into temp
      break
    case 4
      put  "Low" into  temp
    end switch
    
    put tab & char 1 to TaskLength of field "task" of card i of stack "taskTracker" into ztask
    put ztask after temp
    
    if the hilite of button "show deadlines"  AND the hilite of button "show date entered" then
      put 3 into itemNum
    else
      put 4 into itemNum
    end if
    if the hilite of button "show deadlines" AND\
        field "deadline" of card i of stack "taskTracker" <> empty  then
      put  field "deadline" of card i of stack "taskTracker" into zddate
      convert zddate to short date
      put zddate into item itemNum of temp
      put convertDate(zddate) into item 5 of temp
    end if
    
    if the hilite of button "show date entered"  then
      put field "date" of card i of stack "taskTracker" into zdate
      convert zdate to short date
      put zdate into item 4 of temp
      put convertDate(zdate) into item 6 of temp
    end if
    
    put zPriority into item 7 of temp
    put i into item 8 of temp
    put temp into line sortLine of zSorter
    add 1 to sortLine
    put false into nodata
    
  end repeat
  
  if nodata then
    unlock screen with visual plain
    answer information "There were no tasks found for these options."
    exit to metacard
  end if
  set the itemDelimiter to tab
  sort lines of zSorter by item 2 of each -- always sort by task first
  if sortBy is "priority" then
    sort lines of zSorter  by item 7 of each
  end if
  if sortBy is "deadline" then
    sort lines of zSorter  by item 7 of each -- sort by priority first
    put the number of lines of zSorter into zLines
    put empty into temp
    repeat with i = 1 to zLines
      if item itemNum of line i of zSorter is empty then
        put line i of zSorter & return after temp2
      else
        put line i of zSorter & return after temp
      end if
    end repeat
    sort lines of temp by item 5 of each
    put temp & temp2 after field "report"
    exit mouseUp
  end if
  if sortBy is "date" then
    --   if the hilite of button "show deadlines"  then
    sort lines of zSorter by item 6 of each
    --  else
    --   sort lines of zSorter by item 5 of each
    --   end if
  end if
  put zSorter after field "report"
end mouseUp

function convertDate zdate
  convert zdate to dateitems
  -- set the itemDelimiter to comma
  put item 1 of zdate into temp
  if item 2 of zdate < 10 then
    put "0" & item 2 of zdate after temp
  else
    put item 2 of zdate after temp
  end if
  if item 3 of zdate < 10 then
    put "0" & item 3 of zdate after temp
  else
    put item 3 of zdate after temp
  end if
  return temp
end convertDate
   kk LightSalmon     t             	         sort   i          H   
Date Entered @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon    6 h              	      	Deadline @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon      R              	      	Priority @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon      F              	      Sort By  D    kk LightSalmon     L              	      Task @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon    6 :              	     Show Date Entered @E  on mouseUp
  if the hilite of me then
    set the disabled of button "date entered" to false
  else
    set the disabled of button "date entered" to true
    set the hilitedButtonName of group "sort" to "task" -- "priority"
  end if
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon     %               	       Show Deadlines @E  	on mouseUp
  if the hilite of me then
    set the disabled of button "deadline" to false
  else
    set the disabled of button "deadline" to true
    set the hilitedButtonName of group "sort" to "task"
  end if
  send mouseUp to button "create report"
end mouseUp
   kk LightSalmon                    	    
   instruction 	  
        8            ZClick any options to get an updated list. Click an item in the list to go to that record.    bg  @h    kk LightSalmon    	 + E            	   	        font   a         4   font bg E`  kk LightSalmon     ,             	        bgrect   K@              v    
   fonts  )x   won mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "report" to line temp of me
end mouseUp
                      
.Keyboard  
AGaramond  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  B Friz Quadrata Bold  C Helvetica Condensed  	Capitals  CB Helvetica Condensed Bold  	Charcoal  Chicago  Comic Sans MS  Courier  Courier New  
FrenchScript  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  
Helvetica  Impact  	Kidprint  L Helvetica Light  LB Helvetica Black  
Lydian MT  Minion Web  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  	Palatino  Sand  Swing  Swis721 BdCn BT  Swis721 BdCnOul BT  Swis721 BdOul BT  Swis721 BdRnd BT  Swis721 BlkCn BT  Swis721 BlkOul BT  Swis721 BlkRnd BT  Swis721 BT  Swis721 Hv BT  Swis721 It BT  Swis721 LtCn BT  Swis721 Th BT  Symbol  Techno  Tekton  Tekton Bold  Textile  Times  Times New Roman  
Trebuchet MS  Verdana  	Webdings  
Wingdings  Zapf Dingbats       	`    @        Close Ex   `on mouseUp
  lock screen
  hide group "font"
  unlock screen with visual wipe left
end mouseUp
   kk LightSalmon     L              	     
   inst 	                      +Pick a font face and size for your report.    sizes   i   on mouseUp
  set the textSize of field "report" to word 1 of the hilitedButtonName of me
  put the textHeight of field "report" into field "lheight"
end mouseUp
         z K   9 pt @D  kk LightSalmon     8              	      10 pt @D  kk LightSalmon     8              	     11 pt @D  kk LightSalmon     8              	      12 pt @D  kk LightSalmon     8              	      14 pt @D  kk LightSalmon     8              	      16 pt @D  kk LightSalmon     8              	   
   label3 	         ]N ,           jAfter making changes to the font or size, you may need to adjust the tabs and other numbers to the right. 
   label2 
          T             Line Height 
   lheight  7)x  on mouseUp
  put field "lheight" into temp
  put the hilitedButtonName of group "sizes" into tsize
  ask "Enter a new line height > " & tsize &"." with temp
  if it is empty or it is not a number or it < tsize then
    answer information "You must enter a number larger than the font size."
    exit mouseUp
  end if
  put it into field "lheight"
  set the textHeight of field "report" to it
end mouseUp
         '            13    Tabs Ex  on mouseUp
  global gTaskTabs
  answer question "Set the tab stops to" with "Default" or "Custom"
  switch it
  case "Default"
    if the hilite of button "show deadlines"  AND the hilite of button "show date entered" then
      set the tabstops of field "report" to "50,400,465,600"
    else
      set the tabstops of field "report" to "50,450,600,700"
    end if
    put the tabstops of field "report" into gTaskTabs
    break
    
  case "Custom"
    if gTaskTabs is empty then put the tabstops of field "report" into gTaskTabs
    ask "Set the tab stops of the report field to" with gTaskTabs
    if it is empty then exit mouseUp
    put true into flag
    repeat with i = 1 to 3
      if item i of it is a number then
        put true into flag
      else
        put false into flag
      end if
    end repeat
    if flag then
      set the tabstops of field "report" to it
      put it into gTaskTabs
    end if
  end switch
end mouseUp
   kk LightSalmon    4              	     
   TaskLength  7)x  Qon mouseUp
  global gTaskLength
  ask "Enter a new number of characters for each task." with gTaskLength
  if it is empty or it is not a number then
    answer information "You must enter a number ."
    exit mouseUp
  end if
put it into field "TaskLength"
  put it into gTaskLength
  send mouseUp to button "create report"
end mouseUp
        '            70 
   label5 
         L ,           Characters  	per task    
Default Font Ex   on mouseUp
  set the hilitedButtonName of group "sizes" to "10 pt"
  send mouseUp to group "sizes"
  set the textfont of field "report" to  "Arial"
  send mouseUp to button "font"
end mouseUp
   kk LightSalmon    `              	     
   report 	x 	 
 )on mouseUp
  goReportLine 8
end mouseUp
        	 X+8 
 
 
 
    2X                	`    @ # Y 6    size   a         ` Z
   short  )h 	 
       d  <           button "Help"	48,410,120,431  &button "Close Window"	129,410,261,431  $button "Save as..."	270,410,358,431  button "Font"	368,410,440,431  button "Print"	449,410,521,431  field "report"	9,88,564,400       	`    @ s e  : 
   long  )h 	 
       d  <           button "Help"	48,520,120,541  &button "Close Window"	129,520,261,541  $button "Save as..."	270,520,358,541  button "Font"	368,520,440,541  button "Print"	449,520,521,541  field "report"	9,88,564,508       	`    @  e  :    putLong Ex  
;on mouseUp
  put "long" into whichField
  put empty into field whichField
  repeat with i = 1 to 5
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field "report" & tab & the rect of field "report" after field whichField
end mouseUp
   kk LightSalmon     :              	        setLong Ex  
kon mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
   kk LightSalmon     :              	        	putShort Ex  
<on mouseUp
  put "short" into whichField
  put empty into field whichField
  repeat with i = 1 to 5
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field "report" & tab & the rect of field "report" after field whichField
end mouseUp
   kk LightSalmon     :              	        	setShort Ex  
lon mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
   kk LightSalmon   G  :              	        Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "tHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "tasks to do lists", helpStack, zStack
end mouseUp
   kk LightSalmon    0 H             	        
Close Window Ex   |on mouseUp
  global gStack
  lock screen
  close this stack
  goStack gStack
  unlock screen with visual plain
end mouseUp
   kk LightSalmon                  	        Save as... Ux  on mouseUp
  
  put the date into whichDate
  put the date into temp
  repeat while offset("/",temp) > 0
    put "_" into char offset("/",temp) of temp
  end repeat
  ask file "Save task list as... " with "task_list_" & temp & ".txt"
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    put field "report" into temp
    write "List of tasks as of " & whichdate & return & line 1 of temp & return to file filename
    set itemdelimiter to tab
    repeat with i = 2 to the number of lines of temp
      delete item 6 to 8 of line i of temp
      write line i of temp & return to file filename
    end repeat

    # --  write line 1 of field "report" & return to file filename
    # set itemdelimiter to tab
    # repeat with i = 2 to the number of lines of field "report"
      # put item 8 of line i of field "report" into zCard
      # --   answer zcard && length(zcard) with "cancel" or "continue"
      # --   if it is "cancel" then exit repeat--**
      # put field "Priority" of card  zCard of stack "tasks" && "Priority -" & tab & \
          # field "task" of card  zCard of stack "tasks" & return into temp
      
      # if the hilite of button "show deadlines"  then
        # put field "deadline" of card zCard of stack "tasks" into zdate
        # convert zdate to short date
        # put "Deadline - " & zdate & tab after temp
      # end if
      
      # if the hilite of button "show date entered"  then
        # put field "date" of card i of stack "tasks" into zdate
        # convert zdate to short date
        # put "Date Entered - " & zdate after temp
      # end if
      
      # write temp & return & return to file filename
    -- end repeat
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
   kk LightSalmon    X             	        Font Ux  on mouseUp
  global gTaskLength
  lock screen
  put the fontNames into field "fonts"
  sort field "fonts"
  repeat with i = 1 to the number of lines of field "fonts"
    if the textfont of field "report" is line i of field "fonts" then
      set the hilitedlines of field "fonts" to i
      exit repeat
    end if
  end repeat
  put gTaskLength into field "TaskLength"
  put the textHeight of field "report" into field "lheight"
  show group "font"
  unlock screen with visual wipe right
end mouseUp
   kk LightSalmon   p H             	        Print Ux   &on mouseUp
  printReport
end mouseUp
   kk LightSalmon    H             	        tHelp   on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
  hide group "devtools"
end closeStack

on closeCard
  -- trap
end closeCard

  w        Black ک Wheat ffffff      white       	darkgray    !w             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica    About Help   	@          w       	Tutorial   	@          w       
Task Tracker   	@          w       Tasks To Do Lists   	@          w       Preferences   	@          w       Keyboard Shortcuts   	@          w      & Font   	@          w    / Adding a New Record   	@          w    1 Adjusting the Date   	@          w    3 Background Color   	@          w     Button Colors   	@          w    : Choose Date   	@          w    D Default Settings   	@          w    H Deleting Records   	@          w    I 
Edit Date   	@          w    M Exporting Records   	@          w     
First Record   	@          w    V Highlight Color   	@          w    W Importing Records   	@          w     Last Record   	@          w    Z Look and Feel   	@          w     Next Record   	@          w     Prev Record   	@          w    g Quit   	@          w    h 	Record #   	@          w    i 
Registration   	@          w     Save As...   	@          w    n Save Record   	@          w    o Searching Records   	@          w     Sorting Records   	@          w    z 
Today's Date   	@          w    { Visual Effects   	@          w     Help Index   	@          w    !               help   i          t
   main  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(         Tasks To Do Lists 
  @          
  @          bEasily create lists of tasks by clicking the Tasks To Do Lists button in the Task Tracker window. 
       -
     - 
     > 
 @      Red  M    You can list Uncompleted, Completed or just Urgent Tasks by clicking the appropriate radio button at the top of the Tasks To Do Lists window. 
       
      
     $ 
     , 
     8 <
 @      Red  t 
         The list can show just the task description and priority, or you can choose the options of Show Deadlines and Show Date Entered. 
       [
     [ 
     i 
     n   
         The list can be sorted by clicking one of the Sort By radio buttons. The choices are Priority, Deadline, Task and Date Entered.  If You can only sort by Deadline or Date Entered if the Show Deadlines or Show Date Entered  options are checked. 
       U
     U 
     m 
     r 
      
      
      
      
      
      
      
      
         BClick any task in  the list to go directly to that task's record.    The font face, size, line height and tab stops of the list can be modified by clicking the Font button. See Font  for more information. 
       [
     [ 
     _ 

 @      Blue  l 
     p    :You can print the task list by clicking the Print button. 
       ,
     , 
     1    `To save the list as a text file for importing into another program click the Save as... button. 
       M
     M 

     W      
Task Tracker 
  @          
  @          IThe Task Tracker window is where you will add all your task information. 
 @        Black    
 @      red   
 @        Black   0   Each "record" in Task Tracker consists of the date the task was entered, the task deadline, the date completed, its priority, a task description, and task notes. You can add new records or edit the information for any record at any time.   The date Entered field is automatically filled in. If it is incorrect, you can click on the field, or the Edit button, to enter another date. Enter the current date by clicking the Today button. You can also use the date chooser by clicking Choose. For more information see Adjusting the Date and Choose Date. You can go directly to the first record with a particular date by clicking the Entered label.  
       
      
      Z
     j 
     n G
      
      7
      
      
  @      
    $ 
  @     ) 
    4 
    6 N
     
       
  @          You may set the Priority for the task by choosing one of the four options from the pull down menu. High priority is the default, but you can change it to Medium, Low or Urgent. 
       
      
      K
     c 
     g 3
      
      
      
         Type a task description directly into the Task Description field. This information will be used in the task lists. See Tasks To Do Lists  for more information. 
       )
     ) 
     : =
 @      Blue  w 
         7You can enter notes of any length in the Notes field.  
       (
     ( 
     .   
         0Adding, Deleting, Searching and Sorting Records 
  @        /  
  @         sTo add a new record click the New button. The Entered date will automatically be filled in. Select a Priority from the pull down menu. Then enter a Task Description. You may also enter any Notes before, during or after the task is completed. If the task has a deadline, enter that date into the Deadline field. When the project is completed, fill in the Completed field. 
       
      
     ! 

     . 
     5 0
     e 
     m '
      
      
      
      e
    ' 
    / 3
    b 	
    k   <You may delete one or all of the records by clicking the Delete button. You will be asked if you want to delete just the record you are on, all records, or just those older than a certain date. If you choose the last option you will be asked for a date. You may want to export the records, before deleting them all. 
       9
     9 
     ?    Search for text in any record by clicking Find. You can search for the first few characters of a word or complete words. You may also limit your search to words with the exact capitalization as the word you enter, by clicking "case sensitive". 
       *
     * 
     .   
         You can sort records by clicking the Sort button. You will be asked if you want to sort the records by Date Entered, Priority or Deadline. All records are renumbered after sorting. 
       %
     % 
     ) `
      
      *  
         Import and Exporting Records 
  @           You can import or export the records to a tab delimited text file by clicking the Import or Export button. There are a couple of reasons you might want to do this: 
       R
     R 
     X 
     \ 
     b A  
         1) Rather than archiving the whole program, you might want to export all the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.    M3) If you use the Palm Desktop program, you can import or export your tasks.    The exported file is called task_records.txt with contains the data for all the records. You can change this name if you wish. Be sure to make a note of its location.  
       
 @      Red   
     , S
 @      Blue   (   You can export one or all records, or records that are newer or older than a certain date. See Exporting Records for more information. 
       _
  @      _ 
     p   
         Other Buttons 
  @        
   cEasily create lists of tasks by clicking the Tasks To Do Lists button in the Task Tracker window.  
       -
 @      Blue  - 
     > 
 @      Red  M 
     a   vYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Schedule Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q {
      
      
      
      4
     
     
    % 
    ) /
 @      Blue X X
     0
     
        The Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Time Format. For more information see Preferences. 
       
      
     	 
  @       
     1 p
  @       
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
         /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    The Report button makes it easy to save a list of changes for a particular project to a text file for importing into other programs. See Report  for more information. 
       
      
 @        Black   
      
     " a
      
 @      blue   
         mThe Save button saves your data. All records are saved automatically when going to another record or window. 
       
      
      d   The Quit button saves the data and quits the program. You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      .
     6 n         	Tutorial 
  @          
  @          NHere's a quick tutorial for those just getting started with the Task Tracker. 
 @        Black    M   Each "record" in Task Tracker consists of the date the task was entered, the task deadline, the date completed, its priority, a task description, and task notes. You can add new records or edit the information for any record at any time.   sTo add a new record click the New button. The Entered date will automatically be filled in. Select a Priority from the pull down menu. Then enter a Task Description. You may also enter any Notes before, during or after the task is completed. If the task has a deadline, enter that date into the Deadline field. When the project is completed, fill in the Completed field. 
       
      
     ! 

     . 
     5 0
     e 
     m '
      
      
      
      e
    ' 
    / 3
    b 	
    k    You can easily enter or adjust the dates at any time by clicking the Today, Edit, or Choose buttons. For more information see Adjusting the Date.  
       E
     E 
     J 
     L 
     P 
     U 
     [ #
  @      ~ 
         View a list of uncompleted tasks by clicking the Task Lists button. There are several options in this window for displaying and sorting the tasks. You can also save them to a text file or Print them. See Task Lists  for more information. 
       0
     0 
     ; 
      
      
 @      Blue   

        
         Other features: 
  @           cEasily create lists of tasks by clicking the Tasks To Do Lists button in the Task Tracker window.  
       -
 @      Blue  - 
     > 
 @      Red  M 
     a   
 @      Red     rYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Task Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q w
      
      
      
      4
     
     
    ! 
    % /
 @      Blue T X
     0
     
        Search for text in any record by clicking the Find button. You can search for the first part of a word (partial words) or one or more whole words. If capitalization matters, click the "case sensitive" button. 
       .
     . 
     2   
         Sort all the records by deadline, priority or date entered by clicking the Sort button. You will be asked which to choose which field to sort by. 
       K
     K 
     O B   Delete one or all of the records by clicking the Delete button. You will be asked which records you want to delete. For more information see Deleting Records. 
       1
     1 
     7 V
  @         You may want to export the records by clicking Export. You can then import the data into a spreadsheet or word processing program. You can export the data for archiving purposes too. You can Import the saved data back into Task Tracker at any time. You will want to export your data when updating to a newer version of Task Tracker. For more information see Exporting Records and Importing Records. 
       /
     / 
     5 
      
      
  @     f 
    w 
  @     | 
       
         To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _   
         To access the Preferences window, click the Prefs button. You can change the highlight, button and background colors, time format, etc. For more information see Preferences. 
       ,
     , 
     1 p
  @         
        You can close the current window by using the Control + w (or command + w on the Mac) key combination. It is usually better to use the Close Window button, if there is one, or choose another tool from the Small Business Tracker Menu instead of using this shortcut though. 
       
      
      :
      
      '   The Save button saves your data. All records are saved automatically when going to another record or when you Quit the program. You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      f
     n 
     r |  
         5To access the help system, click on the Help button. 
       (
     ( 
     ,    \For more information, check the Help Index or any of the buttons at the top of this window. 
        
 @        Black    

     * 1  
         You can use the Save As... button below, to save any or all of the text in the help system, as either a .txt or .html file, for reading or printing. Saving the text in .html format allows you to view the formatted help text in your web browser. 
       
      
      z
 @      Blue   _  
               xx   W Importing Records 
  @           You can import previously exported records by clicking the Import button in the Task Tracker window. First you will be asked if you want to Delete all existing records before importing or Add the imported records to the existing ones. 
       ;
     ; 
     A 
 @      Red  \ 
 @        Black  ] 
     c )
      
      *
      
      +  
         You then will be asked if you want to import a Task Tracker or a Palm export file. Next you will be asked to locate the text file to import.  
         
         To export records from the Palm Desktop program, choose Export from the File menu, select Tasks from the Which Module menu, choose Tab & return from the Delimiters menu and then click OK. 
          ,See Exporting Records for more information. 
       
  @       
          M Exporting Records 
  @          You can export the records to a text file by clicking the Export button. First you will be asked if you want to export to a Task Tracker file or a Palm file. If you want to import your tasks into the Palm Desktop program then choose Palm. Otherwise choose Task Tracker. 
       :
     : 
     @   
         (To import records into the Palm Desktop program, choose Import from the File menu, open the file exported from Task Tracker, select Tasks from the Fields menu, choose Tab & Return from the Delimiters menu and click OK.) 
         
         Next you will be asked if you want export All records or just Specific ones. If you choose All then all records will be exported. Records are exported in a tab delimited format, so they can be easily imported into many other applications. 
       *
     * 
     5 	
     > 
     F 
     [ 
     ^ $
 @      Blue   l   If you choose Specific you will then be asked if you want to export Old records, New records or Project records. If you click the Project button, only records for the project on the current record will be exported. 
       
      
      .
     D 
     G 

     Q 
     T 
     ` 
     g 
      
      M   If you choose New, you will be asked to enter a date. Only records newer than that date will be exported. Using this feature allows you to export just the records for the last week (for example) so that they can be sent to an administrator for importing. 
       
      
        
         If you choose Old, you will also be asked to enter a date. Only records older than that date will be exported. This feature is useful if you want to delete old records, but want to export and archive them first. 
       
      
        
         If there are no records found to be exported, you will see a message to that effect, but a file will still be written to disk. To avoid confusion, you may want to delete that file. 
         
         You can export records which have their timer running. However, when these records are imported again, the timer will be paused at the time it was exported. The note "timer running or paused" is added to the exported record. 
       
      :   @There are a couple of reasons you might want to export records: 
  @        ? 1) Rather than archiving the whole program, you might want to export all (or some of) the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.   
  @          M3) If you use the Palm Desktop program, you can import or export your tasks.    The exported file is called task_records.txt which contains the data for all the records in a tab delimited format. You can change this name if you wish. Be sure to make a note of its location. 
       
 @      Red   

  @      ) 
     , n
  @       '       About Help 
  @        
  
  @          Welcome to Task Tracker Help. 
 @        Black       Listed in this Help system are all the features, fields and buttons of Task Tracker. (Buttons are things you click on and fields contain text.) 
         You can click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

      
 @      Blue   Y
    < W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R   
         Each "record" in Task Tracker consists of the date the task was entered, the task deadline, the date completed, its priority, a task description, and task notes. You can add new records or edit the information for any record at any time.    \Use the buttons at the top of this Help window to learn more about the following subjects:  
       #
     # 
     ' 4   The Task Tracker window is where you can make notes about changes you have made to the latest version of your work. You can easily create a report of all the changes made on a particular project. 
       
 @      Blue   
      
 @        Black   
        
         ]The Task Lists window is where you can view, print or save your contact list as a text file. 
       
 @      Blue   

      
 @        Black   
      F  
         The Preferences window is where you can change background and button colors, time formats, and the general "look and feel" of the program.  
       
  @       
      |   jAlmost every button in this program has a keyboard shortcut. For more information see Keyboard Shortcuts. 
       V
  @      V 
     h    IThere's an extensive tutorial available by clicking the Tutorial button. 
       8
  @      8 
     @    iThe newest version of this software is available at http://productivity-software/sbtracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470     & Font 
  @          
         You may want to adjust the font, size or line height of the schedule text by clicking the Font button. Choose a new font by clicking its name in the font list. 
       Z
     Z 
     ^ A  
         Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change.  
         
         Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       3
     3 {  
        You can also set the tab stops of the list text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      !
     @ 
     G 
     \ 
     _ *
      
      
      
      
 @      Blue n O  
         You may also want to adjust the Characters per task number after adjusting the size of the text or the width of the columns in the list. 
        
       
     3 U  
 @      Blue      QReset the font face and size to 10 pt Arial by clicking the Default Font button. 
 @        Black    <
 @        Black  < 
 @        Black  H       
           Keyboard Shortcuts 
  @          
  @          )Many buttons have a keyboard equivalent. 
 @        Black    (  
  @          Shortcuts are indicated by the letter of the button that is underlined. Just press the letter on your keyboard to activate the button.    cIf a keyboard shortcut does not work, try pressing the tab key and then the shortcut letter again. 
  @        b   If you are typing notes, many of the following shortcuts will not work unless you also hold down the Alt key (or the command key on the Macintosh).   CYou can also use the Tab key to move between most of the buttons and editable fields of each window. (Buttons are things you click on, fields are places where text is entered or displayed.) Buttons will appear with a dotted rectangle when they are active. Then you can press the return or enter key to activate the button.    In any field that you can type in, you can also use the standard Cut (Ctrl - x), Copy (Ctrl - c) and Paste (Ctrl - v) keyboard shortcuts.    Task Tracker window shortcuts: 
 @        Black    
      
 New - n  Delete - d  Task Lists - t  	Save - s  	Quit - q    Task Lists window shortcuts: 
        	Help - h  Save as - v  	Font - f  
Print - p  	Save - s  Close Window - c  'Move up in list of projects - Up arrow  +Move down in list of projects - Down arrow    Help window shortcuts: 
        About Help - a  Task Lists - l  Task Tracker - r  Keyboard Shortcuts- k  
Tutorial - t  Preferences - p  Help Index - h  Back to Previous Topic - b  Search Help - s  Close Window - c         g Quit 
  @           You can quit (or exit) the program at any time by clicking the Quit button. All data will be saved before quitting. You can quit the program from any window by using the Control + Q (or command + q on the Macintosh) key combination. 
       ?
     ? 
     C        Save As... 
  @        
  You can use the Save as... button at the bottom of this window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. See About Help for more information about printable versions of this Help system. 
       
      

      
 @      Blue   Y
    5 \
  @      

     C  
         YIn the Task Tracker window, the Save as... button exports the Task List to a text file.  
       
 @      Red   
      
       

     * 
     > 	
     G   i 
Registration 
  @          'To register Small Business Tracker, click the Small Business Tracker Menu button and choose Small Business Tracker Welcome. Then click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       .
     . 
     I 
     [ 
     \ 
     { 
      

      
        
         HYou can also review the License Agreement from the Registration window. 
       
      
     )          Preferences 
  @          
  @          <There are several preferences you can set for Task Tracker. 
 @        Black    ;   UTo access the Preferences window, click the Prefs button in the Task Tracker window. 
       ,
     , 
     1 
 @      Red  L 
     S   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
      
      e
     v 

      a
      	
      H
  @     2 
    D    jThe Time Format defaults to AM/PM, but if you would want times displayed in 24 hour format, click 24 Hrs. 
       
      
      Z  You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C   *There is a visual effect that helps to indicate the movement from one record to another in the Task Tracker window when using the arrow buttons or keys. Some people find this effect annoying or slow. Other people think it is great. So you can choose to turn it On or Off in the Preferences window. 
       k
 @      red  k 
     r 
     
     
     
     
  @      
    (   The Open new tools in a different window? button allows you to choose if you want each tool to open in a new, separate window or if you want each new tool to open in the same window as the current tool. Opening new tools in new windows sometimes creates too many open windows on the screen for some people. Some tools, such as the Universal Calculator,  always open in a new window. 
       
      %
     )U   WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <         Prev Record 
  @           {Go the previous record (the record with the next lowest number) by clicking the Prev button (the one with the left arrow). 
       P
     P 
     T &   The First Record and Prev Record buttons are hidden on the first record. You can also use the arrow keys to move from one record to the next or previous record.  
           h 	Record # 
  @          Each Record in Task Tracker has a number. This number may change when you add or delete records. You can go directly to a particular record by clicking the Record # field or label. Or you can use the arrow buttons to go the First Record, Prev Record, Next Record or Last Record. 
       *
  @      * 6
     ` <
      
      <
  @       
      
  @       
      
  @       
     
  @     
 
        The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
          See also Visual Effects. 
       	
 @      Blue  	   { Visual Effects 
  @          'There is a visual effect that helps to indicate the movement from one record to another in the Task Tracker window when using the arrow keys. Some people found this effect annoying or slow. Other people thought is was great. So you may now choose to turn it On or Off in the Preferences window. 
       k
 @      red  k 
     r 
     
     
     
     
  @      
    %    See also Record #. 
       	
 @      Blue  	 	  z 
Today's Date 
  @           To easily enter today's date into a record, click the Today button above either the Date Entered, Deadline or Completed field. 
       6
     6 
     ; 
     T #
     w    ^You can go directly to the first record with a particular date by clicking the Entered label. 
       O
     O 
     V      Sorting Records 
  @           You can sort records by Date Entered, Deadline or Priority  by clicking the Sort button in the Task Tracker window.  All records are renumbered after sorting. 
       
      
     . 
     2 
     : 
     L 
     P 
 @      red  ^ 
     r ,    o Searching Records 
  @          You can search records for particular text by clicking the Find button. A dialog will ask for a partial or whole word to search for. You can find the beginning of a word or phrase by using the partial words option. To find an exact word or phrase, use the whole words option. 
       ;
     ; 
     ? 
      

      2
      
        You can also specify that you want your search to be case sensitive (i.e., a search for "UNIX" will not find "unix"). Click the checkbox next to this option to enable it. 
       5
     5 
     C g   [You can go directly to the first record with a particular date by clicking the Date label. 
       N
     N 
     S     n Save Record 
  @           You can save all the data in the record window by clicking the Save button. All data is saved automatically when going to another record or when quitting the program. 
       ?
     ? 
     C c         Next Record 
  @           yGo the next record (the record with the next highest number) by clicking the Next button (the one with the right arrow). 
       M
     M 
     Q '   The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
           Z Look and Feel 
  @        
  aIn the Preferences window, the Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
  @       
      
      

     , e
      

      a
      	
     H
  @     M 
    _          Last Record 
  @           |Go the last record (the record with the highest number) by clicking the Last button (the one with the right arrow and bar). 
       H
     H 
     L /   GThe Last Record and Next Record buttons are hidden on the last record. 
       F    V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the Task Tracker window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O 
 @      red  j 
     q 
      
      F         
First Record 
  @           |Go the first record (the record with the lowest number) by clicking the First button (the one with the left arrow and bar). 
       H
     H 
     M .  
         IThe First Record and Prev Record buttons are hidden on the first record. 
       H        I 
Edit Date 
  @        	   The date can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y W
      
      F  Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date, closes the window and enters that date into the current record. 
       
      
     %       H Deleting Records 
  @          You can delete some or all records by clicking the Delete button. You will be asked if you want to delete Just this one record, Older records or All records. If you choose Older then you will be asked for a date. This feature is useful when you have many old records that you do not need to keep. You will probably want to export the old records first. See Exporting Records for more information. 
       3
     3 
     9 1
     j 

     w 	
      
      
      
      
  @     e 
    v         D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	     : Choose Date 
  @          3One method for changing a date, is to click the Choose button above the date field. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the appropriate field. 
       0
     0 
     6      Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G        1 Adjusting the Date 
  @           The date can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y W
      
      F  
Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the current record. 
       
      
     %       / Adding a New Record 
  @          sTo add a new record click the New button. The Entered date will automatically be filled in. Select a Priority from the pull down menu. Then enter a Task Description. You may also enter any Notes before, during or after the task is completed. If the task has a deadline, enter that date into the Deadline field. When the project is completed, fill in the Completed field. 
       
      
     ! 

     . 
     5 0
     e 
     m '
      
      
      
      e
    ' 
    / 3
    b 	
    k          Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &    About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
   kk LightSalmon      e             	        Keyboard Shortcuts Ex   Oon mouseUp
  lock screen
push card
  go card "Keyboard Shortcuts"
end mouseUp
   kk LightSalmon                   	        	Tutorial Ex   Eon mouseUp
  lock screen
push card
  go card "Tutorial"
end mouseUp
   kk LightSalmon     " P             	        Tasks To Do Lists Ex   Pon mouseUp
  lock screen
  push card
  go card "Tasks To Do Lists"
end mouseUp
   kk LightSalmon    ` "              	        Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
   kk LightSalmon     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
   kk LightSalmon     <              	        Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
   kk LightSalmon     <              	        Search Help Ex  ]on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 320 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack "atFind" to it
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "atFind"
end mouseUp
           kk LightSalmon     l             	        Save as... Ex   on mouseUp
  global gStackName
  
  insert the script of button "SaveHelp" of stack "Launcher" into back
  put "Task Tracker Help" into gStackName
  exportHelp
  remove the script of button "SaveHelp" of stack "Launcher" from back
end mouseUp
   kk LightSalmon     Q              	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
   kk LightSalmon     y             	        	devtools   a         tH    Save Ex   *on mouseUp
  save this stack
end mouseUp
   kk LightSalmon    x Q              	        go next Ex   'on mouseUp
  go next card
end mouseUp
   kk LightSalmon    \x Q              	        delete Ex   +on mouseUp
  delete this card
end mouseUp
   kk LightSalmon   x 2              	        go prev Ex   'on mouseUp
  go prev card
end mouseUp
   kk LightSalmon    x Q              	        
Task Tracker Ex   Kon mouseUp
  lock screen
  push card
  go card "Task Tracker"
end mouseUp
   kk LightSalmon    t  d             	           K        
  f          K           j          K                    K        
   T    
  ! index  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Help  Adding a New Record  Adjusting the Date  Background Color  Button Colors  Choose Date  Default Settings  Deleting Records  
Edit Date  Exporting Records  
First Record  Font  Highlight Color  Importing Records  Keyboard Shortcuts  Last Record  Look and Feel  Next Record  Preferences  Prev Record  Quit  	Record #  
Registration  Save As...  Save Record  Searching Records  Sorting Records  
Task Tracker  Tasks To Do Lists  
Today's Date  	Tutorial  Visual Effects         	`    @ ` Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    New Button EpGon mouseUp
sort this stack by field "main"
  beep
end mouseUp


  repeat with i = 1 to the number of cards
    put empty into field "main" of card i
  end repeat

repeat with i = 1 to the number of lines of field index
  if there is a card line i of field index then next repeat
  else answer line i of field index
end repeat
          `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
        D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
         ` 8             	        reindex and sort EpMon mouseUp
  put empty into field "index"
  repeat with i = 1 to the number of cards
    if char 1 of field "main" of card i <> "x" then
      set the name of card i to line 1 of field "main" of card i
      put line 1 of field "main" of card i  & return after field "index"
    end if
  end repeat
  sort field "index"
end mouseUp
        T               	           K        s  e          K        ^         a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
   ک Wheat    2 @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
   kk LightSalmon    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
   kk LightSalmon     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@  kk LightSalmon      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
   ک Wheat   I  d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
            d  z                
     @                     "Import Task Tracker or Palm file?   z icon BP on mouseUp
end mouseUp
   kk LightSalmon      , (         	      
Task Tracker D`  kk LightSalmon      6 s            	      Palm D`  kk LightSalmon     6 @            	      Delete D`  kk LightSalmon     6 I            	      All D`  kk LightSalmon    6 /            	      y D`  kk LightSalmon     4 '            	      x D`  kk LightSalmon    i 4 '            	      w D`  kk LightSalmon      4 )            	    