#if !defined(__ADOLIB_H)
#define __ADOLIB_H

#undef EOF	//It conflicts with the C library

#include "msado15.tlh"	//#import generated header

using namespace ADODB;	//Get rid of the annoying ns

extern _ConnectionPtr conn;	//Global ADO connection object

void OpenConn(_bstr_t connstr, _bstr_t user = "", _bstr_t pass = "", ConnectOptionEnum opt = adConnectUnspecified);

extern VARIANT vtNull;	//Useful null variant

extern int _cndig;		//Global # of digits for currency 

extern int _nndig;		//Global # of digits for numbers

extern char _cdeci[2];	//Global decimal separator for currency

extern char _ndeci[2];	//Global decimal separator for numbers

void Show(_com_error& e, HWND hWnd = 0); //Error messages	

_variant_t getdate();	//Gets current date/time

_bstr_t shortdate(_variant_t);	//Extracts date from datetime
	
//Converts and formats variants into strings
_bstr_t VarToStr(_variant_t var, int ndec = 0);	

//Wrapper for ADO commands
class AdoCommand : public _CommandPtr {
public:
	//Default ctor
	AdoCommand() {};
	//Creates a command from a string
	bool Create(_bstr_t sql);
	//Executes a command
	_RecordsetPtr Execute();
	//Adds parameters to a command
	void AddParameter(_bstr_t name, _variant_t value, DataTypeEnum type = adInteger, long size = 0);
};

//Wrapper for ADO recordsets
class AdoRecordset : public _RecordsetPtr
{
public:
	//Creates a read-only recordset from a string
	AdoRecordset(_bstr_t sql, bool open = false);
	//Default ctor
	AdoRecordset() {};
	//Copy ctor
	AdoRecordset(AdoRecordset& rs);
	//Creates a read-write recordset from a string
	bool Create(_bstr_t sql);
	//Creates a read-write recordset from a Command
	bool Create(AdoCommand& comm, long opt = adCmdStoredProc);
	//Opens a read-write recordset
	bool Open(_bstr_t sql);
	//Assigns a string to a recordset
	AdoRecordset& operator=(_bstr_t sql);
	Interface* get_rs() const 
	{ 
		return *this; 
	}
	__declspec(property(get=get_rs)) Interface* _rs;
};

#define IN_INT		-4
#define IN_LONG     -5
int InputBox(HWND hWnd, LPSTR title, LPSTR prompt, void* buffer, short len);
int InputBox(HWND hWnd, LPSTR title, LPSTR prompt, CString& buffer, int len = 0);
int InputBox(HWND hWnd, LPSTR title, LPSTR prompt, _bstr_t& buffer, int len = 0);

#endif
