// DiningPhilosophers.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "resource.h"
#include "Report.h"
#include "PhilosopherTask.h"
#include "TableTop.h"

static void let_the_philosophers_dine()
{
	Task* philo_ptrs[N_PHILOSOPHERS];
	PhilosopherId id;

	for (id = 0; id < N_PHILOSOPHERS; id++) {
		philo_ptrs[id] = new PhilosopherTask(id);
	}

	TableTop::end_diner(philo_ptrs);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	int exit_code;

	Report::print("WinMain", "Application started");

	let_the_philosophers_dine();
	Report::wait_for_quit(exit_code);

	return exit_code;
}

