// WindowLog.h: interface for the WindowLog class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_WINDOWLOG_H__F9C35D61_12C6_413F_AE45_6EC9C3ADF3EC__INCLUDED_)
#define AFX_WINDOWLOG_H__F9C35D61_12C6_413F_AE45_6EC9C3ADF3EC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class WindowLog  
{
public:
	// Log Output Functions
	void print(const char *msg);
	const char* get_text();
//	bool save_to_file(const char *path);

	// Window Control Functions
	bool do_paint(HWND hWnd);
	bool do_vscroll(HWND hWnd, int code, short int pos);

	WindowLog(HWND hWnd, int length);
	virtual ~WindowLog();

private:
	void move_log_index(int lines);
	int log_scroll_position();
	int log_page_size();
	void make_new_line_visible();

	char *text;
	int first, next, length;
	int index;
	HWND window;
	HFONT font;
};

#endif // !defined(AFX_WINDOWLOG_H__F9C35D61_12C6_413F_AE45_6EC9C3ADF3EC__INCLUDED_)
