#include <stdio.h>
#include "chartdir.h"

void gapbar(double bargap, const char *filename)
{
	//The data for the bar chart
	double data[] = {100, 125, 245.78, 147, 67};

	//The labels for the bar chart
	const char *labels[] = {"Mon", "Tue", "Wed", "Thu", "Fri"};

	//First, create a XYChart of size 150 pixels x 150 pixels
	XYChart *c = XYChart::create(150, 150);
	
	//Set the plotarea at (25, 20) and dimension 120(w) x 100(h) 
	c->setPlotArea(25, 20, 120, 100);

	//add a title to display to bar gap using 8 point arial font
	char buffer[256];
	sprintf(buffer, "      Bar Gap = %0.2f", bargap);
	c->addTitle(buffer, "arial.ttf", 8);

	//Set the x axis labels using the supplied labels
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//Add a bar chart layer using the supplied data and set the bar gap
	c->addBarLayer(sizeof(data) / sizeof(data[0]), data)->setBarGap(bargap);;

	//output the chart
	c->makeChart(filename);

	//destroy the chart to free up resources
	c->destroy();
}

int main(int argc, char *argv[])
{
	gapbar(0, "gapbar00.png");
	gapbar(0.25, "gapbar25.png");
	gapbar(0.5, "gapbar50.png");
	gapbar(0.75, "gapbar75.png");
	return 0;
}
